function [ Refs, Amps ] = calcECGRefs( AParameter,SParameter )

try

% Init
pqbegin_ref = NaN;
pq2 = NaN;
pqpeak_ref = NaN;
pq3 = NaN;
pqend_ref = NaN;
qtbegin_ref = NaN;
qt3 = NaN;
qtpeak_ref = NaN;
qt2 = NaN;
qtend_ref = NaN;
r_ref = NaN;
q_ref = NaN;
s_ref = NaN;

plot_fac = 100;
    
SParameter.Template.Template = SParameter.Template.Template;
template_length = length(SParameter.Template.Template);
template_upsample = [1:1/100:template_length];

fir_order = round(50*SParameter.SampleFreq/1000);
fir_order = fir_order + rem(fir_order,2);

ableitung_fir = filter(-smooth_diff(fir_order),1,[fliplr(SParameter.Template.Template) SParameter.Template.Template fliplr(SParameter.Template.Template)]);
ableitung_fir = ableitung_fir(template_length+fir_order/2+1:2*template_length+fir_order/2);
ableitung_fir = interp1([1:template_length],ableitung_fir,template_upsample);
ableitung_fir_abs = abs(ableitung_fir);

template = interp1([1:template_length],SParameter.Template.Template,template_upsample);
template_median = median(template);
templateM = template;
template = template - median(template);
% SParameter.Template.debugPlot = 1

if SParameter.Template.debugPlot
    figure
    hold on
    plot(downsample(template_upsample*100-99,plot_fac),downsample(ableitung_fir_abs,plot_fac),'r','linewidth',2)
    plot(downsample(template_upsample*100-99,plot_fac),downsample(template,plot_fac),'k')
end

[pks_max,locs_max] = findpeaks(ableitung_fir_abs,'MINPEAKDISTANCE',round(1000*SParameter.SampleFreq/1000),'SORTSTR','descend');
if locs_max(1) > locs_max(2)
    locs_tmp = locs_max(2);
    locs_max(2) = locs_max(1);
    locs_max(1) = locs_tmp;
end
[pks_min,locs_min] = findpeaks(-ableitung_fir_abs,'MINPEAKDISTANCE',round(1000*SParameter.SampleFreq/1000));
pks_min = -pks_min;
locs_min = locs_min(pks_min<0.3);
[pks_min2,locs_min2] = findpeaks(-ableitung_fir_abs);
pks_min2 = -pks_min2;

dermax = ableitung_fir_abs(locs_max(1));
r_ref = locs_min(locs_min > locs_max(1) & locs_min < locs_max(2));
r_ref_pks = pks_min(locs_min > locs_max(1) & locs_min < locs_max(2));
if length(r_ref) > 1
    r_ref = r_ref(find(min(r_ref_pks)==r_ref_pks));
end

if and(ableitung_fir(r_ref-100) > 1,ableitung_fir(r_ref+100) < 0)
    r_polarity = 1;
else
    r_polarity = 0;
end

% Q Abschtzung
q_ref = find(ableitung_fir_abs(1:locs_max(1))<dermax/5, 1, 'last' );

% Iso-Level Abschtzung
PQ_min = q_ref - 180 / 1000 * SParameter.Template.SampleFreq * 100;
PQ_max = q_ref - 40 / 1000 * SParameter.Template.SampleFreq * 100;

pqpeak_ref = locs_min2(locs_min2 > PQ_min & locs_min2 < PQ_max);
pqpeak_pks = pks_min2(locs_min2 > PQ_min & locs_min2 < PQ_max);

[min_val,min_idx] = min(min(pqpeak_ref):q_ref);

pq_template = template(min_val:q_ref);

diff = NaN * ones(size(pq_template,2)-floor(SParameter.Template.SampleFreq * 100/1000*20),1);
        
for j=1:(size(pq_template,2)-floor(SParameter.Template.SampleFreq * 100/1000*20))
    diff(j) = sum(abs(pq_template(j:j+floor(SParameter.Template.SampleFreq * 100/1000*20)-1)-mean(pq_template(j:j+floor(SParameter.Template.SampleFreq * 100/1000*20)-1))));
end

[min_val,min_idx] = min(diff);
isolevel = mean(pq_template(min_idx:min_idx+floor(SParameter.Template.SampleFreq * 100/1000*20)-1));

RR_sek = SParameter.Template.RRmedian * 1 / SParameter.Template.SampleFreq;

% Suche mgliches Maxima fr R-Zacke -> Feintuning
R_min = r_ref - SParameter.Template.SampleFreq ;
R_max = r_ref + SParameter.Template.SampleFreq;
if r_polarity
    [r2n, r2l] = max(template(R_min:R_max));
else
    [r2n, r2l] = min(template(R_min:R_max));
end
rdiff = r_ref - (r2l + R_min);
if ~isempty(r2n)
    r_ref = r2l + R_min;
end
if length(r_ref) > 1
    r_ref = r_ref(1);
end

% wie normabweichungen -10% + 13%
QT_min = (390*0.90 * sqrt(RR_sek) / 1000 * SParameter.Template.SampleFreq * 100)*3/4 + q_ref;
QT_max = (390*1.13 * sqrt(RR_sek) / 1000 * SParameter.Template.SampleFreq * 100) + q_ref;

% ein Minima im Bereich des QT-Fensters
qtpeak_ref = locs_min2(locs_min2 > QT_min & locs_min2 < QT_max);
qtpeak_pks = pks_min2(locs_min2 > QT_min & locs_min2 < QT_max);
if ~ isempty(qtpeak_ref(qtpeak_pks < 0.01))
    qtpeak_ref = qtpeak_ref(find(max(abs(template(qtpeak_ref)-isolevel)) == abs(template(qtpeak_ref)-isolevel)));
else
    qtpeak_ref = qtpeak_ref(1);
end

% tamp = abs(template(qtpeak_ref)-isolevel);

% ein Maxima nach dem Minima
qt2 = locs_max(locs_max > qtpeak_ref);
qt2_pks = pks_max(locs_max > qtpeak_ref);
qt2 = qt2(find(max(qt2_pks) == qt2_pks));

derpk = ableitung_fir_abs(qt2);
ref_slope = derpk*10/dermax;
% New Schmidt
if ref_slope >= 1
    qtend_slope = 4.5;
elseif ref_slope >= 0.8
    qtend_slope = 3.5;
elseif ref_slope >= 0.6
    qtend_slope = 2.5;
elseif ref_slope >= 0.4
    qtend_slope = 1.9;
elseif ref_slope >= 0.2
    qtend_slope = 1.7;
else
    qtend_slope = 1.4;
end

% if ref_slope >= 0.41
%     qtend_slope = 7;
% elseif ref_slope >= 0.2
%     qtend_slope = 6;
% elseif ref_slope >= 0.13
%     qtend_slope = 5;
% else
%     qtend_slope = 4;
% end

q_slope = 1.8;
if ref_slope >= 6.2
    s_slope = 12;
elseif ref_slope >= 4.75
    s_slope = 9;
elseif ref_slope >= 4
    s_slope = 8;
else
    s_slope = 3;
end
qtbegin_slope = 2.0;
pbegin_slope = 1.35;
pend_slope = 2.0;

% Schwellwert nach Maxima
qtend_ref = find(ableitung_fir_abs(qt2:end)<derpk/qtend_slope)+qt2;
if ~isempty(qtend_ref)
    qtend_ref = qtend_ref(1);
else
    [~,idx_qtend] = min(abs(ableitung_fir_abs(qt2:end)-(derpk/qtend_slope)));
    qtend_ref = idx_qtend + qt2;
end

q_ref = find(ableitung_fir_abs(1:locs_max(1))<derpk/q_slope, 1, 'last' );
s_ref = find(ableitung_fir_abs(locs_max(2):end)<derpk/s_slope, 1 )+locs_max(2);

q_peak = locs_min(and(locs_min < q_ref + SParameter.Template.SampleFreq, locs_min > q_ref - SParameter.Template.SampleFreq));
if ~isempty(q_peak)
    if length(q_peak) > 1
        q_peak = q_peak(end);
    end
    q_polarity = and(ableitung_fir(q_peak-100) > 1,ableitung_fir(q_peak+100) < 0);
    
    % Suche Mgliches Minima fr Q-Zacke -> Feintuning
    Q_min = q_ref - SParameter.Template.SampleFreq ;
    Q_max = q_ref + SParameter.Template.SampleFreq;
    if q_polarity
        [q2n, q2l] = max(template(Q_min:Q_max));
    else
        [q2n, q2l] = min(template(Q_min:Q_max));
    end
    if ~isempty(q2n)
        q_ref = q2l + Q_min;
    end
    if length(q_ref) > 1
        q_ref = q_ref(1);
    end    
end

s_peak = locs_min(and(locs_min < s_ref + SParameter.Template.SampleFreq, locs_min > s_ref - SParameter.Template.SampleFreq));
if ~isempty(s_peak)
    if length(s_peak) > 1
        s_peak = s_peak(1);
    end
    s_polarity = and(ableitung_fir(s_peak-100) > 1,ableitung_fir(s_peak+100) < 0);
    
    % Suche mgliches Maxima fr S-Zacke -> Feintuning
    S_min = s_ref - SParameter.Template.SampleFreq ;
    S_max = s_ref + SParameter.Template.SampleFreq;
    if s_polarity
        [s2n, s2l] = max(template(S_min:S_max));
    else
        [s2n, s2l] = min(template(S_min:S_max));
    end
    if ~isempty(s2n)
        s_ref = s2l + S_min;
    end
    if length(s_ref) > 1
        s_ref = s_ref(1);
    end
end

% Suche mgliches Maxima fr Tpeak -> Feintuning
Tpeak_min = qtpeak_ref - 3*SParameter.Template.SampleFreq ;
Tpeak_max = qtpeak_ref + 3*SParameter.Template.SampleFreq;

if mean(template(Tpeak_min:Tpeak_max)-isolevel) > 0
    t_polarity = 1;
else
    t_polarity = 0;
end
if t_polarity
    [t2n, t2l] = max(template(Tpeak_min:Tpeak_max));
else
    [t2n, t2l] = min(template(Tpeak_min:Tpeak_max));
end
% t2 = locs_min(locs_min > Tpeak_min & locs_min < Tpeak_max);
% t2_pks = pks_min(locs_min > Tpeak_min & locs_min < Tpeak_max);
if ~isempty(t2n)
    qtpeak_ref = t2l + Tpeak_min;
end
if length(qtpeak_ref) > 1
    qtpeak_ref = qtpeak_ref(1);
end

% ein Maxima vor dem Tpeak-Minima
qt3 = locs_max(locs_max > (s_ref+(100 / 1000 * SParameter.Template.SampleFreq * 100)) & locs_max < qtpeak_ref);
qt3_pks = pks_max(locs_max > (s_ref+(100 / 1000 * SParameter.Template.SampleFreq * 100)) & locs_max < qtpeak_ref);
qt3 = qt3(find(max(qt3_pks) == qt3_pks));

% Schwellwert vor Maxima
qtbegin_ref = find(ableitung_fir_abs(s_ref+(100 / 1000 * SParameter.Template.SampleFreq * 100):qt3)>derpk/qtbegin_slope) + s_ref+(100 / 1000 * SParameter.Template.SampleFreq * 100);
if ~isempty(qtbegin_ref)
    qtbegin_ref = qtbegin_ref(1);
else
    [~,idx_pqbegin] = min(abs(ableitung_fir_abs(s_ref + (100 / 1000 * SParameter.Template.SampleFreq * 100):qt3)-(derpk/qtbegin_slope)));
    qtbegin_ref = idx_pqbegin + s_ref +(100 / 1000 * SParameter.Template.SampleFreq * 100);
end

% P-Welle
PQ_min = q_ref - 180 / 1000 * SParameter.Template.SampleFreq * 100;
PQ_max = q_ref - 40 / 1000 * SParameter.Template.SampleFreq * 100;

pqpeak_ref = locs_min2(locs_min2 > PQ_min & locs_min2 < PQ_max);
pqpeak_pks = pks_min2(locs_min2 > PQ_min & locs_min2 < PQ_max);

% Iso-Level Abschtzung
[min_val,min_idx] = min(min(pqpeak_ref):q_ref);

pq_template = template(min_val:q_ref);

diff = NaN * ones(size(pq_template,2)-floor(SParameter.Template.SampleFreq * 100/1000*20),1);
        
for j=1:(size(pq_template,2)-floor(SParameter.Template.SampleFreq * 100/1000*20))
    diff(j) = sum(abs(pq_template(j:j+floor(SParameter.Template.SampleFreq * 100/1000*20)-1)-mean(pq_template(j:j+floor(SParameter.Template.SampleFreq * 100/1000*20)-1))));
end

[min_val,min_idx] = min(diff);
isolevel = mean(pq_template(min_idx:min_idx+floor(SParameter.Template.SampleFreq * 100/1000*20)-1));

if ~isempty(pqpeak_ref(pqpeak_pks < 0.01))
    pqpeak_ref = pqpeak_ref(find(max(abs(template(pqpeak_ref)-isolevel)) == abs(template(pqpeak_ref)-isolevel)));
else
    pqpeak_ref = pqpeak_ref(end);
end


% Suche mgliches Maxima fr Ppeak -> Feintuning
Ppeak_min = pqpeak_ref - 3*SParameter.Template.SampleFreq ;
Ppeak_max = pqpeak_ref + 3*SParameter.Template.SampleFreq;
if mean(template(Ppeak_min:Ppeak_max)-isolevel) > 0
    p_polarity = 1;
else
    p_polarity = 0;
end
if p_polarity
    [p2n, p2l] = max(template(Ppeak_min:Ppeak_max));
else
    [p2n, p2l] = min(template(Ppeak_min:Ppeak_max));
end
% p2 = locs_min(locs_min > Ppeak_min & locs_min < Ppeak_max);
% p2_pks = pks_min(locs_min > Ppeak_min & locs_min < Ppeak_max);
if ~isempty(p2l)
    pqpeak_ref = p2l + Ppeak_min;
end
if length(pqpeak_ref) > 1
    pqpeak_ref = pqpeak_ref(1);
end

% Maximum vor P-Peak
pq2 = locs_max(locs_max < pqpeak_ref & locs_max > (q_ref - 220 / 1000 * SParameter.Template.SampleFreq * 100));
pq2_pks = pks_max(locs_max < pqpeak_ref & locs_max > (q_ref - 220 / 1000 * SParameter.Template.SampleFreq * 100));

if ~isempty(pq2_pks)
    pq2 = pq2(find(max(pq2_pks) == pq2_pks));
    
    % Schwellwert vor Maxima
    pqbegin_ref = find(ableitung_fir_abs((q_ref-(250 / 1000 * SParameter.Template.SampleFreq * 100)):pq2)>derpk/pbegin_slope)+(q_ref-(250 / 1000 * SParameter.Template.SampleFreq * 100));
    if ~isempty(pqbegin_ref)
        pqbegin_ref = pqbegin_ref(1);
    else
        [~,idx_pqbegin] = min(abs(ableitung_fir_abs((q_ref-(250 / 1000 * SParameter.Template.SampleFreq * 100)):pq2)-(derpk/pbegin_slope)));
        pqbegin_ref = idx_pqbegin + (q_ref-(250 / 1000 * SParameter.Template.SampleFreq * 100));
    end
end

% Maximum nach P-Peak
pq3 = locs_max(locs_max < (q_ref-(20 / 1000 * SParameter.Template.SampleFreq * 100)) & locs_max > pqpeak_ref);
pq3_pks = pks_max(locs_max < (q_ref-(20 / 1000 * SParameter.Template.SampleFreq * 100)) & locs_max > pqpeak_ref);

if ~isempty(pq3_pks)
    pq3 = pq3(find(max(pq3_pks) == pq3_pks));
    
    % Schwellwert nach Maxima
    pqend_ref = find(ableitung_fir_abs(pq3:q_ref)<derpk/pend_slope)+pq3;
    
    if ~isempty(pqend_ref)
        pqend_ref = pqend_ref(1);
    else
        [~,idx_pqend] = min(abs(ableitung_fir_abs(pq3:q_ref)-(derpk/pend_slope)));
        pqend_ref = idx_pqend + pq3;
    end
end


if SParameter.Template.debugPlot
    plot(pqbegin_ref,ableitung_fir_abs(pqbegin_ref),'ro')
    plot(pq2,ableitung_fir_abs(pq2),'ro')
    plot(pqpeak_ref,ableitung_fir_abs(pqpeak_ref),'ro')
    plot(pq3,ableitung_fir_abs(pq3),'ro')
    plot(pqend_ref,ableitung_fir_abs(pqend_ref),'ro')
    plot(qtbegin_ref,ableitung_fir_abs(qtbegin_ref),'ro')
    plot(qt3,ableitung_fir_abs(qt3),'ro')
    plot(qtpeak_ref,ableitung_fir_abs(qtpeak_ref),'ro')
    plot(qt2,ableitung_fir_abs(qt2),'ro')
    plot(qtend_ref,ableitung_fir_abs(qtend_ref),'ro')
    plot(locs_max(1),ableitung_fir_abs(locs_max(1)),'ro')
    plot(locs_max(2),ableitung_fir_abs(locs_max(2)),'ro')
    plot(r_ref,ableitung_fir_abs(r_ref),'ro')
    plot(q_ref,ableitung_fir_abs(q_ref),'ro')
    plot(s_ref,ableitung_fir_abs(s_ref),'ro')
end

SParameter.Template.Template = SParameter.Template.Template';
pqbegin_ref = round((pqbegin_ref+99)/100);
pqpeak_ref = round((pqpeak_ref+99)/100);
pqend_ref = round((pqend_ref+99)/100);
q_ref = round((q_ref+99)/100);
r_ref = round((r_ref+99)/100);
s_ref = round((s_ref+99)/100);
qtbegin_ref = round((qtbegin_ref+99)/100);
qtpeak_ref = round((qtpeak_ref+99)/100);
qtend_ref = round((qtend_ref+99)/100);

if isempty(pqbegin_ref)
    pqbegin_ref = NaN;
end
if isempty(pqpeak_ref)
    pqpeak_ref = NaN;
end
if isempty(pqend_ref)
    pqend_ref = NaN;
end

if isempty(q_ref)
    q_ref = NaN;
end
if isempty(s_ref)
    s_ref = NaN;
end

if isempty(qtbegin_ref)
    qtbegin_ref = NaN;
end
if isempty(qtpeak_ref)
    qtpeak_ref = NaN;
end
if isempty(qtend_ref)
    qtend_ref = NaN;
end

% Falls kein R
if isempty(r_ref)
    r_ref = round(q_ref + (s_ref-q_ref)/2);
end

isolevel = isolevel+template_median;

Pamp = SParameter.Template.Template(pqpeak_ref) - isolevel;
Tamp = SParameter.Template.Template(qtpeak_ref) - isolevel;
QRSamp = SParameter.Template.Template(q_ref-1+find(max(abs(SParameter.Template.Template(q_ref:s_ref)))==abs(SParameter.Template.Template(q_ref:s_ref))))-isolevel;

Refs = [pqbegin_ref pqpeak_ref pqend_ref q_ref r_ref s_ref qtbegin_ref qtpeak_ref qtend_ref];
Amps = [isolevel Pamp QRSamp Tamp] ;


if SParameter.Template.debugPlot
    figure
    hold on
    plot(SParameter.Template.Template,'r')
    plot(Refs,SParameter.Template.Template(Refs),'ro')
end    

catch exeption
    Refs = false;
    Amps = false;
end
end

