function [window_start window_end ndim] = beatwindow(fpqrs_i,fpqrs_i1,samp_rate,window)
%fpqrs_i fiducial point in samples
%fpqrs_i1 next fiducial point in samples


RRpost=(fpqrs_i1 - fpqrs_i) / samp_rate;

window_start= fpqrs_i +  round(0.072* samp_rate);
ndim=0;

if strcmp(window,'laguna') || strcmp(window,'laguna2') || ~isempty(strmatch('own',window))
    window_start= fpqrs_i -  round(0.085* samp_rate); % 85ms
    i=RRpost > 0.720;
    window_end_bigrr=fpqrs_i1 -  round( 0.240 * samp_rate); % qrs_i+1 - 240ms %formerly 270ms
    window_end_smallrr=fpqrs_i +  round( 3/6 * RRpost * samp_rate); % 460ms
    window_end = window_end_bigrr.*i + window_end_smallrr.*~i;
    ndim=round(120 * samp_rate/250);
    if ~isempty(strmatch('own',window))
        %HACK hardcoded value for rr_ref=0.8s
       %ndim= round(  (0.8 - 0.240 - 0.072)  * samp_rate )-2;
       ndim = beatwarp(zeros(1,(window_end(1)-window_start(1)-1)),samp_rate,RRpost(1) ,0,'own');
       ndim=length(ndim);
    end
    
    
elseif strcmp(window,'frenkel')
    estimatedQSDistance=40/1000;%this value is assumed to represent the stationary distance between q and s

    stestimate1= (0.384*RRpost + 0.099)* samp_rate;
    stestimate2= (0.156*RRpost + 0.236)* samp_rate;
    stestimate3= (0.116*RRpost + 0.277)* samp_rate;
    
    i1=RRpost < 0.600;
    i3=RRpost > 1.000;
    i2= ~(i1 | i3);
    
    stestimate= stestimate1 .* i1 +  stestimate2 .* i2  +  stestimate3 .* i3;
    
    window_end= window_start + round( -estimatedQSDistance * samp_rate +  stestimate);
    ndim=round(100 * samp_rate/250);
    window_start= fpqrs_i -  round(0.085* samp_rate);
elseif strcmp(window,'bezerianos')
    window_end= window_start +  round(0.400 * samp_rate);
    ndim=round(0.400 * samp_rate);
    
elseif strcmp(window,'reference')%REFERENCE window
    %300 samples at 250Hz = 
    ndim=round( 300 / 250 * samp_rate);

    %truncated laguna
    i=RRpost > 0.720;
    window_end_bigrr=fpqrs_i1 -  round( 0.240 * samp_rate); % qrs_i+1 - 240ms
    window_end_smallrr=fpqrs_i +  round( 2/3 * RRpost * samp_rate); % 460ms
    window_end = window_end_bigrr.*i + window_end_smallrr.*~i;
    
    window_end = min(window_end,window_start+ndim) ;
elseif strcmp(window,'modLagunaQT')
    window_start= fpqrs_i -  round(0.17* samp_rate); % 85ms
    i=RRpost > 0.720;
    window_end_bigrr=fpqrs_i1 -  round( 0.240 * samp_rate); % qrs_i+1 - 240ms %formerly 270ms
    window_end_smallrr=fpqrs_i +  round( 2/3 * RRpost * samp_rate); % 460ms
    window_end = window_end_bigrr.*i + window_end_smallrr.*~i;
    ndim=round(120 * samp_rate/250);
elseif strcmp(window,'modLagunaPT')
    window_start= fpqrs_i -  round(0.37* samp_rate); % 2*85ms+200
    i=RRpost > 0.720;
    window_end_bigrr=fpqrs_i1 -  round( 0.240 * samp_rate); % qrs_i+1 - 240ms %formerly 270ms
    window_end_smallrr=fpqrs_i +  round( 2/3 * RRpost * samp_rate); % 460ms
    window_end = window_end_bigrr.*i + window_end_smallrr.*~i;
    ndim=round(120 * samp_rate/250);
elseif strcmp(window,'mQRS')
    window_start= fpqrs_i -  round(0.1* samp_rate); 
    window_end = fpqrs_i +  round(0.1* samp_rate); 
elseif strcmp(window,'EMG')
    window_start = fpqrs_i -  round(0.5* samp_rate);
    window_end = fpqrs_i1 +  round(0.5* samp_rate); 
else
    error('windowname not found ...');
end
window_end=window_end-1;
end
