function [EMed, EParameter] = WarpSTART( SignalData, WParameter, AParameter, SParameter)

skip = 0;
tmp = strsplit(SignalData,filesep);
AParameter.DataFile = tmp{size(tmp,2)};

tmp = strsplit(tmp{size(tmp,2)},['.' AParameter.DataModeParameter.m_ext{1}]);
AParameter.TemplateFile = [tmp{1} '.mat'];

% Laden der Signaldateien
[AParameter, SParameter, skip] = readData(AParameter,SParameter);

SParameter.PlotPrefix = tmp{1} + "_" + replace(SParameter.ecgHeader.lead," ","_");

% Vorverarbeitung
if AParameter.PreProcMode ~= 0
    SParameter.ecgSignal = preproc(SParameter.ecgSignal',AParameter,SParameter);
else
    SParameter.ecgSignal = SParameter.ecgSignal';
end

% Cut bei Template-Generierung
if AParameter.template_create
    if size(SParameter.ecgSignal,1) > (SParameter.Template.SearchLength * 60 * SParameter.SampleFreq)
        SParameter.ecgSignal = SParameter.ecgSignal(1:(SParameter.Template.SearchLength * 60 * SParameter.SampleFreq));
    end
end

if size(SParameter.ecgSignal,1) > size(SParameter.ecgSignal,2)
    SParameter.ecgSignal = SParameter.ecgSignal';
end


% PreExtraction (QRS, BeatArray, BeatTemplate etc.)
[AParameter, SParameter, skip] = preext(AParameter, SParameter, WParameter, skip);


if AParameter.template_create
    if SParameter.clSize1>SParameter.clSize2
        SParameter.Template.Template = SParameter.BeatTemplate1;
        [Refs1,Amps1] = calcECGRefs(AParameter,SParameter);
        SParameter.Template.Template = SParameter.BeatTemplate2;
        [Refs2,Amps2] = calcECGRefs(AParameter,SParameter);
    else
        SParameter.Template.Template = SParameter.BeatTemplate2;
        [Refs1,Amps1] = calcECGRefs(AParameter,SParameter);
        SParameter.Template.Template = SParameter.BeatTemplate1;
        [Refs2,Amps2] = calcECGRefs(AParameter,SParameter);
    end
    
    if sum(Refs1 < 0) > 0
        skip = 2;
    elseif Refs1 == false
        skip = true;
        SParameter.Template.Refs1 = NaN * ones(1,9);
        SParameter.Template.Amps1 = NaN * ones(1,4);
        SParameter.Template.guiTemplate = SParameter.BeatTemplate;
        display(SParameter.PlotPrefix + " Fehler in Ref Berechnung Template 1");
    else       
        SParameter.Template.Refs1 = Refs1;
        SParameter.Template.Amps1 = Amps1;      
        SParameter.Template.guiTemplate = SParameter.BeatTemplate;
        %hold off
    end
    
    if sum(Refs2 < 0) > 0
        skip = 2;
    elseif Refs2 == false
        skip = true;
        SParameter.Template.Refs2 = NaN * ones(1,9);
        SParameter.Template.Amps2 = NaN * ones(1,4);
        SParameter.Template.guiTemplate = SParameter.BeatTemplate;
        display(SParameter.PlotPrefix + " Fehler in Ref Berechnung Template 2");
    else       
        SParameter.Template.Refs2 = Refs2;
        SParameter.Template.Amps2 = Amps2;      
        SParameter.Template.guiTemplate = SParameter.BeatTemplate;
        %hold off
    end    
end

% QTV Stretch
if and(and(~isnan(SParameter.Template.Refs1(4)),~isnan(SParameter.Template.Refs1(5))),~isnan(SParameter.Template.Refs1(9)))
    SParameter.QT = calcWarp(AParameter,SParameter);
    %SParameter.QT = NaN;
else
    SParameter.QT = NaN;
end

SParameter.SignalData = SignalData;
    
% Export Parameters
EParameter = saveParameters( AParameter,SParameter);
EMed = SParameter.ecgHeader.med;



end

