#!/usr/bin/env bash

build_docker=true;
prepare_data=false;
run_docker=true;

if $build_docker; then
    docker build -t physionet-ami .
fi

root="/home/hseki/software/ml/physionet2021"
dirs="${root}/official/db/Training_2 ${root}/official/db/Training_WFDB ${root}/official/db/WFDB"
export PYTHONPATH=$root/official/python-classifier-2021:$PYTHONPATH


if $prepare_data; then
    outdir="data"
    python src/split_data.py \
           --norm-opt "range" \
           --data-dirs ${dirs} \
           --trim-dur 30 \
           --fs 500 \
           --outdir ${outdir}
fi


mkdir -p model test_outputs_v01

if $run_docker; then
    docker run -it --gpus all --shm-size=32g \
           -v $PWD/model:/physionet/model \
           -v $PWD/../master_data/tt_2:/physionet/test_data \
           -v $PWD/test_outputs:/physionet/test_outputs \
           -v $PWD/../master_data/tr_2:/physionet/training_data \
           physionet-ami \
           bash
fi

# python train_model.py training_data model
# python test_model.py model test_data test_outputs
# python evaluate_model.py labels outputs scores.csv class_scores.csv

# python extract_leads_wfdb.py -i twelve_lead_directory -o six_lead_directory -l I II III aVR aVL aVF
# python extract_leads_wfdb.py -i twelve_lead_directory -o four_lead_directory -l I II III V2
# python extract_leads_wfdb.py -i twelve_lead_directory -o three_lead_directory -l I II V2
# python extract_leads_wfdb.py -i twelve_lead_directory -o two_lead_directory -l I II

exit 0
