%% Apply classifier model to test set

function [score, label,classes] = team_testing_code(data,header_data, loaded_model)
addpath('functions')

net   = loaded_model.net;
classes = loaded_model.classes;
num_sec = loaded_model.num_sec;
newfs = loaded_model.newfs;
minibatchSize = loaded_model.bs;

num_classes = length(classes);

label = zeros([1,num_classes]);

% Extract features from test data
tmp_hea = strsplit(header_data{1},' ');
num_leads = str2num(tmp_hea{2});
[leads, leads_idx] = get_leads(header_data,num_leads);

% Preprocessing data

data_new = preprocessing(data,header_data,leads_idx,num_sec,newfs);

% Use your classifier here to obtain a label and score for each class.
[YPred,score] = classify(net,data_new,'MiniBatchSize',minibatchSize);

idx_tmp=find(score>=0.07);
label(idx_tmp)=1;

end
