function data_pre = preprocessing(data, header_data,leads_idx,num_sec,newfs) %get_ECGLeads_features


% read number of leads, sample frequency and adc_gain from the header.
% [recording,Total_time,num_leads,Fs,adc_gain,age,sex,Baseline] = extract_data_from_header(header_data);
[~,~,~,Fs,adc_gain,age,sex,Baseline] = extract_data_from_header(header_data);

num_leads = length(leads_idx);
jj=1;
try
    % ECG processing
    % Preprocessing
    for i = [leads_idx]
        new_data=data(i,:);
        % Apply adc_gain and remove baseline
        if Fs ~= newfs
            new_data=downsample(data(i,:),round(Fs/newfs));
        end
        LeadswGain(i,:)   = (new_data-Baseline(i))./adc_gain(i);
        
        % Extract root square mean (RSM) feature
%         RSM(i) = sqrt(sum(LeadswGain(i,:).^2))./length(LeadswGain(i,:));       
%         features(jj) = RSM(i);
%         jj = jj+1;

    end
    num_samples=num_sec*newfs;
    data_pre=padSequence(LeadswGain,num_samples);
    
catch
    features_length = num_leads;
    features = nan(1,features_length);
end

% The last two features are age and sex from header file
features(num_leads+1) = age;
features(num_leads+2) = sex;
end
