function x_resample = padSequence(data,sequenceLength)

N=1;

if iscell(data)
    N=length(data);
    X=data;
else
    X={data};
end

x_resample=cell(N,1);
for i=1:N
    sequence = X{i};
    [C,S] = size(sequence);

    if S < sequenceLength
        padding = zeros(C,sequenceLength-S);
        x_resample(i) = {[sequence padding]};
    elseif S == sequenceLength
        x_resample(i) = {sequence};
    else
        x_resample(i) = {sequence(:,1:sequenceLength)};
    end
end

if ~iscell(data); x_resample=x_resample{1}; end

end