function net=CNN_BILSTM_network_training(X_Tr,YTrain,X_Ts,...
    YTest,miniBatchSize,maxEpochs,HU,dol,HU2,dol2,vf_,vf,vp,plot_)

inputsize=size(X_Tr{1},1:3)
numClasses = numel(unique(YTrain));
% lgraph = resnet50('Weights','none')
% layerNames = ["input_1" "fc1000" "fc1000_softmax" "ClassificationLayer_fc1000"];

lgraph = resnet18('Weights','none')
layerNames = ["data" "fc1000" "prob" "ClassificationLayer_predictions"];
% analyzeNetwork(lgraph)

% training
LSTMlayers = [
%     bilstmLayer(500,'OutputMode','sequence','Name','bilstm1')
%     dropoutLayer(0.8,'Name','drop1')
    bilstmLayer(HU,'OutputMode','sequence','Name','bilstm2')
    dropoutLayer(dol,'Name','drop2')
    bilstmLayer(HU2,'OutputMode','last','Name','bilstm3')
    dropoutLayer(dol2,'Name','drop3')
    fullyConnectedLayer(numClasses,'Name','fc')
    softmaxLayer('Name','softmax')
    classificationLayer('Name','classgpuDevice()ification')
    ];

layers = [
    sequenceInputLayer(inputsize,'Name','data','Normalization','none')
    sequenceFoldingLayer('Name','fold')
    ];

layers2 = [
    sequenceUnfoldingLayer('Name','unfold')
    flattenLayer('Name','flatten')
    LSTMlayers];

cnnLayers = removeLayers(lgraph,layerNames);

lgraph_new = addLayers(cnnLayers,layers);
lgraph_new = connectLayers(lgraph_new,"fold/out","conv1"); 
lgraph_new = addLayers(lgraph_new,layers2);

lgraph_new = connectLayers(lgraph_new,"pool5","unfold/in"); %for resnet18
% lgraph_new = connectLayers(lgraph_new,"avg_pool","unfold/in"); %for resnet50
% pool1=maxPooling2dLayer([3 3],'Stride',2,'Padding',[1 1 1 1],'name','pool1'); %for resnet50
% lgraph_new = replaceLayer(lgraph_new,'max_pooling2d_1',pool1); %for resnet50

lgraph_new = connectLayers(lgraph_new,"fold/miniBatchSize","unfold/miniBatchSize");
% analyzeNetwork(lgraph_new)

options = trainingOptions('adam', ...
    'ExecutionEnvironment','auto', ...
    'MaxEpochs',maxEpochs, ...
    'MiniBatchSize',miniBatchSize, ...
    'Verbose',1, ...
    'LearnRateSchedule','piecewise', ...
    'LearnRateDropFactor',0.7, ...
    'LearnRateDropPeriod',70, ...
    'InitialLearnRate',0.001);
% 'InitialLearnRate',0.003,...

if plot_
    options.Plots='training-progress';
    options.Verbose=0;
end
if vf_
    ValidationFrequency=floor((size(X_Tr,1)/miniBatchSize))*vf;
    options.ValidationPatience=vp;
    options.ValidationFrequency=ValidationFrequency;
    options.ValidationData={X_Ts,YTest};
end

% layers=layerGraph(net);

net = trainNetwork(X_Tr,YTrain,lgraph_new,options);

