import numpy as np
import os
import random
import shutil
def find_challenge_files(data_directory):
    header_files = list()
    recording_files = list()
    for f in os.listdir(data_directory):
        root, extension = os.path.splitext(f)
        if not root.startswith('.') and extension=='.hea':
            # header_file = os.path.join(data_directory, root + '.hea')
            header_file = root + '.hea'
            # recording_file = os.path.join(data_directory, root + '.mat')
            recording_file = root + '.mat'
            # if os.path.isfile(header_file) and os.path.isfile(recording_file):
            header_files.append(header_file)
            recording_files.append(recording_file)
    return header_files, recording_files


header_files, recording_files = find_challenge_files('./CPSC/')
print('tot header_files len:',len(header_files))
print('tot recording_files len:',len(recording_files))
l = len(header_files)
random.seed(123)
id = []
testheader = []
testrecording = []
for i in range(l):
    x = random.random()
    if x < 0.1:
        id.append(i)
        testheader.append(header_files[i])
        testrecording.append(recording_files[i])
print('id :',id)
print('len id :',len(id))
print('picked testheader :',testheader)
print('picked testrecording :',testrecording)

# os.mkdir('./new_testing_data/')
for hd,re in zip(testheader, testrecording):
    shutil.move('./CPSC/' + hd, './new_testing_data/' + hd)
    shutil.move('./CPSC/' + re, './new_testing_data/' + re)
