function [flat,tn] = verify_flat(signal,Fs,type)
%Vignesh Kalidas 
%PhD - Computer Engineering, 
%Dept of Electrical Engineering, 
%University of Texas at Dallas, Texas, USA
% GNU General public License
    if(nargin < 3)
        type = 1;
    end
    
    flat = 0;
    tn = 0;
    
    signal_diff = diff(signal);
    signal_sign = sign(signal_diff);
    
    for i=1:1:length(signal_sign)-1
        signal_signnew(i) = signal_sign(i) + signal_sign(i+1);
    end
    
    signal_zeros = find(signal_signnew == 0);
    signal_cons = get_consecutive(signal_zeros);
    
    signal_conslen = find(signal_cons >= 2*Fs);
    
    if(~isempty(signal_conslen))
%         disp('here')
        flat = 1;
        tn = tn+1;
    end
    
    signal_zerodiff = find(signal_diff == 0);
    signal_zerocons = get_consecutive(signal_zerodiff);
    
    signal_zerolen = find(signal_zerocons >= 2*Fs);
    if(~isempty(signal_zerolen))
%         disp('here1')
        flat = 1;
        tn = tn+1;
    end
    
    signal_datam = signal - mean(signal);
    if((max(signal_datam) < 0.008) && (min(signal_datam) > -0.008))
%         disp('here2')
        flat = 1;
        tn = tn+1;
    end
    
    if(type)
        f_lim = (((length(signal)/Fs)-2)*5);
        for ind=1:1:f_lim
            
            st = ceil(ind*(0.2*Fs))+1;
            fi = st+(2*Fs)-1;
            signal_block = signal(st:fi);
            signal_std(ind) = std(signal_block);
        end
        
        if(min(signal_std) < 0.008)
            %         disp('here3')
            flat = 1;
            tn = tn+1;
        end
    end
end
