function  model = train_12ECG_classifier(input_directory,output_directory)

global dsc_n_catch;
global dsc_n_ok;

dsc_n_catch = 0;
dsc_n_ok = 0;

% train_12ECG_classifier('E:\PhysioNetChallenge2020\all_data', 'E:\PhysioNetChallenge2020\all_data_out')
% train_12ECG_classifier('E:\PhysioNetChallenge2020\partition_small\train', 'E:\PhysioNetChallenge2020\partition_small_out')

%input_directory = 'E:\PhysioNetChallenge2020\partition_1\train';
%output_directory = 'E:\PhysioNetChallenge2020\partition_1_out';

%input_directory = 'E:\PhysioNetChallenge2020\partition_2\train';
%output_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
%feature_directory = 'D:\PhysioNetChallenge2020\partition_2_out';

%input_directory = 'E:\PhysioNetChallenge2020\partition_small\train';
%output_directory = 'E:\PhysioNetChallenge2020\partition_small_out';

%input_directory = 'D:\PhysioNetChallenge2020\all_data';
%output_directory = 'D:\PhysioNetChallenge2020\all_data_out';
%feature_directory = 'D:\PhysioNetChallenge2020\partition_2_out';

%input_directory = 'E:\PhysioNetChallenge2020\all_data';
%output_directory = 'E:\PhysioNetChallenge2020\all_data_out';
%feature_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
%auc_directory = 'E:\PhysioNetChallenge2020\all_data_auc';

%input_directory = 'E:\PhysioNetChallenge2020\partition_3\train';
%output_directory = 'E:\PhysioNetChallenge2020\partition_3_out';

%input_directory = 'E:\PhysioNetChallenge2020\all_data';
%output_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
%feature_directory = 'E:\PhysioNetChallenge2020\partition_2_out';

%input_directory = 'E:\PhysioNetChallenge2020\partition_3\train';
%output_directory = 'E:\PhysioNetChallenge2020\partition_3_BR_out';
%feature_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
%feature_directory = 'd:\PhysioNetChallenge2020\partition_3_out';

%input_directory = 'E:\PhysioNetChallenge2020\partition_3\train';
%output_directory = 'D:\PhysioNetChallenge2020\partition_3_out';
%output_directory = 'D:\PhysioNetChallenge2020\partition_3_out_br_bagging'

%input_directory = 'E:\PhysioNetChallenge2020\partition_3\train';
%output_directory = 'D:\PhysioNetChallenge2020\partition_3_out_br_bagging_mb_sd_gnph1_gnph2'

% train_12ECG_classifier('E:\PhysioNetChallenge2020\all_data', 'E:\PhysioNetChallenge2020\partition_2_out')

sw_lookup_saved_features = false;
sw_lookup_saved_features_from_table = false;
sw_save_features = false;
sw_save_classifiers = false;
sw_process_dataset_i = false;
sw_proces_single_label_only = false;

if sw_lookup_saved_features && sw_lookup_saved_features_from_table
    %feature_file = 'E:\PhysioNetChallenge2020\features_mb_gn_sd_scored_.mat';
    feature_file = 'E:\PhysioNetChallenge2020\features_mb_gn_sd_gn2_scoredtrain_or_test.mat';
    T = load(feature_file, 'T');
    T = T.T;
else
    T = [];
end

dsc_n_catch = 0;
n_catch_max = 100;

normal_label = '426783006';

disp('Loading data...')

% Find files.
input_files = {};
for f = dir(input_directory)'
    if exist(fullfile(input_directory, f.name), 'file') == 2 && f.name(1) ~= '.' && all(f.name(end - 2 : end) == 'mat')
        input_files{end + 1} = f.name;
    end
end

input_files = sort(input_files);

%all_data:              43.110
%partition_1/train:      2.155
num_files = length(input_files);
%27
scored_classes = get_scored_classes();

normal_label_idx = find(strcmp(normal_label, scored_classes));

true_labels = zeros(num_files,length(scored_classes));
precess_file = zeros(num_files,1);
for i =1:num_files
    disp(['    ', num2str(i), '/', num2str(num_files), '...'])
    
    % Load data.
    file_tmp=strsplit(input_files{i},'.');
    tmp_input_file = fullfile(input_directory, file_tmp{1});
    
    [recording_label,~,single_recording_labels]=get_true_labels_gn([tmp_input_file '.hea'], scored_classes);
    true_labels(i,:) = single_recording_labels;
    
    if ~sw_process_dataset_i
        precess_file(i,:) = ~startsWith(recording_label,'I');
    else
        precess_file(i,:) = true;
    end
end

%true_labels_table = array2table(true_labels, 'VariableNames', scored_classes);

%stats = grpstats(true_labels_table, scored_classes);
%stats(:, end+1) = array2table(sum(table2array(stats(:,1:end-1)), 2));

%stats_excl_normal

%writetable(stats, 'E:\PhysioNetChallenge2020\stats_partition_2_v2.xls');

%tmp_output_file = fullfile(output_directory, 'true_labels.mat');
%save(tmp_output_file, 'true_labels');

is_normal_instance = true_labels(:, normal_label_idx);

true_labels_excl_normal = true_labels;
true_labels_excl_normal(:, normal_label_idx) = 0;

no_label_idx = sum(true_labels_excl_normal, 2) == 0;

true_labels = true_labels_excl_normal;
true_labels(no_label_idx, normal_label_idx) = is_normal_instance(no_label_idx);

if sw_proces_single_label_only
    is_scored_instance = sum(true_labels, 2) == 1 & precess_file;
else
    is_scored_instance = sum(true_labels, 2) >= 1 & precess_file;
end
%is_scored_instance = (sum(true_labels, 2) == 1 | sum(true_labels_excl_normal, 2) == 1) & precess_file;
scored_instance_idx = find(is_scored_instance);
[~, first_labels] = max(true_labels, [], 2);
first_labels_str = scored_classes(first_labels);

%partition_1/train:   1128
num_scored_files = sum(is_scored_instance);

if ~sw_lookup_saved_features || ~sw_lookup_saved_features_from_table
    num_features = 876; %820; %654;%820; %654; %820 880;
else
    num_features = size(T, 2);
end

%features = cell(num_scored_files, 1);
features = zeros(num_scored_files, num_features);
features_computed = zeros(num_scored_files, 1);

% Iterate over files to load data.
disp('Extracting features..')
parfor i = 1:num_scored_files
%for i = 1:num_scored_files
    disp(['    ', num2str(i), '/', num2str(num_scored_files), '...'])
    
    % Load data.
    file_tmp=strsplit(input_files{scored_instance_idx(i)},'.');
    tmp_input_file = fullfile(input_directory, file_tmp{1});
    
    [data,header_data] = load_challenge_data(tmp_input_file);
    
    try
        if ~sw_lookup_saved_features
            tmp_features = get_12ECG_features(data,header_data);

            %features{i,1}=tmp_features;
            
            % only phase 1 features from gn
            %feature_vec = [tmp_features.MB tmp_features.GN.set1 tmp_features.SD tmp_features.STE]; % tmp_features.GN.set4
            
            % only phase 2 features from gn
            %feature_vec = [tmp_features.MB tmp_features.SD tmp_features.STE tmp_features.GN.set4.X];
            
            % both phase 1 and phase 2 features from gn
            feature_vec = [tmp_features.MB tmp_features.GN.set1 tmp_features.SD tmp_features.STE tmp_features.GN.set4.X];
            
            features(i,:) = feature_vec;
            
            record_is_precomputed = false;
        else
            if sw_lookup_saved_features_from_table
                feature_vec = table2array(T(file_tmp{1}, :));

                if isnan(feature_vec(1)) || isnan(feature_vec(2))
                    [~,~,~,~,~,age,sex]=extract_data_from_header(header_data);
                    feature_vec(1) = age;
                    feature_vec(2) = sex;
                end
                
                features(i,:) = feature_vec;
                
                record_is_precomputed = true;
            else
                [recording_label,~,~]=get_true_labels_gn([tmp_input_file '.hea'], scored_classes);
                recording_label = strrep(recording_label,'.mat', '');
                tmp_feature_file = fullfile(feature_directory, [recording_label '.mat']);
                
                if isfile(tmp_feature_file)
                    feature_vec = load(tmp_feature_file);
                    features(i,:) = feature_vec.features;
                    
                    record_is_precomputed = true;
                else
                    tmp_features = get_12ECG_features(data,header_data);

                    %features{i,1}=tmp_features;
                    if isfield(tmp_features.GN, 'set3')
                        feature_vec = [tmp_features.MB tmp_features.GN.set1 tmp_features.SD tmp_features.STE];
                    else
                        feature_vec = [tmp_features.MB tmp_features.SD tmp_features.STE tmp_features.GN.set4.X];
                    end
                    
                    features(i,:) = feature_vec;
                    
                    record_is_precomputed = false;
                end
            end
        end
        
        features_computed(i,1) = 1;
        
        if sw_save_features && ~record_is_precomputed
            [recording_label,~,~]=get_true_labels_gn([tmp_input_file '.hea'], scored_classes);
            recording_label = strrep(recording_label,'.mat', '');
            tmp_output_file = fullfile(output_directory, [recording_label '.mat']);
            parsave(tmp_output_file, feature_vec);
        end
    catch
        dsc_n_catch = dsc_n_catch + 1;
        
    %    rethrow e;
        
        %if dsc_n_catch > n_catch_max
        %    error(['Too many catches in train_12ECG_classifier: ' num2str(dsc_n_ok)]);
        %end
    end
end

if dsc_n_catch > n_catch_max
    error(['Too many catches in train_12ECG_classifier: ' num2str(dsc_n_ok)]);
end

if sw_save_features
    tmp_output_file = fullfile(output_directory, 'features_orig.mat');
    save(tmp_output_file, 'features', 'features_computed');
end

%features_computed = ones(num_scored_files, 1);
features_computed = logical(features_computed);

labels = first_labels_str(is_scored_instance, :);
labels = labels(features_computed);

features = features(features_computed, :);

records = input_files(1,is_scored_instance);
records = records(1,features_computed);

records = strrep(records,'.mat', '');

if sw_save_features
    tmp_output_file = fullfile(output_directory, 'features.mat');
    save(tmp_output_file, 'features', 'labels');
end

disp('Training model..')

%Option 1: mnrfit
%model = mnrfit(features,label,'model','hierarchical');

%Option 2: fitcensemble
%numTrees = 100;
%model = fitcensemble(features, labels, 'NumLearningCycles', numTrees);

%Option 3: ecoc
% Y = labels;
% Y(strcmp(Y, '284470004')) = {'63593006'};
% Y(strcmp(Y, '427172004')) = {'17338001'};
% Y(strcmp(Y, '713427006')) = {'59118001'};
% Y = categorical(Y);
% %tabulate(Y)
% K = numel(unique(Y));
% t = templateEnsemble('AdaBoostM1',100,'Tree');
% rng(1); % For reproducibility
% Coding = designecoc(K,'sparserandom');
% options = statset('UseParallel',true);
% 
% %weights = csvread('D:\DSC\evaluation-2020-official\weights.csv');
% 
% weights = [0,270492004,164889003,164890007,426627000,713427006,713426002,445118002,39732003,164909002,251146004,698252002,10370003,284470004,427172004,164947007,111975006,164917005,47665007,59118001,427393009,426177001,426783006,427084000,63593006,164934002,59931005,17338001;270492004,1,0.300000000000000,0.300000000000000,0.500000000000000,0.400000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,0.500000000000000,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,0.500000000000000,0.500000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;164889003,0.300000000000000,1,0.500000000000000,0.300000000000000,0.400000000000000,0.300000000000000,0.350000000000000,0.350000000000000,0.475000000000000,0.425000000000000,0.350000000000000,0.375000000000000,0.337500000000000,0.375000000000000,0.300000000000000,0.450000000000000,0.400000000000000,0.350000000000000,0.400000000000000,0.300000000000000,0.300000000000000,0.250000000000000,0.375000000000000,0.337500000000000,0.500000000000000,0.500000000000000,0.375000000000000;164890007,0.300000000000000,0.500000000000000,1,0.300000000000000,0.400000000000000,0.300000000000000,0.350000000000000,0.350000000000000,0.475000000000000,0.425000000000000,0.350000000000000,0.375000000000000,0.337500000000000,0.375000000000000,0.300000000000000,0.450000000000000,0.400000000000000,0.350000000000000,0.400000000000000,0.300000000000000,0.300000000000000,0.250000000000000,0.375000000000000,0.337500000000000,0.500000000000000,0.500000000000000,0.375000000000000;426627000,0.500000000000000,0.300000000000000,0.300000000000000,1,0.400000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,0.500000000000000,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,0.500000000000000,0.500000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;713427006,0.400000000000000,0.400000000000000,0.400000000000000,0.400000000000000,1,0.400000000000000,0.450000000000000,0.450000000000000,0.425000000000000,0.475000000000000,0.450000000000000,0.475000000000000,0.437500000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.300000000000000,0.450000000000000,1,0.400000000000000,0.400000000000000,0.350000000000000,0.475000000000000,0.437500000000000,0.400000000000000,0.400000000000000,0.475000000000000;713426002,0.500000000000000,0.300000000000000,0.300000000000000,0.500000000000000,0.400000000000000,1,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,0.500000000000000,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,0.500000000000000,0.500000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;445118002,0.450000000000000,0.350000000000000,0.350000000000000,0.450000000000000,0.450000000000000,0.450000000000000,1,0.500000000000000,0.375000000000000,0.425000000000000,0.500000000000000,0.475000000000000,0.487500000000000,0.475000000000000,0.450000000000000,0.400000000000000,0.250000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.400000000000000,0.475000000000000,0.487500000000000,0.350000000000000,0.350000000000000,0.475000000000000;39732003,0.450000000000000,0.350000000000000,0.350000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.500000000000000,1,0.375000000000000,0.425000000000000,0.500000000000000,0.475000000000000,0.487500000000000,0.475000000000000,0.450000000000000,0.400000000000000,0.250000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.400000000000000,0.475000000000000,0.487500000000000,0.350000000000000,0.350000000000000,0.475000000000000;164909002,0.325000000000000,0.475000000000000,0.475000000000000,0.325000000000000,0.425000000000000,0.325000000000000,0.375000000000000,0.375000000000000,1,0.450000000000000,0.375000000000000,0.400000000000000,0.362500000000000,0.400000000000000,0.325000000000000,0.475000000000000,0.375000000000000,0.375000000000000,0.425000000000000,0.325000000000000,0.325000000000000,0.275000000000000,0.400000000000000,0.362500000000000,0.475000000000000,0.475000000000000,0.400000000000000;251146004,0.375000000000000,0.425000000000000,0.425000000000000,0.375000000000000,0.475000000000000,0.375000000000000,0.425000000000000,0.425000000000000,0.450000000000000,1,0.425000000000000,0.450000000000000,0.412500000000000,0.450000000000000,0.375000000000000,0.475000000000000,0.325000000000000,0.425000000000000,0.475000000000000,0.375000000000000,0.375000000000000,0.325000000000000,0.450000000000000,0.412500000000000,0.425000000000000,0.425000000000000,0.450000000000000;698252002,0.450000000000000,0.350000000000000,0.350000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.500000000000000,0.500000000000000,0.375000000000000,0.425000000000000,1,0.475000000000000,0.487500000000000,0.475000000000000,0.450000000000000,0.400000000000000,0.250000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.400000000000000,0.475000000000000,0.487500000000000,0.350000000000000,0.350000000000000,0.475000000000000;10370003,0.425000000000000,0.375000000000000,0.375000000000000,0.425000000000000,0.475000000000000,0.425000000000000,0.475000000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.475000000000000,1,0.462500000000000,0.500000000000000,0.425000000000000,0.425000000000000,0.275000000000000,0.475000000000000,0.475000000000000,0.425000000000000,0.425000000000000,0.375000000000000,0.500000000000000,0.462500000000000,0.375000000000000,0.375000000000000,0.500000000000000;284470004,0.462500000000000,0.337500000000000,0.337500000000000,0.462500000000000,0.437500000000000,0.462500000000000,0.487500000000000,0.487500000000000,0.362500000000000,0.412500000000000,0.487500000000000,0.462500000000000,1,0.462500000000000,0.462500000000000,0.387500000000000,0.237500000000000,0.487500000000000,0.437500000000000,0.462500000000000,0.462500000000000,0.412500000000000,0.462500000000000,1,0.337500000000000,0.337500000000000,0.462500000000000;427172004,0.425000000000000,0.375000000000000,0.375000000000000,0.425000000000000,0.475000000000000,0.425000000000000,0.475000000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.475000000000000,0.500000000000000,0.462500000000000,1,0.425000000000000,0.425000000000000,0.275000000000000,0.475000000000000,0.475000000000000,0.425000000000000,0.425000000000000,0.375000000000000,0.500000000000000,0.462500000000000,0.375000000000000,0.375000000000000,1;164947007,0.500000000000000,0.300000000000000,0.300000000000000,0.500000000000000,0.400000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,1,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,0.500000000000000,0.500000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;111975006,0.350000000000000,0.450000000000000,0.450000000000000,0.350000000000000,0.450000000000000,0.350000000000000,0.400000000000000,0.400000000000000,0.475000000000000,0.475000000000000,0.400000000000000,0.425000000000000,0.387500000000000,0.425000000000000,0.350000000000000,1,0.350000000000000,0.400000000000000,0.450000000000000,0.350000000000000,0.350000000000000,0.300000000000000,0.425000000000000,0.387500000000000,0.450000000000000,0.450000000000000,0.425000000000000;164917005,0.200000000000000,0.400000000000000,0.400000000000000,0.200000000000000,0.300000000000000,0.200000000000000,0.250000000000000,0.250000000000000,0.375000000000000,0.325000000000000,0.250000000000000,0.275000000000000,0.237500000000000,0.275000000000000,0.200000000000000,0.350000000000000,1,0.250000000000000,0.300000000000000,0.200000000000000,0.200000000000000,0.150000000000000,0.275000000000000,0.237500000000000,0.400000000000000,0.400000000000000,0.275000000000000;47665007,0.450000000000000,0.350000000000000,0.350000000000000,0.450000000000000,0.450000000000000,0.450000000000000,0.500000000000000,0.500000000000000,0.375000000000000,0.425000000000000,0.500000000000000,0.475000000000000,0.487500000000000,0.475000000000000,0.450000000000000,0.400000000000000,0.250000000000000,1,0.450000000000000,0.450000000000000,0.450000000000000,0.400000000000000,0.475000000000000,0.487500000000000,0.350000000000000,0.350000000000000,0.475000000000000;59118001,0.400000000000000,0.400000000000000,0.400000000000000,0.400000000000000,1,0.400000000000000,0.450000000000000,0.450000000000000,0.425000000000000,0.475000000000000,0.450000000000000,0.475000000000000,0.437500000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.300000000000000,0.450000000000000,1,0.400000000000000,0.400000000000000,0.350000000000000,0.475000000000000,0.437500000000000,0.400000000000000,0.400000000000000,0.475000000000000;427393009,0.500000000000000,0.300000000000000,0.300000000000000,0.500000000000000,0.400000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,0.500000000000000,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,1,0.500000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;426177001,0.500000000000000,0.300000000000000,0.300000000000000,0.500000000000000,0.400000000000000,0.500000000000000,0.450000000000000,0.450000000000000,0.325000000000000,0.375000000000000,0.450000000000000,0.425000000000000,0.462500000000000,0.425000000000000,0.500000000000000,0.350000000000000,0.200000000000000,0.450000000000000,0.400000000000000,0.500000000000000,1,0.450000000000000,0.425000000000000,0.462500000000000,0.300000000000000,0.300000000000000,0.425000000000000;426783006,0.450000000000000,0.250000000000000,0.250000000000000,0.450000000000000,0.350000000000000,0.450000000000000,0.400000000000000,0.400000000000000,0.275000000000000,0.325000000000000,0.400000000000000,0.375000000000000,0.412500000000000,0.375000000000000,0.450000000000000,0.300000000000000,0.150000000000000,0.400000000000000,0.350000000000000,0.450000000000000,0.450000000000000,1,0.375000000000000,0.412500000000000,0.250000000000000,0.250000000000000,0.375000000000000;427084000,0.425000000000000,0.375000000000000,0.375000000000000,0.425000000000000,0.475000000000000,0.425000000000000,0.475000000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.475000000000000,0.500000000000000,0.462500000000000,0.500000000000000,0.425000000000000,0.425000000000000,0.275000000000000,0.475000000000000,0.475000000000000,0.425000000000000,0.425000000000000,0.375000000000000,1,0.462500000000000,0.375000000000000,0.375000000000000,0.500000000000000;63593006,0.462500000000000,0.337500000000000,0.337500000000000,0.462500000000000,0.437500000000000,0.462500000000000,0.487500000000000,0.487500000000000,0.362500000000000,0.412500000000000,0.487500000000000,0.462500000000000,1,0.462500000000000,0.462500000000000,0.387500000000000,0.237500000000000,0.487500000000000,0.437500000000000,0.462500000000000,0.462500000000000,0.412500000000000,0.462500000000000,1,0.337500000000000,0.337500000000000,0.462500000000000;164934002,0.300000000000000,0.500000000000000,0.500000000000000,0.300000000000000,0.400000000000000,0.300000000000000,0.350000000000000,0.350000000000000,0.475000000000000,0.425000000000000,0.350000000000000,0.375000000000000,0.337500000000000,0.375000000000000,0.300000000000000,0.450000000000000,0.400000000000000,0.350000000000000,0.400000000000000,0.300000000000000,0.300000000000000,0.250000000000000,0.375000000000000,0.337500000000000,1,0.500000000000000,0.375000000000000;59931005,0.300000000000000,0.500000000000000,0.500000000000000,0.300000000000000,0.400000000000000,0.300000000000000,0.350000000000000,0.350000000000000,0.475000000000000,0.425000000000000,0.350000000000000,0.375000000000000,0.337500000000000,0.375000000000000,0.300000000000000,0.450000000000000,0.400000000000000,0.350000000000000,0.400000000000000,0.300000000000000,0.300000000000000,0.250000000000000,0.375000000000000,0.337500000000000,0.500000000000000,1,0.375000000000000;17338001,0.425000000000000,0.375000000000000,0.375000000000000,0.425000000000000,0.475000000000000,0.425000000000000,0.475000000000000,0.475000000000000,0.400000000000000,0.450000000000000,0.475000000000000,0.500000000000000,0.462500000000000,1,0.425000000000000,0.425000000000000,0.275000000000000,0.475000000000000,0.475000000000000,0.425000000000000,0.425000000000000,0.375000000000000,0.500000000000000,0.462500000000000,0.375000000000000,0.375000000000000,1];
% 
% weightsLabels = weights(1,2:end);
% weightsMatrix = weights(2:end, 2:end);
% 
% weightsMatrix(weightsLabels == 284470004,:) = [];
% weightsMatrix(weightsLabels == 427172004,:) = [];
% weightsMatrix(weightsLabels == 713427006,:) = [];
% 
% weightsMatrix(:, weightsLabels == 284470004) = [];
% weightsMatrix(:, weightsLabels == 427172004) = [];
% weightsMatrix(:, weightsLabels == 713427006) = [];
% 
% weightsLabels(weightsLabels == 284470004) = [];
% weightsLabels(weightsLabels == 427172004) = [];
% weightsLabels(weightsLabels == 713427006) = [];
% 
% Cost.ClassNames = arrayfun(@num2str, weightsLabels, 'UniformOutput', 0);
% Cost.ClassificationCosts = 1 - weightsMatrix;
% 
% model = fitcecoc(features,Y,'Learner',t,'Options',options,'Coding',Coding,'Cost',Cost,'Verbose',2);

% tmp_output_file = fullfile(output_directory, 'ECOCmodel.mat');
% save(tmp_output_file, 'model');
% load(tmp_output_file, 'model');

% option 4 (ecoclib)
% Y = labels;
% Y(strcmp(Y, '284470004')) = {'63593006'};
% Y(strcmp(Y, '427172004')) = {'17338001'};
% Y(strcmp(Y, '713427006')) = {'59118001'};
% Y = categorical(Y);
% %tabulate(Y)
% K = numel(unique(Y));
% rng(1); % For reproducibility
% Coding = designecoc(K,'onevsall');
% %Coding = Coding(23:end,:);
% Coding = Coding';
% 
% %categories(Y)
% 
% Parameters.coding='CUSTOM'; %'Random';
% Parameters.custom_coding='CodingMatlab';
% Parameters.custom_coding_params.ECOC=Coding;
% Parameters.store_training_data = false;
% Parameters.decoding='ED';
% Parameters.base_classifiers = repmat({'Tree'}, 1, size(Coding, 2));
% Parameters.dataset_idx = repmat([0], 1, size(Coding, 2));
% Parameters.columns = size(Coding, 2);
% Parameters.base_classifier_params = cell(length(Parameters.base_classifiers),1);
% 
% Parameters.store_training_data = true; % for example, for CV
% 
% if sw_save_features
%     tmp_output_file = fullfile(output_directory, 'ECOCTrainInput.mat');
%     save(tmp_output_file, 'features', 'labels');
% end
% 
% [Classifiers,Parameters]=ECOCTrain(features,Y,Parameters);
% 
% categories_Y = categories(Y);
% 
% %classifier_idx = 1;
% for classifier_idx = 1:length(Classifiers)
% 
%     disp(['Classifier: ' num2str(classifier_idx)]);
%     
%     current_label = categories_Y{classifier_idx};
%     
%     posData = Classifiers{classifier_idx}.FirstSet;
%     negData = Classifiers{classifier_idx}.SecondSet;
% 
%     posDataIdx = Classifiers{classifier_idx}.FirstSetIdx;
%     negDataIdx = Classifiers{classifier_idx}.SecondSetIdx;
%     posDataRecordNames = cell2table(records(posDataIdx)', 'VariableNames', {'record_name'});
%     negDataRecordNames = cell2table(records(negDataIdx)', 'VariableNames', {'record_name'});
%     posDataRecordNames.Properties.RowNames = table2cell(posDataRecordNames(:, 'record_name'));
%     negDataRecordNames.Properties.RowNames = table2cell(negDataRecordNames(:, 'record_name'));
%     posDataRecordNames(:,'idx') = array2table((1:size(posDataRecordNames, 1))');
%     negDataRecordNames(:,'idx') = array2table((1:size(negDataRecordNames, 1))');
% 
%     AUCs = zeros(1,5);
%     %fold_idx = 1;
%     
%     folds = load('E:\PhysioNetChallenge2020\db-info\folds.mat');
%     folds = folds.all_folds;
%     
%     folds_rownames = folds.Properties.RowNames;
%     
%     input_directory = 'E:\PhysioNetChallenge2020\all_data';
%     output_directory = 'E:\PhysioNetChallenge2020\partition_3';
%     
%     %fold_idx=1;
%     
%     % continue from 22171 (S0334)
%     for record_idx=22171:size(folds,1)
%         
%         record_name = folds_rownames{record_idx};
%         fold_idx = folds{record_idx, 'strat_fold'};
%         
%         %note: we only have 516 out of 549 records of the PTB dataset.
%         %therefore, we might not find the file
%         
%         source_file = [input_directory '\' record_name '.hea']; 
%         
%         if isfile(source_file)
%             if fold_idx == 5
%                 copyfile([input_directory '\' record_name '.hea'], [output_directory '\test\' record_name '.hea']);
%                 copyfile([input_directory '\' record_name '.mat'], [output_directory '\test\' record_name '.mat']);
%             else
%                 copyfile([input_directory '\' record_name '.hea'], [output_directory '\train\' record_name '.hea']);
%                 copyfile([input_directory '\' record_name '.mat'], [output_directory '\train\' record_name '.mat']);
%             end
%         else
%             disp(['file ' source_file ' not found']);
%         end
%     end
%     
%     for fold_idx=1:5
%         disp([' Fold ' num2str(fold_idx)]);
% 
%         is_in_current_fold = table2array(folds(:,'strat_fold')) == fold_idx;
%         current_fold_records = folds(is_in_current_fold,:);
%         current_fold_records(:,'record_name') = current_fold_records.Properties.RowNames;
% 
%         is_in_current_fold_test = table2array(folds(:,'strat_fold')) ~= fold_idx;
%         current_fold_test_records = folds(is_in_current_fold_test,:);
%         current_fold_test_records(:,'record_name') = current_fold_test_records.Properties.RowNames;
% 
%         posDataFoldIdx = innerjoin(posDataRecordNames, current_fold_records, 'keys', 'record_name');
%         negDataFoldIdx = innerjoin(negDataRecordNames, current_fold_records, 'keys', 'record_name');
%         posDataFold = posData(table2array(posDataFoldIdx(:,'idx')),:);
%         negDataFold = negData(table2array(negDataFoldIdx(:,'idx')),:);
% 
%         posDataTestFoldIdx = innerjoin(posDataRecordNames, current_fold_test_records, 'keys', 'record_name');
%         negDataTestFoldIdx = innerjoin(negDataRecordNames, current_fold_test_records, 'keys', 'record_name');
%         posDataTestFold = posData(table2array(posDataTestFoldIdx(:,'idx')),:);
%         negDataTestFold = negData(table2array(negDataTestFoldIdx(:,'idx')),:);
% 
%         cv_labels = [ones(size(posDataFold,1),1);-ones(size(negDataFold,1),1)];
%         cv_data = double([posDataFold;negDataFold]);
% 
%         cv_test_labels = [ones(size(posDataTestFold,1),1);-ones(size(negDataTestFold,1),1)];
%         cv_test_data = double([posDataTestFold;negDataTestFold]);
% 
%         numTrees = 50;
%         t = templateTree('MaxNumSplits',5);
%         classifier = fitcensemble(cv_data, cv_labels, 'NumLearningCycles', numTrees, 'Learners', t, 'LearnRate',1);     %, 'NPrint', 1
% 
%         classifier.ScoreTransform = 'doublelogit';
%         [~, score] = predict(classifier, cv_test_data);
%         [~,~,~,AUC,~] = perfcurve(cv_test_labels, score(:,2), 1);
%         AUCs(fold_idx) = AUC;
%     end
%     
%     disp(AUCs);
%     
%     save([auc_directory '\' current_label '.mat'], 'AUCs');
%     
% end

%Option 5: Binary Relevance Method (BR) with fitcensemble
label_idx = 1;

%train_labels = true_labels(is_scored_instance, :);

scored_labels = true_labels(is_scored_instance, :);
scored_labels = scored_labels(features_computed, :);

n_instances = size(scored_labels, 1);

R = 1.0;
N = 10;

classifiers = cell(size(true_labels, 2), N);

for n = 1 : N
                    
    % Boostrap samples with replacement
    k = round(n_instances * R);
    train_idx = datasample(1:n_instances, k);
    
    for label_idx = 1:size(true_labels, 2)
        
        disp(['bag_' num2str(n) 'lbl_' num2str(label_idx)]);
        
        labels = scored_labels(:, label_idx);

        numTrees = 100;
        t = templateTree('MaxNumSplits', 5);
        model_i = fitcensemble(features(train_idx, :), labels(train_idx, :), 'Method', 'AdaBoostM1', 'Learners', t, 'NumLearningCycles', numTrees, 'NPrint', 1);
        model_s = compact(model_i);
        if sw_save_classifiers
            save([output_directory '\model_bag_' num2str(n) 'lbl_' num2str(label_idx) '.mat'], 'model_s');
        end
        classifiers{label_idx, n} = model_s;
    end
    
end
    


%for label_idx = 1:size(true_labels, 2)
%    load([output_directory '\model_' num2str(label_idx) '.mat'], 'model_s');
%    classifiers{label_idx} = model_s;
%end

models.model = classifiers;

%labels = is_normal_instance(is_scored_instance, :);
%labels = labels(features_computed);

%numTrees = 100;
%model = fitcensemble(features, labels, 'NumLearningCycles', numTrees);

%models.modelNormal = model;

save_12_ECG_model(models,output_directory,scored_classes);

end
