function [score, label,classes] = run_12ECG_classifier(data,header_data, loaded_model)

    % Option 1: batch:
    % data = all_data;
    % header_data = all_header_data;
    
    % Option 2: online
    % tmp_input_file = 'E:\PhysioNetChallenge2020\partition_3\test\A0016'
    % [data,header_data] = load_challenge_data(tmp_input_file);
     
    % model_directory = 'E:\PhysioNetChallenge2020\partition_3_BR_out';
    % model = load_12ECG_model(model_directory);
    % loaded_model = model;
    
    sw_save_features = false; % true;
    sw_predict = true;
    sw_lookup_saved_features = false; %false;
    sw_lookup_saved_features_from_table = false;
    sw_add_zeros_to_x = false;
    
    %output_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
    %feature_directory = 'E:\PhysioNetChallenge2020\partition_2_out';
    
    output_directory = 'D:\PhysioNetChallenge2020\partition_3_out_br_bagging_mb_sd_gnph1_gnph2';
    feature_directory = 'D:\PhysioNetChallenge2020\partition_3_out_br_bagging_mb_sd_gnph1_gnph2';
    
    %output_directory = 'd:\PhysioNetChallenge2020\partition_3_out';
    %feature_directory = 'd:\PhysioNetChallenge2020\partition_3_out';
    
	model=loaded_model.model.model;
    %modelNormal=loaded_model.model.modelNormal;
	classes=loaded_model.classes;

    %sw_lookup_saved_features = true;
%     if isfield(loaded_model, 'T')
%         sw_lookup_saved_features = true;
%         T = loaded_model.T;
%     else
%         sw_lookup_saved_features = false;
%     end
    
    num_classes = length(classes);

    %label = zeros([1,num_classes]);
    %score = zeros([1,num_classes]);
    
    if iscell(data)
        n_files = length(data);
        all_data = data;
        all_header_data = header_data;
        X_all = zeros(n_files, 876);  %654
    else
        n_files = 1;
        all_data = data;
    end
    
    for record_idx = 1:n_files
        
        %num2str(['loading features for record: ' num2str(record_idx)]);
        
        if iscell(all_data)
           data = all_data{record_idx};
           header_data = all_header_data{record_idx};
        end 
        
        % Use your classifier here to obtain a label and score for each class.
        record_is_precomputed = false;
        if sw_lookup_saved_features

            [recording,~,~,~,~,age,sex]=extract_data_from_header(header_data);
            recording = strrep(recording,'.mat', '');

            if sw_lookup_saved_features_from_table
                record_is_precomputed = ismember(recording, T.Properties.RowNames);
            else
                tmp_feature_file = fullfile(feature_directory, [recording '.mat']);

                if isfile(tmp_feature_file)
                    record_is_precomputed = true;
                end
            end
        end

        if ~sw_lookup_saved_features || ~record_is_precomputed
            features = get_12ECG_features(data,header_data);

            all_features_bm = features.MB;      %24
            all_features_gn = features.GN;      %222
            all_features_sd = features.SD;      %564
            all_features_ste = features.STE;    %10
            all_features_gn_phase_2 = features.GN.set4.X;
                                                %820  (662 pre-computed)
            %n_features_gn = 37;
            n_features_gn = 222;
    
            feature_matrix_gn = zeros(1, n_features_gn);
            features = all_features_gn.set1;
            feature_matrix_gn(1,:) = features; 

            if ~sw_lookup_saved_features || ~record_is_precomputed
                X = [all_features_bm feature_matrix_gn all_features_sd all_features_ste all_features_gn_phase_2]; %all_features_gn_phase_2
                %X = [all_features_bm all_features_sd all_features_ste all_features_gn_phase_2];

                if sw_save_features
                    disp(' saving');
                    [recording,~,~,~,~,~,~]=extract_data_from_header(header_data);
                    recording = strrep(recording,'.mat', '');
                    tmp_output_file = fullfile(output_directory, [recording '.mat']);
                    feature_vec = X;
                    parsave(tmp_output_file, feature_vec);
                end

            else
                %X = [all_features_bm feature_matrix_gn(1:74) all_features_sd];
                %X = [all_features_bm feature_matrix_gn all_features_sd all_features_ste all_features_gn_phase_2];
                X = [all_features_bm all_features_sd all_features_ste all_features_gn_phase_2];
            end
        else

            if sw_lookup_saved_features_from_table
                X = table2array(T(recording, :));

                if isnan(X(1)) || isnan(X(2))
                    X(1) = age;
                    X(2) = sex;
                end
            else
                recording = strrep(recording,'.mat', '');
                tmp_feature_file = fullfile(feature_directory, [recording '.mat']);
                feature_vec = load(tmp_feature_file);
                X = feature_vec.features;
            end
        end
        
        X_all(record_idx,:) = X;
        
    %X(isnan(X))=0;
    end
    
    % Parameters.coding='CUSTOM';
    % Parameters.custom_coding='CodingMatlab';
    % Parameters.custom_coding_params.ECOC=model.ECOC;
    % Parameters.decoding='ED';
    % Parameters.base_classifiers = model.base_classifiers;
    % Parameters.dataset_idx = model.dataset_idx;
    % Parameters.columns = size(model.ECOC, 2); %57;
    % Parameters.base_classifier_params = cell(length(model.base_classifiers),1);
    % Parameters.ECOC=model.ECOC;
    % Parameters.show_info=0;
    
    % Parameters.datasets = all_features_gn;
    
    % Parameters.base_test_params.base_classifiers_test = cell(length(model.base_classifiers),1);
    % for i = 1:length(model.base_classifiers)
        % Parameters.base_test_params.base_classifiers_test{i} = [Parameters.base_classifiers{i} 'Test'];
    % end
    % Parameters.base_test_params.datasets = Parameters.datasets;
    % Parameters.base_test_params.dataset_idx = Parameters.dataset_idx;
    
    % [Labels,Values,confusion]=ECOCTest(X,model.Classifiers,Parameters);
    
    %lbl = Labels(1);
    
    if sw_predict
        
        scores = zeros(size(X_all, 1), length(classes));
        
        n_features = length(model{1}.PredictorNames);
        
        % just to test if the code works 'in principle' if we have added
        % features after training the model
        if sw_add_zeros_to_x
            if size(X_all, 2) < n_features
               X_all(1, n_features) = 0;
            end
        end
        
        %classifier_idx = 1;
        for classifier_idx = 1:length(classes)
            
            num_bagging_it = size(model, 2);
            
            for bagging_it = 1:num_bagging_it
            
                %disp(['classifier ' num2str(classifier_idx) ' it ' num2str(bagging_it)]);
                
                classifier = model{classifier_idx, bagging_it};

                %lbl = predict(model,X,'Options',options);
                %lbl = predict(classifier,X_all);
                classifier.ScoreTransform = 'doublelogit';
                [~, score] = predict(classifier,X_all);

                scores(:,classifier_idx) = scores(:,classifier_idx) + score(:,2);

                %lbl = nominal(lbl);
                %lbl = string(lbl);
                %lbl = find(strcmp(classes,lbl));
            
            end
            
            scores(:,classifier_idx) = scores(:,classifier_idx) ./ num_bagging_it;
            
        end
        
        %load('E:\PhysioNetChallenge2020\partition_3\train_labels.mat', 'train_labels');
        %thresholding_method.type = 'Pcut';
        %[pred, thresh]= Thresholding(scores, thresholding_method, train_labels);
        
        thresholding_method.type = 'Scut';
        %E:\PhysioNetChallenge2020\partition_2_out
        %official submission 2: (Binary Relevance)
        %thresholding_method.param = [0.333309088255825,0.210597849490822,0.00472769699215925,0.229416388096523,0.110451811777295,0.311032275769479,0.293958760763893,0.368264466904735,0.211639963811650,0.123761785436475,0.201242930107770,6.14207499232977e-18,0.330901271450907,0.0784322352064563,0.0493770020705740,0.290154446813978,0.193000131558267,0.0262494718031721,0.218310609216888,0.248333290045772,0.0369405000190541,0.508764990483556,0.411414661001816,0.00299217028829333,0.365437019634838,0.245830216814308,0.0400704531426927];
        %official submission 3: (Binary Relevance with Bagging)
        %thresholding_method.param = [0.350701771727755,0.450479831798340,0.0103765971096295,0.209931015851829,0.339868382264772,0.306605512078957,0.358005680614735,0.431896428620507,0.505633403708720,0.127076352301587,0.140706759204586,1.33609379519553e-11,0.382129105177614,0.141849999961975,0.0876266050100011,0.285578623562826,0.133321439493807,0.106043456522820,0.412906076365592,0.277736971879137,0.230151211057531,0.561970210222634,0.668283907034068,0.000691849558688982,0.372057601080344,0.181742446518501,0.0862129513288425];
        %official submission 4: (Binary Relevance with Bagging) including gn's features
        thresholding_method.param = [0.338935033777473,0.439518189839984,0.0603589473657160,0.237292857706540,0.339652064806393,0.297365100614423,0.351470198991085,0.426607598794879,0.490531882318386,0.117288918231068,0.151726217241229,2.32204924057120e-11,0.393678768296483,0.132466625558535,0.0950934481575099,0.309453523780530,0.130366735017413,0.107964968721719,0.401967859511047,0.295050140108938,0.228536810978433,0.568590482840870,0.688528514383197,0.000135063532891332,0.377719124059770,0.168562946763212,0.0662132773785433];
        
        %d:\PhysioNetChallenge2020\partition_3_out
        %thresholding_method.param = [0.394836902998383,0.370096955158269,0.00365183033101596,0.257790090801092,0.302916516618332,0.348042758284626,0.428486119712750,0.405576865433810,0.594414651042294,0.176977195150720,0.228411108428242,8.94924916492255e-11,0.401468077853065,0.110155357755643,0.0576768388162834,0.366573490657906,0.203590350123972,0.0578585423142307,0.492273982619854,0.383720627600292,0.338689882409435,0.573666867220418,0.744846446453084,0.00188665828711096,0.407430625324193,0.254892084040754,0.0745397295262344];
        pred = Thresholding(scores, thresholding_method);
        
        score = pred;
        label = pred;
        
    else
        label = zeros([1,num_classes]);
        score = zeros([1,num_classes]);
        
        lbl = 1;
        score(lbl)=1;
        label(lbl)=1;
    end
    
    % Option 1: 1-class ECOC + Normal classifier
%     if sw_predict
%         options = statset('UseParallel',false);
% 
%         lbl = predict(model,X,'Options',options);
%         lbl = nominal(lbl);
%         lbl = string(lbl);
%         lbl = find(strcmp(classes,lbl));
%     else
%         lbl = 1;
%     end
%     
%     % Normal vs STE
%     %if lbl == 4 
%     % if strcmp(classes{lbl}, 'Normal')
%         % ECOC_ste_vs_n_idx = 64;
%         % classifier_ste_vs_n = model.Classifiers{ECOC_ste_vs_n_idx}.classifier; % STE = positive, N = negative
%         % classifier_ste_vs_n.ScoreTransform = 'doublelogit';
%         % [~, ste_vs_n_score] = predict(classifier_ste_vs_n, X);
%         
%         % AUC_OPT_T = 0.0112;
%         % if ste_vs_n_score(1,2) > AUC_OPT_T
%             % %lbl = 9;                        % STE
%             % normal_idx = find(strcmp(classes, 'STE'));
%             % lbl = normal_idx;
%         % end
%     % end
%         
%     score(lbl)=1;
%     label(lbl)=1;
%     
%     if sw_predict
%         lblIsNormal = predict(modelNormal,X); 
%     else
%         lblIsNormal = true;
%     end
%     
%     if lblIsNormal
%         normal_label = '426783006';
%         lblNormal = find(strcmp(classes,normal_label));
%         
%         score(lblNormal)=1;
%         label(lblNormal)=1;
%     end
end



