function res = predict_20segments_model_sub(leads, use_num_leads,patID,PatID_wrsamp)

XSaug_cur = {}; 
XSaug_cur{1,8} = leads(:,1);

kk = min(size(leads,1),(10000/250)*250);

XSaug_cur_2400 = {};
for i=1:size(XSaug_cur,1)
    if size(XSaug_cur{i,8},1) >= kk
        count = 1;
        while size(XSaug_cur{i,8},1) - count >= kk-1
            if size(XSaug_cur{i,8},1) - count < 2*(kk-1)
                kk = size(XSaug_cur{i,8},1) - count + 1;
            end
            switch use_num_leads
                case 12
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1)) ... 
                                                                                   XSaug_cur{i,9}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,10}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,11}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,12}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,13}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,14}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,15}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,16}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,17}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,18}(count:count+(kk-1)) ...
                                                                                   XSaug_cur{i,19}(count:count+(kk-1)) ]];
                case 2
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1)) ...
                                                                                                                   XSaug_cur{i,9}(count:count+(kk-1)) ]];
                case 1
                    XSaug_cur_2400 = [XSaug_cur_2400; [XSaug_cur(i,1:7) XSaug_cur{i,8}(count:count+(kk-1))                                            ]];
               otherwise
                   error()
            end
            count = count + kk;
        end
    end
end
clear XSaug_cur

use_wfdb_gqrs = 1; % GQRS is computed by wfdb (java) rather than gqrs.exe

do_shift_ecgpeaks = 1;

shift_peaks_done = 0;
lead = 1;

QRS_all_BIG = [];
QRS_gqrs = [];
waves_wavedet = struct;

QRS_offset = 0;
for i = 1:1:size(XSaug_cur_2400,1)
    %disp([num2str(i) '/' num2str(size(XSaug_cur_2400,1))])
    
    ecg = XSaug_cur_2400{i,7+lead};

    if any(ecg)==0 % tests if all ecg are zeros
        disp(['skipping ecg ' PatID_wrsamp]);
    else

        skip_wavedet = 0;
        if skip_wavedet == 0
            lead_num = 1;
            Fs = 250; gain = 200; fmt = 16;
            %
            ECG_header = struct;
            ECG_header.recname = PatID_wrsamp;
            ECG_header.nsig = length(lead_num);
            ECG_header.freq = Fs;
            ECG_header.nsamp = length(ecg);
            ECG_header.btime = '00:00:00';
            ECG_header.bdate = '01/01/2000';
            ECG_header.spf = NaN;
            ECG_header.baseline = NaN;
            ECG_header.units = 'mV';
            ECG_header.fname = [PatID_wrsamp '.dat'];
            ECG_header.group = 0;
            ECG_header.fmt = fmt;
            ECG_header.gain = gain;
            ECG_header.adcres = 16;
            ECG_header.adczero = 0;
            ECG_header.initval = ecg(1);
            ECG_header.cksum = 0; % ok ???
            ECG_header.bsize = 0;
            ECG_header.desc = repmat('V1',length(lead_num));
            %
            skipme = 0; % if ==0, the R peaks from GQRS will be supplied to wavedet_3D_gn as inputs (if QRS_gqrs~=[])
            if skipme == 0 % supply external R detections
                if use_wfdb_gqrs == 1
                    QRS_gqrs = global_gqrs_wfdb(ecg, PatID_wrsamp, gain);
                end
                if length(QRS_gqrs) > 2
                    if do_shift_ecgpeaks == 1
                        QRS_gqrs = shift_peaks(QRS_gqrs,ecg,ceil(prctile(diff(QRS_gqrs)*4,10)*0.04)*2+1); % 81 note:  ceil(1000*0.04)*2+1 == 81
                        QRS_gqrs = discard_fake_ecgpeaks(QRS_gqrs,ecg,[],250);
                    end
                    if length(QRS_gqrs) > 2
                        QRS_gqrs = shift_peaks(QRS_gqrs,ecg,ceil(prctile(diff(QRS_gqrs)*4,10)*0.04)*2+1); % 81
                    end
                else
                    QRS_gqrs = []; % do not supply external R detections
                    wavedet_config.setup.wavedet.QRS_detection_thr = 2*ones(5,1); % original is QRS_detection_thr = ones(5,1
                end
                shift_peaks_done = 1;
            else
                QRS_gqrs = []; % do not supply external R detections
                wavedet_config.setup.wavedet.QRS_detection_thr = 2*ones(5,1); % original is QRS_detection_thr = ones(5,1)
            end
            if isempty(QRS_gqrs)
                qrs_flag = 0; % R peaks will be computed by wavedet algo itself
            else
                qrs_flag = 1; % if ==1, the R peaks will be read from external source
            end
            wavedet_config.setup.wavedet.qrs_flag = qrs_flag;
            % run wave detection:
            waves_wavedet_i = wavedet_3D_gn( ecg, QRS_gqrs', ECG_header, wavedet_config); % 0.25*250*(ecg/std(ecg)
            a = fields(waves_wavedet_i);
            for ii = 1:length(a)
                eval(['waves_wavedet_i.' a{ii} ' = waves_wavedet_i.' a{ii} '(~isnan(waves_wavedet_i.' a{ii} '));'])
            end
            if isempty(QRS_gqrs)
                QRS_gqrs = waves_wavedet_i.R'; % CAREFUL: if QRS_gqrs are not computed, but waves_wavedet.R are, then pretend that QRS_gqrs == waves_wavedet.R
            end

            if ~isempty(fields(waves_wavedet))
                for ii = 1:length(a) % a = fields(waves_wavedet_i);
                    eval(['waves_wavedet.' a{ii} ' = [waves_wavedet.' a{ii} ';   waves_wavedet_i.' a{ii} '(:) + QRS_offset];'])
                end
            else
                for ii = 1:length(a) % a = fields(waves_wavedet_i);
                    eval(['waves_wavedet.' a{ii} ' = [waves_wavedet_i.' a{ii} '(:) + QRS_offset];'])
                end
            end
        else
            % waves_wavedet = [];
        end

        % GQRS:
        do_gqrs = 1;
        if do_gqrs == 1
            if isempty(QRS_gqrs)
                if use_wfdb_gqrs == 1
                    QRS = global_gqrs_wfdb(ecg,PatID_wrsamp, gain);
                end
            else
                QRS = QRS_gqrs; clear QRS_gqrs
            end
        else
            QRS = XSaug_cur_2400{i,1}; % QRS locations within the ecg strip
        end
        if length(QRS) > 2
            if do_gqrs == 1
                if do_shift_ecgpeaks == 1 && shift_peaks_done == 0
                    QRS = shift_peaks(QRS,ecg,ceil(prctile(diff(QRS)*4,10)*0.04)*2+1); % 81 note:  ceil(1000*0.04)*2+1 == 81
                    QRS = discard_fake_ecgpeaks(QRS,ecg,[],250);
                end
            end
            if length(QRS) > 2
                if do_gqrs == 1 && do_shift_ecgpeaks == 1 && shift_peaks_done == 0
                    QRS = shift_peaks(QRS,ecg,ceil(prctile(diff(QRS)*4,10)*0.04)*2+1); % 81
                end
                
                QRS_all_BIG = [QRS_all_BIG; [QRS(1:end-1) + QRS_offset, QRS(2:end) + QRS_offset]];
                
            end
        end

    end
    QRS_offset = QRS_offset + length(ecg);
end

res = struct;
res.QRS_all_BIG = QRS_all_BIG;
res.patID = patID;
if isempty(fields(waves_wavedet))
    res.waves_wavedet = [];
else
    res.waves_wavedet = waves_wavedet;
end

function anot=local_readannot(name,heasig,t)
% READANNOT  READS DB-ANNOTATION FILES
%
%	Input parameters: name -> character string with name of annotation file
%			  heasig -> header structure signal
%			  t=[t0 t1] -> vector of interval of reading in samples

% Salvador Olmos
% e-mail: olmos@posta.unizar.es


dim=ceil(heasig.nsamp/heasig.freq*2);
% pre-allocating of memory
anot=struct('time',zeros(dim,1),'anntyp',blanks(dim)','subtyp',blanks(dim)','chan',blanks(dim)','num',blanks(dim)','aux',repmat(blanks(dim)',1,10));

del=1;

% Opening binary file
fida=fopen(name,'rb');
if fida<0
   disp('can not open annotation file');
   keyboard;
end

% Initialization of variables
pos=0; 	% relative position to the beginnning of file
i=1; 	% index of annotation number
currnumfield='0';
currchanfield='0';
subtyp='0';

% Reading of the two first bytes for annotation code
data=fread(fida,2,'uchar');
L=['NLRaVFJASEj/Q~ | sT*D"=pB^t+u?!{}en xf()r'];	% Dictionaty of annotation types


while (~feof(fida) & pos<t(2) ),

	A=data(1)+data(2)*256;
	II=rem(A,1024);  	% Distance (in samples) respect to last annotation
	A=floor(A/1024); 	% Annotation code
        if ((A~=0) & A<=length(L)) anot.anntyp(i)=L(A); end  % JGM 100699
        %if (A~=0)  anot.anntyp(i)=L(A); end

        data=fread(fida,2,'uchar');
        if (feof(fida))  del=0; break; end
	A=data(1)+data(2)*256;
	I=rem(A,1024);
	A=floor(A/1024);
      
        while (A>=59)		% Special annotation codes
  	  if A==59,
		skip=fread(fida,4,'uchar');
		I=skip(3)+256*(skip(4)+256*(skip(1)+256*skip(2)));
		pos=pos+I;
	 	I=0;
	  elseif A==60,
		currnumfield=setstr(I);                                
	  elseif A==61,
		subtyp=num2str(I);
	  elseif A==62,
		currchanfield=setstr(I);
	  elseif A==63,
		if rem(I,2)==1,
			I=I+1;
		end;
                h=setstr(fread(fida,I,'char'))';
		anot.aux(i,1:length(h))=h;
	  end;
	  data=fread(fida,2,'uchar');
          if (feof(fida))  del=0; break; end
   	  A=data(1)+data(2)*256;
	  I=rem(A,1024);
	  A=floor(A/1024);
        end
	 
	pos=pos+II;
	anot.time(i)=pos;
	anot.num(i)=currnumfield;
	anot.chan(i)=currchanfield;
	anot.subtyp(i)=str2num(subtyp);
	subtyp='0';
	i=i+1;

end
fclose(fida);

if i<dim
  anot.anntyp(i:dim)=[];
  anot.time(i:dim)=[];
  anot.num(i:dim)=[];
  anot.subtyp(i:dim)=[];
  anot.chan(i:dim)=[];
  anot.aux(i:dim,:)=[];
end


aux=find(anot.time<t(1) | anot.time>=t(2));
anot.time(aux)=[];
anot.anntyp(aux)=[];
anot.subtyp(aux)=[];
anot.num(aux)=[];
anot.chan(aux)=[];  
anot.aux(i-del,:)=' ';

anot.aux=anot.aux(1:i-1-del,:);
%	if A==0,
%elseif A==1,anot.anntyp(i)='N'; %Normal beat
%elseif A==2,anot.anntyp(i)='L'; %Left bundle branch block beat
%elseif A==3,anot.anntyp(i)='R'; %Right bundle branch block beat
%elseif A==4,anot.anntyp(i)='a'; %Aberrated atrial premature beat
%elseif A==5,anot.anntyp(i)='V'; %Premature ventricular contraction
%elseif A==6,anot.anntyp(i)='F'; %Fusuion of ventricular and normal beat
%elseif A==7,anot.anntyp(i)='J'; %Nodal (junctional) premature beat
%elseif A==8,anot.anntyp(i)='A'; %Atrial premature beat
%elseif A==9,anot.anntyp(i)='S'; %Premature or ectopic supraventricular beat
%elseif A==10,anot.anntyp(i)='E'; %Ventricular escape beat
%elseif A==11,anot.anntyp(i)='j'; %Nodal (junctional) escape beat
%elseif A==12,anot.anntyp(i)='/'; %Paced beat
%elseif A==13,anot.anntyp(i)='Q'; %Unclassifiable beat
%elseif A==14,anot.anntyp(i)='~'; %Signal quality change
%elseif A==15,anot.anntyp(i)=''; %Not specified
%elseif A==16,anot.anntyp(i)='|'; %Isolated QRS-like artifact
%elseif A==17,anot.anntyp(i)=''; %Not specified
%elseif A==18,anot.anntyp(i)='s'; %ST change
%elseif A==19,anot.anntyp(i)='T'; %T-wave change
%elseif A==20,anot.anntyp(i)='*'; %Systole
%elseif A==21,anot.anntyp(i)='D'; %Diastole
%elseif A==22,anot.anntyp(i)='"'; %Comment annotation
%elseif A==23,anot.anntyp(i)='='; %Measurement annotation
%elseif A==24,anot.anntyp(i)='p'; %P-wave peak
%elseif A==25,anot.anntyp(i)='B'; %Left or right bundle branch block
%elseif A==26,anot.anntyp(i)='^'; %Non-conducted pacer spike
%elseif A==27,anot.anntyp(i)='t'; %T-wave peak
%elseif A==28,anot.anntyp(i)='+'; %Rythm change         
%elseif A==29,anot.anntyp(i)='u'; %U-wave peak
%elseif A==30,anot.anntyp(i)='?'; %Learning
%elseif A==31,anot.anntyp(i)='!'; %Ventricular flutter wave
%elseif A==32,anot.anntyp(i)='['; %Start of ventricular flutter/fibrillation
%elseif A==33,anot.anntyp(i)=']'; %End of ventricular flutter/fibrillation
%elseif A==34,anot.anntyp(i)='e'; %Atrial escape beat
%elseif A==35,anot.anntyp(i)='n'; %Supraventricular espace beat
%elseif A==36,anot.anntyp(i)=''; %Not specified
%elseif A==37,anot.anntyp(i)='x'; %Non-conducted P-wave (blocked APB)
%elseif A==38,anot.anntyp(i)='f'; %Fusion of paced and normal beat
%elseif A==39,anot.anntyp(i)='('; %Waveform onset
%elseif A==40,anot.anntyp(i)=')'; %Waveform end
%elseif A==41,anot.anntyp(i)='r'; %R-on-T premature ventricular contraction
%end; % Fin de decodificacion de anotacion

function newpeaks = shift_peaks(peaks,signal,interval_search)
% shift the ECG peaks (all of them) to the left or to the right, untill the peaks are found (there is an offset for some of the algos - find it!)
% find new peaks within signal by shifting all current peaks (locked, simultaneously) in an interval_search
% eg:
% ecgpeaks = shift_peaks(ecgpeaks,handles.ECG.leads{1},81);

b = zeros(interval_search,1); % zeros(101,1)
for pp = -(interval_search-1)/2 : (interval_search-1)/2 % -50:50
    a = (peaks - pp); a = a(a>0 & a<length(signal));
    b(pp+(interval_search-1)/2+1) = mean(signal(a));
end
[~,b] = max(b); % find(b==max(b))
b = (interval_search-1)/2 - b + 1;
peaks = peaks + b;
newpeaks = peaks(peaks>0 & peaks<length(signal)); % just in case...


function ecgpeaks = discard_fake_ecgpeaks(ecgpeaks,signal,ectopicECG_ventricular,freqECG)
% check 50 milliseconds before and afterwards. If the current point has values less than the points 50 ms to the right or to the left, then it cannot be a maximum (in smoothed signal) -> discard it
%
% ecgpeaks = discard_fake_ecgpeaks(ecgpeaks,handles.ECG.leads{1},handles.ectopicECG_ventricular,handles.freqECG);

for pp = 1:length(ecgpeaks)
    try % the point can be at borders...
        if ~ismember(pp,ectopicECG_ventricular)
            wrkMax = signal(ecgpeaks(pp) -  round(freqECG*(80/1000)) : ecgpeaks(pp) +  round(freqECG*(84/1000)));
            a = find(wrkMax == max(wrkMax)); a = a(1);
            if a == 1 || a == length(wrkMax)
                ecgpeaks(pp) = 0;
            else
                ecgpeaks(pp) = ecgpeaks(pp) - round(freqECG*(80/1000)) + a;
            end
        end
    catch
    end
end
ecgpeaks = ecgpeaks(ecgpeaks~=0);
