function [ hrv ] = hrv_features( m, Fs, len,fs )

% 
% Copyright (C) 2017 
% Shreyasi Datta
% Chetanya Puri
% Ayan Mukherjee
% Rohan Banerjee
% Anirban Dutta Choudhury
% Arijit Ukil
% Soma Bandyopadhyay
% Rituraj Singh
% Arpan Pal
% Sundeep Khandelwal
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

%HRV_FEATURES Summary of this function goes here
%   Detailed explanation goes here

% upsampling to 2 Hz sampling rate

    tt = m(2:end);
    nn = diff(m)/fs;
    
    nn = nn - mean(nn);
    T = 0:0.5:len;
    yy = spline(tt, nn, T.');
    
    
    [z, fe] = pwelch(yy, 256, 128, 512, Fs);
    [z_ls,fe_ls] = plomb(nn,tt);
    
    bin = [11 40 129];
    
    pt = sum(z);
    
    p1 = sum(z(1:bin(1)))/pt;
    p2 = sum(z(bin(1):bin(2)))/pt;
    p3 = sum(z(bin(2):bin(3)))/pt;
    hrv = [p1 p2 p3 p1/p2 p1/p3 p2/p3]; 
end

