function QRS = global_gqrs_wfdb(ecg, PatID_wrsamp, gain)

cwd = pwd;

% mybasedir = 'D:\Boichev\m\ECG\path';
% mydir = [mybasedir '\' 'results' '\'];
% cd(mydir)
mydir = pwd; mydir = [mydir filesep];

%
Fs = 250; fmt = 16;
%wrsamp((0:length(-ecg)-1)',30*(ecg/std(ecg)),'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
wrsamp((0:length(-ecg)-1)',0.25*250*(ecg/std(ecg)),PatID_wrsamp,Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically

wfdb_argument = [{'-r'}, {PatID_wrsamp}, {'-f'}, {'s0'}];
javaWfdbExec=getWfdbClass('gqrs');
err=javaWfdbExec.execToStringList(wfdb_argument);
if(~isempty(strfind(err.toString,['annopen: can''t'])))
    error(err)
end

file_name_orig = [mydir [PatID_wrsamp '.qrs']];
try
    % anns_test = readannot(file_name_orig); % in which folder is this file ??
    heasig.freq = 250; heasig.nsamp = length(ecg); t = [1 length(ecg)]; anns_test = global_readannot(file_name_orig,heasig,t);
catch
    disp('Error in readannot')
    anns_test = [];
end
delete(file_name_orig);

file_name_orig = [mydir [PatID_wrsamp '.hea']];
delete(file_name_orig);
file_name_orig = [mydir [PatID_wrsamp '.dat']];
delete(file_name_orig);

cd(cwd)
if ~isempty(anns_test)
    QRS = anns_test.time;
else
    QRS = 0;
end
end