function [x_fv,tn,ecg_data1] = get_fv2(ecg_data1,Fs)
%Vignesh Kalidas 
%PhD - Computer Engineering, 
%Dept of Electrical Engineering, 
%University of Texas at Dallas, Texas, USA
% GNU General public License
%     ecg_data1 = ecg_data((288*Fs)+1 : 300*Fs);
    ecg_data1 = ecg_data1 - mean(ecg_data1);
    lp_ecg = butter_bidir(1,ecg_data1,Fs,2,'low');
    ecg_data1 = ecg_data1 - lp_ecg;
    
    [x_fv,tn] = get_features(ecg_data1,Fs);
    
end

function [temp_fv,tn] = get_features(ecg_data1,Fs)

    k = 1;
    temp_fv = [];

    [flat,tn] = verify_flat(ecg_data1,Fs,0);  

    if(~flat)
        f_lim = (((length(ecg_data1)/Fs)-2)*5);
        x_fv(k,(1:500)) = ecg_data1(1:500);
        x_fv(k,(1:500)) = x_fv(k,(1:500)) - mean(x_fv(k,(1:500)));
        [p,f] = periodogram(x_fv(k,1:500),[],[],Fs);
        p = p/max(p);
        temp_fv(k,:) = p(1:41);
        k=k+1;

        for ind=1:1:f_lim

            st = ceil(ind*(0.2*Fs))+1;
            fi = st+(2*Fs)-1;
            x_fv(k,(1:500)) = ecg_data1(st:fi);
            x_fv(k,(1:500)) = x_fv(k,(1:500)) - mean(x_fv(k,(1:500)));
            [p,f] = periodogram(x_fv(k,1:500),[],[],Fs);
            p = p/max(p);
            temp_fv(k,:) = p(1:41);
            k=k+1;
        end
    end
end