function[FEATURES]= get_f3(ECG,Fs)

% Sibylle Fallet
% Sasan Yazdani
% Jean-Marc Vesin
% GNU GEneral public License
fs2=125;
Cuttoff=35; Wp=(Cuttoff/Fs)*2; % Cuttoff frequency to filter ECG
b=fir1(100,Wp); a=1;
ECG(:,1) = filtfilt(b,a,ECG(:,1));
ECG = zscore(ECG);
ECG = resample(ECG,fs2,Fs);
[trans1, ~] = Moving_Average(ECG(:,1),5);
[~, SPI_smooth_fib, ~] = PPG_Spectral_Purity_recursive([trans1(:)],fs2,0,2*fs2);


L=3;
count_max=1;j=1;
% To compute mean and max SPI on L sec windows
SPI_stat=[];
while(count_max < length(SPI_smooth_fib))
    strt = (10*fs2)+((j-1)*fs2);
    st_end = (10*fs2)+((j-1)*fs2)+(L*fs2);
    if length(SPI_smooth_fib) < st_end 
      break;
    else
    SPI_mean(j,1) = mean(SPI_smooth_fib(strt:st_end,1));
    end
    j = j+1;
    count_max = (10*fs2)+((j-1)*fs2)+(L*fs2);
end

FEATURES = max(SPI_mean);

end