function features = get_12ECG_features_ste(signal, tm, ress, leadIdx, leadIdx12Lead, leadIdxData)
    
    sw_transpose_res = true;

    %anns_test = run_ecgpuwave(ecg, Fs, gain);
    %ann_t = anns_test.time;
    %ann_a = anns_test.anntyp;
    
    %ann_t_in_range = ann_t <= length(ecg);
    %ann_t = ann_t(ann_t_in_range);
    %ann_a = ann_a(ann_t_in_range);
    
%     ppeaks_idx = find(ann_a=='p');
%     pbegin_idx = intersect(find(ann_a=='('), ppeaks_idx-1);
%     pbegin = ann_t(pbegin_idx);
%     
%     rpeaks_idx = find(ann_a=='N');
%     qrsend_idx = intersect(find(ann_a==')'), rpeaks_idx+1);
%     qrsend = ann_t(qrsend_idx);
%     
%     tpeaks_idx = find(ann_a=='t');
%     tbegin_idx = intersect(find(ann_a=='('), tpeaks_idx-1);
%     tbegin = ann_t(tbegin_idx);
%     tend_idx = intersect(find(ann_a==')'), tpeaks_idx+1);
%     tend = ann_t(tend_idx);
    
    res = ress{leadIdx12Lead};
    
    if isempty(res.waves_wavedet)
        pbegin = [];    
        qrsend = [];
        tbegin = [];
        tend = [];
    else
        if sw_transpose_res
            pbegin = res.waves_wavedet.Pon';
            %qrsend = res.waves_wavedet.S';
            qrsend = res.waves_wavedet.QRSoff';
            tbegin = res.waves_wavedet.Ton';
            tend = res.waves_wavedet.Toff';
        else
            pbegin = res.waves_wavedet.Pon;
            %qrsend = res.waves_wavedet.S;
            qrsend = res.waves_wavedet.QRSoff;
            tbegin = res.waves_wavedet.Ton;
            tend = res.waves_wavedet.Toff;
        end
    end

    [qrsend, tbegin] = make_comb(qrsend, tbegin);   %st
    [tend, pbegin] = make_comb(tend, pbegin);       %tp 
    
    n_tp = length(tend);
    tp_median_indexs = zeros(1,n_tp);
    
    n_st = length(tbegin);
    st_median_indexs = zeros(1,n_st-1);
    
    for i = 1:n_tp
        t_tp_interval = tend(i):pbegin(i);
        sig_tp_interval = signal(t_tp_interval,leadIdxData);

        median_tp = prctile(sig_tp_interval, 40);
        [~, tp_median_index_sub] = min(abs(sig_tp_interval - median_tp));

        tp_median_index = t_tp_interval(tp_median_index_sub);
        tp_median_indexs(i) = tp_median_index;
    end

    for i = 1:n_st
        t_st_interval = qrsend(i):tbegin(i);
        sig_st_interval = signal(t_st_interval,leadIdxData);

        median_st = prctile(sig_st_interval, 40);
        [~, st_median_index_sub] = min(abs(sig_st_interval - median_st));

        st_median_index = t_st_interval(st_median_index_sub);
        st_median_indexs(i) = st_median_index;
    end

    st_min_tp = trimmean(signal(st_median_indexs, leadIdxData), 10) - trimmean(signal(tp_median_indexs, leadIdxData), 10);

    st_length = trimmean(tm(tbegin) - tm(qrsend), 2);
    %st_length = trimmean(tbegin - qrsend, 2);

    features = [st_min_tp st_length];
        

    
