function features = get_12ECG_features_gn(leads, ress, leadIdx)

    res = ress{leadIdx};
    
    num_leads = size(leads, 2);
    
    % generate features
    
    num_steps = 21;              % manual parameter
    use_Yhat_forS2_filtfilt = 1; % manual parameter
    
    res_{1} = res;
    QRS_all_BIG_ = []; % [R1, R2] per RR interval
    yHat_all_BIG_ = []; % [resized_ecg_1 ... resized_ecg_NUMSTEPS] per RR interval
    for ii=1:size(res_,1)
        % disp(ii)
        QRS_all_BIG_ = [QRS_all_BIG_; res_{ii,1}.QRS_all_BIG];
        eval(['yHat_all_BIG_ = [yHat_all_BIG_; res_{ii,1}.yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt) '];'])
    end
    %
    yHat_all_BIG_mean_ = []; % mean([resized_ecg_1 ... resized_ecg_NUMSTEPS] per RR interval) for a patID
    for ii=1:size(res_,1)
        if ~isempty(eval(['res_{ii, 1}.yHat_all_BIG_s' num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt)]))
            eval(['yHat_all_BIG_mean_ = [yHat_all_BIG_mean_; mean(res_{ii,1}.yHat_all_BIG_s'  num2str(num_steps) '_filtfilt' num2str(use_Yhat_forS2_filtfilt) ',1)];'])
        else
            yHat_all_BIG_mean_ = [yHat_all_BIG_mean_; nan(1,num_steps)];
        end
    end
    QRS_all_BIG_mean_ = []; % mean([R1, R2]) for a patID
    HRV_for_AF = []; % std of RR intervals within a strip
    for ii=1:size(res_,1)
        if ~isempty(res_{ii, 1}.QRS_all_BIG)
            QRS_all_BIG_mean_ = [QRS_all_BIG_mean_; mean(res_{ii,1}.QRS_all_BIG(:,2)-res_{ii,1}.QRS_all_BIG(:,1))];
            HRV_for_AF = [HRV_for_AF; std(res_{ii,1}.QRS_all_BIG(:,2)-res_{ii,1}.QRS_all_BIG(:,1))];
        else
            QRS_all_BIG_mean_ = [QRS_all_BIG_mean_; nan];
            HRV_for_AF = [HRV_for_AF; nan];
        end
    end
    Pwaves_wavedet_all_BIG_ = []; % mean length of P waves, in points (wavedet code)
    for ii=1:size(res_,1)
        if ~isempty(res_{ii, 1}.waves_wavedet) && ~isempty(res_{ii, 1}.waves_wavedet.Pon)
            P1P3 = [];
            for jj=2:length(res_{ii,1}.waves_wavedet.qrs)
                a = [res_{ii,1}.waves_wavedet.Pon(res_{ii,1}.waves_wavedet.Pon > res_{ii,1}.waves_wavedet.qrs(jj-1) & ...
                        res_{ii,1}.waves_wavedet.Pon < res_{ii,1}.waves_wavedet.qrs(jj)), ...
                     res_{ii,1}.waves_wavedet.Poff(res_{ii,1}.waves_wavedet.Poff > res_{ii,1}.waves_wavedet.qrs(jj-1) & ...
                        res_{ii,1}.waves_wavedet.Poff < res_{ii,1}.waves_wavedet.qrs(jj))];
                if length(a)==2
                    P1P3 = [P1P3; diff(a)];
                end
            end
            if ~isempty(P1P3) && size(P1P3,1) >= 3
                Pwaves_wavedet_all_BIG_ = [Pwaves_wavedet_all_BIG_; mean(P1P3)];
            else
                Pwaves_wavedet_all_BIG_ = [Pwaves_wavedet_all_BIG_; nan];
            end
        else
            Pwaves_wavedet_all_BIG_ = [Pwaves_wavedet_all_BIG_; nan];
        end
    end
    QS_wavedet_all_BIG_ = []; % mean length of QS waves, in points (wavedet code)
    for ii=1:size(res_,1)
        QS = [];
        if ~isempty(res_{ii, 1}.waves_wavedet) && ~isempty(res_{ii, 1}.waves_wavedet.QRSon) && ~isempty(res_{ii, 1}.waves_wavedet.QRSoff) && ~isempty(res_{ii, 1}.QRS_all_BIG)
            for jj=1:size(res_{ii, 1}.QRS_all_BIG,1)
                % find Q to the left of R before another R
                Q = res_{ii, 1}.waves_wavedet.QRSon(res_{ii, 1}.waves_wavedet.QRSon > res_{ii, 1}.QRS_all_BIG(jj,1)-40 & res_{ii, 1}.waves_wavedet.QRSon < res_{ii, 1}.QRS_all_BIG(jj,1)+0*40);
                S = res_{ii, 1}.waves_wavedet.QRSoff(res_{ii, 1}.waves_wavedet.QRSoff > res_{ii, 1}.QRS_all_BIG(jj,1)-0*40 & res_{ii, 1}.waves_wavedet.QRSoff < res_{ii, 1}.QRS_all_BIG(jj,1)+40);
                try QS = [QS; unique(S)-unique(Q)]; catch; QS = nan; end
            end
            Q = res_{ii, 1}.waves_wavedet.QRSon(res_{ii, 1}.waves_wavedet.QRSon > res_{ii, 1}.QRS_all_BIG(end,2)-40 & res_{ii, 1}.waves_wavedet.QRSon < res_{ii, 1}.QRS_all_BIG(end,2)+0*40);
            S = res_{ii, 1}.waves_wavedet.QRSoff(res_{ii, 1}.waves_wavedet.QRSoff > res_{ii, 1}.QRS_all_BIG(end,2)-0*40 & res_{ii, 1}.waves_wavedet.QRSoff < res_{ii, 1}.QRS_all_BIG(end,2)+40);
            try QS = [QS; unique(S)-unique(Q)]; catch; QS = nan; end
            if length(QS) >= 3
                QS_wavedet_all_BIG_ = [QS_wavedet_all_BIG_; median(QS(~isnan(QS)))];
            else
                QS_wavedet_all_BIG_ = [QS_wavedet_all_BIG_; nan];
            end
        else
            QS_wavedet_all_BIG_ = [QS_wavedet_all_BIG_; nan];
        end
        % sum(isnan(QS_wavedet_all_BIG_))
    end
    P1Q_wavedet_all_BIG_ = []; % feature for I-AVB: mean length of PstartQ intervals, in points (wavedet code)
    for ii=1:size(res_,1)
        P1Q = [];
        if ~isempty(res_{ii, 1}.waves_wavedet) && ~isempty(res_{ii, 1}.waves_wavedet.Pon) && ~isempty(res_{ii, 1}.waves_wavedet.QRSon)
            for jj=2:size(res_{ii, 1}.QRS_all_BIG,1)
                % find Q to the left of R before another R
                P1 = res_{ii, 1}.waves_wavedet.Pon(res_{ii, 1}.waves_wavedet.Pon > res_{ii, 1}.QRS_all_BIG(jj,1) & res_{ii, 1}.waves_wavedet.Pon < res_{ii, 1}.QRS_all_BIG(jj,2));
                Q = res_{ii, 1}.waves_wavedet.QRSon(res_{ii, 1}.waves_wavedet.QRSon > res_{ii, 1}.QRS_all_BIG(jj,1) & res_{ii, 1}.waves_wavedet.QRSon < res_{ii, 1}.QRS_all_BIG(jj,2));
                try P1Q = [P1Q; Q-P1]; catch P1Q = nan; end
            end
            if length(QS) >= 3
                P1Q_wavedet_all_BIG_ = [P1Q_wavedet_all_BIG_; median(P1Q(~isnan(P1Q)))];
            else
                P1Q_wavedet_all_BIG_ = [P1Q_wavedet_all_BIG_; nan];
            end
        else
            P1Q_wavedet_all_BIG_ = [P1Q_wavedet_all_BIG_; nan];
        end
        %%% sum(isnan(P1Q_wavedet_all_BIG_))
        % y = double(ismember(Phy2020files(:,2),'#Dx: I-AVB'));
        % [tmpx,TPrate,T,AUC] = perfcurve(y,P1Q_wavedet_all_BIG_,1);
        % figure; plot(tmpx,TPrate); title(['AUC = ' num2str(round(100*AUC)/100)])  % plot in-sample AUC
    end
    invT_wavedet = []; % 0/1 whether the T-wave is inverted (in all leads)
    for ii=1:size(res_,1)
        %disp(ii)
        invT_12_all = [];
        if ~isempty(res_{ii, 1}.waves_wavedet) && ~isempty(res_{ii, 1}.waves_wavedet.T) && ~isempty(res_{ii, 1}.QRS_all_BIG)
            % check if all of [Tstart T Tend] are within the GQRS R1-R2 peaks
            for jj = 1:size(res_{ii, 1}.QRS_all_BIG,1)
                b = [res_{ii, 1}.waves_wavedet.Ton(res_{ii, 1}.waves_wavedet.Ton > res_{ii, 1}.QRS_all_BIG(jj,1) & ...
                        res_{ii, 1}.waves_wavedet.Ton < res_{ii, 1}.QRS_all_BIG(jj,2)), ...
                     res_{ii, 1}.waves_wavedet.T(res_{ii, 1}.waves_wavedet.T > res_{ii, 1}.QRS_all_BIG(jj,1) & ...
                        res_{ii, 1}.waves_wavedet.T < res_{ii, 1}.QRS_all_BIG(jj,2)), ...
                     res_{ii, 1}.waves_wavedet.Toff(res_{ii, 1}.waves_wavedet.Toff > res_{ii, 1}.QRS_all_BIG(jj,1) & ...
                        res_{ii, 1}.waves_wavedet.Toff < res_{ii, 1}.QRS_all_BIG(jj,2))];                            
                if length(b) == 3 % [Ton T Toff] is found
                    % load the data
                    % leads = data'; % load_phy2020_strip(Phy2020files{ii,1}); % georgi new
                    %
                    %invT_12 = zeros(1,12); % 12 leads for the current RR interval
                    invT_12 = zeros(1,num_leads); % 12 leads for the current RR interval
                    for lead = 1:num_leads  %12
                        a = leads(b,lead);
                        if min(a)==a(2)
                            invT_12(1,lead) = 1; % then the T wave is inverted
                        else
                            invT_12(1,lead) = 0; % then the T wave has normal shape
                        end
                    end
                    invT_12_all = [invT_12_all; invT_12];
                end
            end
            if ~isempty(invT_12_all)
                invT_wavedet = [invT_wavedet; mean(invT_12_all,1)];
            else
                invT_wavedet = [invT_wavedet; nan(1,num_leads)];
            end
        else
            invT_wavedet = [invT_wavedet; nan(1,num_leads)];
        end
    end

    % make a training dataset
    
%     Xcols = {... 
%             'QRS_all_BIG_mean_',...
%             'HRV_for_AF',...
%             'Pwaves_wavedet_all_BIG_',...
%             'invT_wavedet_Lead_1',...
%             'invT_wavedet_Lead_2',...
%             'invT_wavedet_Lead_3',...
%             'invT_wavedet_Lead_4',...
%             'invT_wavedet_Lead_5',...
%             'invT_wavedet_Lead_6',...
%             'invT_wavedet_Lead_7',...
%             'invT_wavedet_Lead_8',...
%             'invT_wavedet_Lead_9',...
%             'invT_wavedet_Lead_10',...
%             'invT_wavedet_Lead_11',...
%             'invT_wavedet_Lead_12',...
%             'QS_wavedet_all_BIG_',...
%             'P1Q_wavedet_all_BIG_',...
%             }; % add below all 'dyHat_all_BIG_mean_Lead_I_xxx'
    
    Xcols = {... 
            'QRS_all_BIG_mean_',...
            'HRV_for_AF',...
            'Pwaves_wavedet_all_BIG_',...
            'QS_wavedet_all_BIG_',...
            'P1Q_wavedet_all_BIG_',...
            }; % add below all 'dyHat_all_BIG_mean_Lead_I_xxx'
            a = cell(1,size(yHat_all_BIG_mean_,2)-1);
            for ii=1:size(yHat_all_BIG_mean_,2)-1 % "-1" as we take the difference along columns
                a{ii} = ['dyHat_all_BIG_mean_Lead_I_' num2str(ii)];
            end
	Xcols = [Xcols, a]; % all features
%     Xdata = [QRS_all_BIG_mean_,...
%             HRV_for_AF,...
%             Pwaves_wavedet_all_BIG_,...
%             invT_wavedet,...
%             QS_wavedet_all_BIG_,...
%             P1Q_wavedet_all_BIG_,...
%             diff(yHat_all_BIG_mean_,[],2),...
%             ];
    Xdata = [QRS_all_BIG_mean_,...
            HRV_for_AF,...
            Pwaves_wavedet_all_BIG_,...
            QS_wavedet_all_BIG_,...
            P1Q_wavedet_all_BIG_,...
            diff(yHat_all_BIG_mean_,[],2),...
            ];

	X = Xdata;

    colsEXCL = {''};
    X = X(:,~ismember(Xcols,colsEXCL));
	% X = X(~isnan(X(:,ismember(Xcols,'QRS_all_BIG_mean_'))),:); % remove from X all rows where QRS_all_BIG_mean_ == NaN %%% TO DO - haendle this case (georgi)
    XcolsTRAIN = Xcols(~ismember(Xcols,colsEXCL))';
%     % replace NaN by column mean per class:
%     for i = 1:size(X,2) % TO DO: handle case witu NaN's (georgi), as it cannot be handled by the code below
%         disp(['missing for i = ' XcolsTRAIN{i} ': ' num2str(sum(isnan(X(:,i))))])
%         %X(Y==0 & isnan(X(:,i)),i) = mean(X(Y==0 & ~isnan(X(:,i)),i));
%         %X(Y==1 & isnan(X(:,i)),i) = mean(X(Y==1 & ~isnan(X(:,i)),i));
%     end
    
    features.GN.set1 = X; % features for models without PAC and PVC
    features.GN.set5 = invT_wavedet;
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    RRR = 0; % if == 1 will use RRR data [R1 R3] rather than RR-RR data strips [[R1 R2] [R2 R3]]

    %myfile = 1;
    if ~isempty(res.yHat_all_RRR_BIG) % note : we have also to check: ~isempty(res.yHat_all_BIG_s21_filtfilt0)
        if RRR == 1
        % run also "remove_ectopic_forHR.m" and use the result as a feature!
            Xtest = res.yHat_all_RRR_BIG;
        else
            Xtest = [res.yHat_all_BIG_s21_filtfilt1(1:end-1,:) res.yHat_all_BIG_s21_filtfilt1(2:end,:)];
        end
        Xtest = (Xtest - mean(Xtest,2)*ones(1,size(Xtest,2)))./(arrayfun(@(x) std(Xtest(x,:)), (1:size(Xtest,1))')*ones(1,size(Xtest,2))); % normalize to std(x)==1 (do this before the diff() to avoid logit simgularity )
        Xtest = diff(Xtest,[],2);
        % Ytest = ones(size(Xtest,1),1); % fake labels

        %Ynewpreds = mnrval(B,Xtest); % NOTE: B should exist (make it below)
        %YnewpredsMAX = max(Ynewpreds(:,2));
        %YnewpredsMAX_all(myfile) = YnewpredsMAX;
        %%%Xtest_all = [Xtest_all; Xtest];
    else
        Xtest = zeros(1,41); % TO DO - temp solution
        %YnewpredsMAX_all(myfile) = -999;
        %%%Xtest_all        = [Xtest_all; Xtest]; % assumes that the first Xtest is "ok" so we get the right number of columns 
    end
    
    features.GN.set2.X = Xtest; % features only for models for PAC and PVC
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    RRR = 1; % if == 1 will use RRR data [R1 R3] rather than RR-RR data strips [[R1 R2] [R2 R3]]

    %myfile = 1;
    if ~isempty(res.yHat_all_RRR_BIG) % note : we have also to check: ~isempty(res.yHat_all_BIG_s21_filtfilt0)
        if RRR == 1
        % run also "remove_ectopic_forHR.m" and use the result as a feature!
            Xtest = res.yHat_all_RRR_BIG;
        else
            Xtest = [res.yHat_all_BIG_s21_filtfilt1(1:end-1,:) res.yHat_all_BIG_s21_filtfilt1(2:end,:)];
        end
        Xtest = (Xtest - mean(Xtest,2)*ones(1,size(Xtest,2)))./(arrayfun(@(x) std(Xtest(x,:)), (1:size(Xtest,1))')*ones(1,size(Xtest,2))); % normalize to std(x)==1 (do this before the diff() to avoid logit simgularity )
        Xtest = diff(Xtest,[],2);
        % Ytest = ones(size(Xtest,1),1); % fake labels

        %Ynewpreds = mnrval(B,Xtest); % NOTE: B should exist (make it below)
        %YnewpredsMAX = max(Ynewpreds(:,2));
        %YnewpredsMAX_all(myfile) = YnewpredsMAX;
        %%%Xtest_all = [Xtest_all; Xtest];
    else
        Xtest = zeros(1,40); % TO DO - temp solution
        %YnewpredsMAX_all(myfile) = -999;
        %%%Xtest_all        = [Xtest_all; Xtest]; % assumes that the first Xtest is "ok" so we get the right number of columns 
    end
    
    features.GN.set3.X = Xtest; % features only for models for PAC vs PVC

end



