function features = get_12ECG_features(data, header_data, sw_train, current_lead_names, Ts_relevant_leads, T_relevant_leads_00, lead_names)

    %parforNumWorkers = 0; %Inf
    parforNumWorkers = Inf;

    generate_mb_features = false;
    generate_sd_features = false;
    generate_ste_features = false;
    generate_phase_1_features = true;
    generate_phase_2_features = true;
    
    max_time = 20; %180
    
    sw_save_res = false;
    %res_dir = 'E:\PhysioNetChallenge2020\all_data_res';
    %res_dir = 'E:\PhysioNetChallenge2020\partition_2_res';
    res_dir = 'E:\PhysioNetChallenge2021';

    % Definition of relevant leads

    n_leads = size(data, 1);
    
    if sw_train
        T_relevant_leads = T_relevant_leads_00;
    else
        T_relevant_leads = Ts_relevant_leads{n_leads};
    end
    % Initialisations

    global dsc_n_catch;
    global dsc_n_missing;
    global dsc_n_ok;
    
    [recording,Total_time,~,Fs,~,age,sex]=extract_data_from_header(header_data);
    
    if Total_time > max_time
       tmax = min(max_time * Fs, size(data, 2));
       data = data(:,1:tmax); 
    end
    
    % 1081 OK
    % 250  NOK
    % 2156 TOTAL
    
    n_catch_max = 1000; %250; %12;

    available_lead = min(data, [], 2) ~= max(data, [], 2);
    
    if sum(available_lead) ~= n_leads
        dsc_n_missing = dsc_n_missing + 1;
    end
    
    features = struct;
    features.GN = struct;
    
    % Matlab baseline model features
    
    features.HE = [age sex];
    
    features.MB = cell(12,1);
    
    dsc_n_catch_local = 0;
    
    M_relevant_leads = [T_relevant_leads.lead_nums T_relevant_leads.MB T_relevant_leads.MB];
    
    %leadIdx12Lead = find(M_relevant_leads(:,3));
    idx12LeadToIdxnLeads = cumsum(M_relevant_leads(:,2));
    
    if sw_train
        leadset_idxs = 1:length(Ts_relevant_leads);
    else
        num_leads = size(data, 1);
        leadset_idxs = num_leads;
    end
    
    lead_names_current_mb = lead_names(T_relevant_leads.MB == 1);
    
    for leadset_idx = leadset_idxs
        Tab_relevant_leads = Ts_relevant_leads{leadset_idx};
        
        if ~isempty(Tab_relevant_leads)            
            %if n_leads == 12 
                try
                    if generate_mb_features
                        lead_idxs_12 = find(Tab_relevant_leads.MB);
                        lead_names_current = lead_names(lead_idxs_12);
                        lead_idxs = idx12LeadToIdxnLeads(lead_idxs_12);
                        [~, lead_idxs_data] = ismember(lead_names_current, current_lead_names);
                        features_MB = get_12ECG_features_mb(data(lead_idxs_data, :), header_data, lead_idxs, lead_idxs_data, lead_idxs_12);
                        features_MB = features_MB(3:end); %exclude age and sex features since they are in HE
                    else
                        features_MB = zeros(1,22);
                    end
                catch e
                    %[msgstr,errID] = lasterr;
                    disp(['catch in MB ' recording ' (' e.message ')']);
                    features_MB = NaN(1,22);
                    dsc_n_catch_local = dsc_n_catch_local + 1;
                end

                %Note: the index into the structure is here a leadset_idx.
                %      this is different from the meaning of th index elsewhere
                %      where it means a particular lead!
                features.MB{leadset_idx} = features_MB;

            %else
            %   features.MB = [];
            %end
        end
    end
    
    % SD's AF features
    
    M_relevant_leads = [T_relevant_leads.lead_nums T_relevant_leads.MB T_relevant_leads.SD];

    leadIdx12Lead = find(M_relevant_leads(:,3));
    lead_names_current = lead_names(leadIdx12Lead);
    [~, lead_idxs_data] = ismember(lead_names_current, current_lead_names);
    idx12LeadToIdxnLeads = cumsum(M_relevant_leads(:,2));

    leadIdxs = idx12LeadToIdxnLeads(leadIdx12Lead)'; %LeadIdx in input %leadIdxs = [1 2 7]; %(in case of 12 leads)
    features_SD_n_leads = length(leadIdxs);
    
    if generate_sd_features
        features_SD_lead_n = cell(features_SD_n_leads,1);

        %for i = 1:length(leadIdxs)
        parfor (i = 1:features_SD_n_leads, parforNumWorkers)

            leadIdx = leadIdxs(i);
            leadIdxData = lead_idxs_data(i);

            %disp(['Lead: ' num2str(leadIdx)]);
            
%             if leadIdx == 11
%                disp('Lead 11'); 
%             end
            
            isok = false;

            try
                
                if available_lead(leadIdxData)
                    features_SD_lead_n{i,1} = challenge(data, header_data, leadIdxData);
                    isok = true;
                end
                
                %save(['D:\physionet2021_models\debug_train_' num2str(i)], 'data', 'header_data', 'leadIdx');
                %save(['D:\physionet2021_models\debug_test_' num2str(i)], 'data', 'header_data', 'leadIdx');

            catch e
                    disp(['catch in SD ' recording ' (' e.message ')']);
                    dsc_n_catch_local = dsc_n_catch_local + 1; 
            end
            
            if ~isok
                MeanVector_208 = load('MeanVector_208.mat', 'MeanVector_208');
                MeanVector_208 = MeanVector_208.MeanVector_208;
                features_SD_lead_n{i,1} = MeanVector_208;
            end
            
        end

        if dsc_n_catch_local > 0
            dsc_n_catch = dsc_n_catch + 1;
            disp(['catch ' num2str(dsc_n_catch) ' in :' recording]);
        else
            dsc_n_ok = dsc_n_ok + 1;
        end

        if dsc_n_catch > n_catch_max
            error(['Too many catches in get_12ECG_features_mb: ' num2str(dsc_n_ok)]);
        end

        %features.SD = [features_SD_lead_n{1,1} features_SD_lead_n{2,1} features_SD_lead_n{3,1}];    

        features.SD = cell(12,1);

        for i = 1:features_SD_n_leads
             features.SD{leadIdx12Lead(i)} = features_SD_lead_n{i,1};
        end
    else
        for i = 1:features_SD_n_leads
            features.SD{leadIdx12Lead(i)} = zeros(1, 188);
        end
    end
    % resample
    
    signal = data';

    recording = strrep(recording,'.mat', '');
    
    n = size(signal,1);
    freq = Fs;
    leads = zeros(round(size(signal,1)*250/freq),size(signal,2));

    if freq ~= 250
        for i=1:size(signal,2)
            leads(:,i) = round( interp1((1:n)*(1000/freq),signal(1:n,i),(1:round(n*(250/freq)))*(1000/250),'linear','extrap')');
        end
    end

    signal = leads;
    
    tm = [0 (1:(size(signal, 1)-1))/250];
    
    if generate_phase_1_features
        load('params.mat','params')
    
        d1 = params.d1;
        bbb = params.bbb;
        aaa = params.aaa;
        use_num_leads = params.use_num_leads;
    else
        use_num_leads = 1;
    end
    
    Phy2020file = recording;
    
    % wavedet
    
    %start new
    relevant_leads_GV = T_relevant_leads.GV;
    M_relevant_leads = [T_relevant_leads.lead_nums T_relevant_leads.MB T_relevant_leads.GN];
    
    leadIdx12Lead = find(M_relevant_leads(:,3));
    
    lead_names_current = lead_names(leadIdx12Lead);
    [~, lead_idxs_data] = ismember(lead_names_current, current_lead_names);
    
    leadIdxs = idx12LeadToIdxnLeads(leadIdx12Lead)'; %LeadIdx in input %leadIdxs = [1 2 5 7 10 12]; %(in case of 12 leads)
    features_GN_n_leads = length(leadIdxs);          % 6 for 12-lead case
    
    %re-order leads such that they are in the same order as we expect them
    %the order in which we got them:    current_lead_names 
    %the order in which we expect them: lead_names_current_mb
    [~, lead_reordering] = ismember(lead_names_current_mb, current_lead_names);
    leads = leads(:, lead_reordering);
    %end new
    
    ress = cell(12,1);
    ress_ph2 = cell(12,1);
    res_parfor = cell(features_GN_n_leads,1);
    res_parfor_ph2 = cell(features_GN_n_leads,1);    %was cell(2,1)
    
    %for leadIdxIdx = 1:length(leadIdxs)
    parfor (leadIdxIdx = 1:length(leadIdxs), parforNumWorkers)
        % disp(num2str(leadIdx));
        leadIdx = leadIdxs(leadIdxIdx);
        leadIdx12 = leadIdx12Lead(leadIdxIdx);
        leadIdxData = lead_idxs_data(leadIdxIdx);
        
        if generate_phase_1_features
            res_parfor{leadIdxIdx} = global_predict_20segments_model([], signal(:,leadIdxData), use_num_leads,d1,bbb,aaa,[Phy2020file '_' num2str(leadIdx)]);
        end
        
        if generate_phase_2_features
            %if leadIdx <= 2
            %if leadIdxIdx <= 2
            if relevant_leads_GV(leadIdx12)
                % NOTE: will only prepare data, predictions are carried out outside this function
                res_parfor_ph2{leadIdxIdx} = predict_20segments_model_sub(signal(:,leadIdxData), use_num_leads, Phy2020file, [Phy2020file '_' num2str(leadIdx)]);
            end
        end
    end
    
    for leadIdxIdx = 1:length(leadIdxs)
        % disp(num2str(leadIdx));
        %leadIdx = leadIdxs(leadIdxIdx);
        leadIdx12 = leadIdx12Lead(leadIdxIdx);
        
        ress{leadIdx12} = res_parfor{leadIdxIdx}; % was ress{leadIdx}
        
        if generate_phase_2_features
            %if leadIdx <= 2
            %if leadIdxIdx <= 2
            if relevant_leads_GV(leadIdx12)
                ress_ph2{leadIdx12} = res_parfor_ph2{leadIdxIdx}; % was res_phs{leadIdx}
            end
        end
    end
    
    res_lead = cell(12,1);
    
    if generate_phase_2_features
        for leadIdxIdx = 1:length(leadIdxs)
            % disp(num2str(leadIdx));
            %leadIdx = leadIdxs(leadIdxIdx);
            leadIdx12 = leadIdx12Lead(leadIdxIdx);
            
            %if leadIdx <= 2
            %if leadIdxIdx <= 2
            if relevant_leads_GV(leadIdx12)
                res_lead{leadIdx12} = {res_parfor_ph2{leadIdxIdx}};
            end
        end
    end
    
    if sw_save_res
        save([res_dir '\' recording '.mat'], 'ress');
    end
    
    % GN features
    
    features.GN = cell(12,1);
    
    for leadIdxIdx = 1:length(leadIdxs)
        % disp(num2str(leadIdx));
        % leadIdx = leadIdxs(leadIdxIdx);
        leadIdx12 = leadIdx12Lead(leadIdxIdx);
        
        if generate_phase_1_features

            % features_gn_model_I.mat        1
            % features_gn_model_II.mat       2 
            % features_gn_model_aVL.mat      5
            % features_gn_model_v1.mat       7
            % features_gn_model_v4.mat       10
            % features_gn_model_v6.mat       12

            %TODO: inv T features from GN cannot be done as is for <
            %12 leads. Should be fixed so that it can be done on less leads
            
            %leadIdx = 1,2,5,7,10,12
            features_gn_lead = get_12ECG_features_gn(leads, ress, leadIdx12); 

            %features.SD{leadIdx12Lead(i)} = features_SD_lead_n{i,1};
            features.GN{leadIdx12} = features_gn_lead;

%             features.GN.set1 = [features_gn_lead_1.GN.set1 ...
%                                 features_gn_lead_2.GN.set1 ...
%                                 features_gn_lead_5.GN.set1 ...
%                                 features_gn_lead_7.GN.set1 ...
%                                 features_gn_lead_10.GN.set1 ...
%                                 features_gn_lead_12.GN.set1 ...
%                                 ];
% 
%             features.GN.set2.X = [features_gn_lead_1.GN.set2.X; ...
%                                 features_gn_lead_2.GN.set2.X; ...
%                                 features_gn_lead_5.GN.set2.X; ...
%                                 features_gn_lead_7.GN.set2.X; ...
%                                 features_gn_lead_10.GN.set2.X; ...
%                                 features_gn_lead_12.GN.set2.X; ...
%                                 ];
% 
%             features.GN.set3.X = [features_gn_lead_1.GN.set3.X; ...
%                                 features_gn_lead_2.GN.set3.X; ...
%                                 features_gn_lead_5.GN.set3.X; ...
%                                 features_gn_lead_7.GN.set3.X; ...
%                                 features_gn_lead_10.GN.set3.X; ...
%                                 features_gn_lead_12.GN.set3.X; ...
%                                 ];         
        end
    
    end
    
    
    if generate_phase_2_features
        
        num_leads = size(leads, 2);
        all_leads = leads;
        all_lead_names = lead_names;
        
        if sw_train || num_leads == 12 %|| (~isempty(res_lead{1}) && ~isempty(res_lead{2}))
            res_lead_01_and_02 = res_lead(1:2);
            
            if sw_train
                leads = all_leads(:, Ts_relevant_leads{12}.MB == 1);
                lead_names = all_lead_names(Ts_relevant_leads{12}.MB == 1);
            else
                lead_names = current_lead_names;
            end
            
            [X, ~, invT_leads, rmse_linfit_Twave_leads, dy_QR_wavedet, dy_QRS_span_wavedet] = load_phy2020_strip_sub_NOste(leads, res_lead_01_and_02, lead_names);
            %features.GN.set4.X = X;
            %features.GN_multi_lead.lead_01_and_02.set4.X = X;
            features.GN_multi_lead.n_leads_is_12.set4.X = X;
            features.GN_multi_lead.n_leads_is_12.set4.invT_leads = invT_leads;
            features.GN_multi_lead.n_leads_is_12.set4.rmse_linfit_Twave_leads = rmse_linfit_Twave_leads;
            features.GN_multi_lead.n_leads_is_12.set4.dy_QR_wavedet = dy_QR_wavedet;
            features.GN_multi_lead.n_leads_is_12.set4.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
            
%             disp('12-lead:');
%             disp(['set4.X: ' num2str(length(X))]);
%             disp(['set4.invT_leads: ' num2str(length(invT_leads))]);
%             disp(['set4.rmse_linfit_Twave_leads: ' num2str(length(rmse_linfit_Twave_leads))]);
%             disp(['set4.dy_QR_wavedet: ' num2str(length(dy_QR_wavedet))]);
%             disp(['set4.dy_QRS_span_wavedet: ' num2str(length(dy_QRS_span_wavedet))]);
            
        end
        
        if sw_train || num_leads == 6 %|| (~isempty(res_lead{1}) && ~isempty(res_lead{2}))
            res_lead_01_and_02 = res_lead(1:2);
            
            if sw_train
                leads = all_leads(:, logical(Ts_relevant_leads{6}.MB));
                lead_names = all_lead_names(logical(Ts_relevant_leads{6}.MB));
            else
                lead_names = current_lead_names;
            end
            %TODO: also use above construction further on... (twice)
            
            [X, ~, invT_leads, rmse_linfit_Twave_leads, dy_QR_wavedet, dy_QRS_span_wavedet] = load_phy2020_strip_sub_NOste(leads, res_lead_01_and_02, lead_names);
            %features.GN.set4.X = X;
            %features.GN_multi_lead.lead_01_and_02.set4.X = X;
            features.GN_multi_lead.n_leads_is_06.set4.X = X;
            features.GN_multi_lead.n_leads_is_06.set4.invT_leads = invT_leads;
            features.GN_multi_lead.n_leads_is_06.set4.rmse_linfit_Twave_leads = rmse_linfit_Twave_leads;
            features.GN_multi_lead.n_leads_is_06.set4.dy_QR_wavedet = dy_QR_wavedet;
            features.GN_multi_lead.n_leads_is_06.set4.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
            
%             disp('6-lead:');
%             disp(['set4.X: ' num2str(length(X))]);
%             disp(['set4.invT_leads: ' num2str(length(invT_leads))]);
%             disp(['set4.rmse_linfit_Twave_leads: ' num2str(length(rmse_linfit_Twave_leads))]);
%             disp(['set4.dy_QR_wavedet: ' num2str(length(dy_QR_wavedet))]);
%             disp(['set4.dy_QRS_span_wavedet: ' num2str(length(dy_QRS_span_wavedet))]);
        end
        
        if sw_train || num_leads == 3 %|| (~isempty(res_lead{1}) && ~isempty(res_lead{2}))
            res_lead_01_and_02 = res_lead(1:2);
            
            if sw_train
                leads = all_leads(:, logical(Ts_relevant_leads{3}.MB));
                lead_names = all_lead_names(logical(Ts_relevant_leads{3}.MB));
            else
                lead_names = current_lead_names;
            end
            
            [X, ~, invT_leads, rmse_linfit_Twave_leads, dy_QR_wavedet, dy_QRS_span_wavedet] = load_phy2020_strip_sub_NOste(leads, res_lead_01_and_02, lead_names);
            features.GN_multi_lead.n_leads_is_03.set4.X = X;
            features.GN_multi_lead.n_leads_is_03.set4.invT_leads = invT_leads;
            features.GN_multi_lead.n_leads_is_03.set4.rmse_linfit_Twave_leads = rmse_linfit_Twave_leads;
            features.GN_multi_lead.n_leads_is_03.set4.dy_QR_wavedet = dy_QR_wavedet;
            features.GN_multi_lead.n_leads_is_03.set4.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
        end
        
        if sw_train || num_leads == 2 %|| (~isempty(res_lead{1}) && ~isempty(res_lead{2}))
            res_lead_01_and_02 = res_lead(1:2);
            
            if sw_train
                leads = all_leads(:, logical(Ts_relevant_leads{2}.MB));
                lead_names = all_lead_names(logical(Ts_relevant_leads{2}.MB));
            else
                lead_names = current_lead_names;
            end
            
            [X, ~, invT_leads, rmse_linfit_Twave_leads, dy_QR_wavedet, dy_QRS_span_wavedet] = load_phy2020_strip_sub_NOste(leads, res_lead_01_and_02, lead_names);
            features.GN_multi_lead.n_leads_is_02.set4.X = X;
            features.GN_multi_lead.n_leads_is_02.set4.invT_leads = invT_leads;
            features.GN_multi_lead.n_leads_is_02.set4.rmse_linfit_Twave_leads = rmse_linfit_Twave_leads;
            features.GN_multi_lead.n_leads_is_02.set4.dy_QR_wavedet = dy_QR_wavedet;
            features.GN_multi_lead.n_leads_is_02.set4.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
        end
        
        % new from here on
        
        if sw_train || num_leads == 4 %|| (~isempty(res_lead{1}) && ~isempty(res_lead{2}))
            res_lead_01_and_02 = res_lead(1:2);
            
            if sw_train
                leads = all_leads(:, logical(Ts_relevant_leads{4}.MB));
                lead_names = all_lead_names(logical(Ts_relevant_leads{4}.MB));
            else
                lead_names = current_lead_names;
            end
            
            [X, ~, invT_leads, rmse_linfit_Twave_leads, dy_QR_wavedet, dy_QRS_span_wavedet] = load_phy2020_strip_sub_NOste(leads, res_lead_01_and_02, lead_names);
            %features.GN.set4.X = X;
            %features.GN_multi_lead.lead_01_and_02.set4.X = X;
            features.GN_multi_lead.n_leads_is_04.set4.X = X;
            features.GN_multi_lead.n_leads_is_04.set4.invT_leads = invT_leads;
            features.GN_multi_lead.n_leads_is_04.set4.rmse_linfit_Twave_leads = rmse_linfit_Twave_leads;
            features.GN_multi_lead.n_leads_is_04.set4.dy_QR_wavedet = dy_QR_wavedet;
            features.GN_multi_lead.n_leads_is_04.set4.dy_QRS_span_wavedet = dy_QRS_span_wavedet;
        end        
        
        % new from here on end
        
    else
        %features.GN_multi_lead.lead_01_and_02.set4.X = [];
        %features.GN_multi_lead.lead_01_and_11.set4.X = [];
        
        features.GN_multi_lead.n_leads_is_12.set4.X = [];
        features.GN_multi_lead.n_leads_is_06.set4.X = [];
        features.GN_multi_lead.n_leads_is_04.set4.X = [];
        features.GN_multi_lead.n_leads_is_03.set4.X = [];
        features.GN_multi_lead.n_leads_is_02.set4.X = [];
    end
    
    % STE features
    
    lead_names = all_lead_names;
        
    %features.STE = get_12ECG_features_ste_leads(signal, tm, ress);

    %start new
    M_relevant_leads = [T_relevant_leads.lead_nums T_relevant_leads.MB T_relevant_leads.ST];

    leadIdx12Lead = find(M_relevant_leads(:,3));

    lead_names_current = lead_names(leadIdx12Lead);
    [~, lead_idxs_data] = ismember(lead_names_current, current_lead_names);

    leadIdxs = idx12LeadToIdxnLeads(leadIdx12Lead)'; %LeadIdx in input %leadIdxs = [1 2 5 7 10 12]; %(in case of 12 leads)
    features_ST_n_leads = length(leadIdxs);          % 6 for 12-lead case
    %end new

    features.STE = cell(12,1);
    
    if generate_ste_features
        for leadIdxIdx = 1:length(leadIdxs)
            % disp(num2str(leadIdx));
            leadIdx = leadIdxs(leadIdxIdx);
            leadIdx12 = leadIdx12Lead(leadIdxIdx);
            leadIdxData = lead_idxs_data(leadIdxIdx);

            features.STE{leadIdx12} = get_12ECG_features_ste(signal, tm, ress, leadIdx, leadIdx12, leadIdxData);
        end
    else
        for leadIdxIdx = 1:length(leadIdxs)
            % disp(num2str(leadIdx));
            leadIdx = leadIdxs(leadIdxIdx);
            leadIdx12 = leadIdx12Lead(leadIdxIdx);
            leadIdxData = lead_idxs_data(leadIdxIdx);

            features.STE{leadIdx12} = zeros(1, 2);
        end
    end
    
    features.dsc_n_catch_local = dsc_n_catch_local;
    