function generate_all_res__for_phase2_sub()
% This file is especially made for submission of phase 2, physionet2020 challenge
%
%%% Will generate all res_ variables and them in D:\MDS\physionet2020\people\georgi\res_ph2_submission

do_res_     = 1; % if == 1, then res_ will be calculated
save_output = 1;

phase       = 2;

% shortcut for loop in file: predict_20segments_model.m
dataset_ph2_all = {'PhysioNetChallenge2020_PTB-XL', 'Training_Set_2', 'Training_E', 'Training_PTB', 'Training_StPetersburg', 'Training_CPSC_SNOMED-CT'}; % all datasets
for d = 1:length(dataset_ph2_all)
    disp(['Dataset = ' dataset_ph2_all{d}])
    dataset_ph2 = dataset_ph2_all{d}; % 'PhysioNetChallenge2020_PTB-XL', 'Training_Set_2', 'Training_E', 'Training_PTB', 'Training_StPetersburg', 'Training_CPSC_SNOMED-CT'
    % dataset_ph2 = 'PhysioNetChallenge2020_PTB-XL'; % set here for which dataset to create the res_ variable
    load(['D:\MDS\physionet2020\trainingdataZIP\labels\Phy2020files_' dataset_ph2 '.mat'],'Phy2020files')

    use_num_leads = 1;
    for lead = 1:2
        % lead = 2; % default:1  - which lead to use for waves detections
        if do_res_ == 1
            res_ = {};
        end
        for myfile = 1:size(Phy2020files,1)
            disp([Phy2020files{myfile,1} ', ' Phy2020files{myfile,2} ', lead ' num2str(lead)])

            Phy2020file = Phy2020files{myfile,1};

            % load data (a single patient)
            if phase == 1
                f=load(['D:\MDS\physionet2020\trainingdata\' Phy2020file '.mat']); % for phase 1
            elseif phase == 2
                f=load(['D:\MDS\physionet2020\trainingdataZIP\' dataset_ph2 '\' Phy2020file '.mat']); % part of phase 2
            end
            data = f.val'; % 12 Lead ECG

            data = data(:,1:12); % note: gain=200 (below assumed in gqrs) vs gain==1000 (real) ??
            if phase == 2
                switch dataset_ph2
                    case {'PhysioNetChallenge2020_PTB-XL', 'Training_Set_2', 'Training_E','Training_CPSC_SNOMED-CT'}
                        freq = 500; % see e.g. "D:\MDS\physionet2020\trainingdataZIP\PhysioNetChallenge2020_PTB-XL\HR00001.hea"
                    case {'Training_StPetersburg'}
                        freq = 257; % e.g. "D:\MDS\physionet2020\trainingdataZIP\Training_StPetersburg\I0006.hea"
                    case {'Training_PTB'}
                        freq = 1000; % e.g. "D:\MDS\physionet2020\trainingdataZIP\Training_PTB\S0001.hea"
                end
            elseif phase == 1
                freq = 500;
            end

            n = size(data,1);
            leads = zeros(round(size(data,1)*250/freq),size(data,2));
            if freq ~= 250
                for i=1:size(data,2)
                    leads(:,i) = round( interp1((1:n)*(1000/freq),data(1:n,i),(1:round(n*(250/freq)))*(1000/250),'linear','extrap')');
                end
            end

            if do_res_ == 1
                % R_YhatSVM : [R1 R2 yHat_score]
                res = predict_20segments_model_sub(leads(:,lead), use_num_leads,Phy2020file); % NOTE: will only prepare data, predictions are carried out outside this function
                % add the header file to res:
                if phase == 2
                    res.header = readcell(['D:\MDS\physionet2020\trainingdataZIP\' dataset_ph2 '\' Phy2020file '.hea'],'FileType','text','Delimiter','|');
                elseif phase == 1
                    res.header = readcell(['D:\MDS\physionet2020\trainingdata\' Phy2020file '.hea'],'FileType','text','Delimiter','|');
                end
                res_ = [res_; {res Phy2020file Phy2020files(myfile,2)}];
                clear res
            end

        end
        if phase == 2 && do_res_ == 1 && save_output == 1
            save(['D:\MDS\physionet2020\people\georgi\res_ph2_submission\' dataset_ph2 '_' 'QRS_X_y_labels_lead' num2str(lead) '.mat'],'res_')
        end
    end
end








