% Transformes structure which stores features per lead
% to a vector of features
%
% Inputs:
% features: 
%   Structure which stores features per lead.
% T_relevant_leads:
%   Table which contains information about from which leads the 
%   features have to be extracted
%
% Output:
% features_vec:
%   Vector of features as extracted from the indicated leads
%
% Usage example:
% n_leads = 3;
% T_relevant_leads = Ts_relevant_leads{n_leads};
function features_vec = flatten_12ECG_features(features, T_relevant_leads_00, T_relevant_leads, sw_train)

n_leads = sum(T_relevant_leads.MB);

%if n_leads == 12
%else
%end

features_vec.HE = features.HE;

features_vec.MB = features.MB{n_leads};

if isfield(features, 'SD')
    features_sd_vec = reshape(cell2mat(features.SD(T_relevant_leads.SD == 1))', 1, []); %1x564 double (3 leads * 188 features per lead)

    features_vec.SD = features_sd_vec;  
else
    features_vec.SD = [];  
end

if isfield(features, 'STE')
    features_ste_vec = reshape(cell2mat(features.STE(T_relevant_leads.ST == 1))', 1, []); 

    features_vec.STE = features_ste_vec;
else
    features_vec.STE = [];
end

features_gn = features.GN(T_relevant_leads.GN == 1);

features_gn_set1_vec = reshape(cell2mat(cellfun(@(x) x.GN.set1, features_gn, 'UniformOutput', false))', 1, []);
%features_gn_set2_vec = cellfun(@(x) x.GN.set2.X, features_gn, 'UniformOutput', false);
features_gn_set2_vec = cell2mat(cellfun(@(x) x.GN.set2.X, features_gn, 'UniformOutput', false)); %69x41 double (3 leads * 23 features per lead)
features_gn_set3_vec = cell2mat(cellfun(@(x) x.GN.set3.X, features_gn, 'UniformOutput', false)); %69x40 double (3 leads * 23 features per lead)

features_vec.GN.set1 = features_gn_set1_vec; %111 double   (3 leads * 37 features per lead)
features_vec.GN.set2.X = features_gn_set2_vec; %69x41 double (3 leads * 23 features per lead)
features_vec.GN.set3.X = features_gn_set3_vec; %69x41 double (3 leads * 23 features per lead)

switch n_leads
    case 2
    % If we have more than 2 leads, lead I and II happen to be available
    %features_vec.GN.set4.X = features.GN_multi_lead.lead_01_and_02.set4.X;
        features_gn_set4_struct = features.GN_multi_lead.n_leads_is_02.set4;
    case 3
    % If we have 2 leads, lead I and V5 happen to be available
    %features_vec.GN.set4.X = features.GN_multi_lead.lead_01_and_11.set4.X;
        features_gn_set4_struct = features.GN_multi_lead.n_leads_is_03.set4;
    case 4
        features_gn_set4_struct = features.GN_multi_lead.n_leads_is_04.set4;
    case 6
        features_gn_set4_struct = features.GN_multi_lead.n_leads_is_06.set4;
    case 12
        features_gn_set4_struct = features.GN_multi_lead.n_leads_is_12.set4;
end

tmp = features_gn_set4_struct;

if isfield(tmp, 'invT_leads')
    features_vec.GN.set4.X = [tmp.X tmp.invT_leads tmp.rmse_linfit_Twave_leads tmp.dy_QR_wavedet tmp.dy_QRS_span_wavedet];
else
    features_vec.GN.set4.X = [];
end

if sw_train
    %gn_set5_mask = zeros(12,1);
    %gn_set5_mask(T_relevant_leads.MB == 1,:) = 1;
    
    %features_idx_gn_computed = T_relevant_leads_00.GN;
    %features_idx_gn_required = T_relevant_leads
    
    features_gn_set5_vec = reshape(cell2mat(cellfun(@(x) x.GN.set5(T_relevant_leads.MB == 1), features_gn, 'UniformOutput', false))', 1, []);
else
    features_gn_set5_vec = reshape(cell2mat(cellfun(@(x) x.GN.set5, features_gn, 'UniformOutput', false))', 1, []);
end

features_vec.GN.set5.X = features_gn_set5_vec;

features_vec.X = [features_vec.HE features_vec.MB features_vec.GN.set1 features_vec.SD features_vec.STE features_vec.GN.set4.X features_vec.GN.set5.X];
