function Tfeature_names_all = feature_names(T_relevant_leads)

feature_names_mb = {    'age'
                        'gender'
                        'QRSTang'
                        'QRSTang_M'
                        'AZ_OQ'
                        'AZ_OQM'
                        'AZ_OT'
                        'AZ_OTM'
                        'AZ_SVG'
                        'AZ_SVG_M'
                        'EL_OQ'
                        'EL_OQM'
                        'EL_OT'
                        'EL_OTM'
                        'EL_SVG'
                        'EL_SVG_M'
                        'QRS_Mag'
                        'QRS_Mag_M'
                        'T_Mag'
                        'T_Mag_M'
                        'SVG_Mag'
                        'QT_interval'
                        'AUC_VM_QT'
                        'WVG'
};

%save('D:\cpcardio\physionet_2020\data\features\official_phase\feature_names_mb.mat', 'feature_names_mb');
  
feature_names_gn_all = {
                    'QRS_all_BIG_mean_'
                    'HRV_for_AF'
                    'Pwaves_wavedet_all_BIG_'
                    'invT_wavedet_Lead_1'
                    'invT_wavedet_Lead_2'
                    'invT_wavedet_Lead_3'
                    'invT_wavedet_Lead_4'
                    'invT_wavedet_Lead_5'
                    'invT_wavedet_Lead_6'
                    'invT_wavedet_Lead_7'
                    'invT_wavedet_Lead_8'
                    'invT_wavedet_Lead_9'
                    'invT_wavedet_Lead_10'
                    'invT_wavedet_Lead_11'
                    'invT_wavedet_Lead_12'
                    'QS_wavedet_all_BIG_'
                    'P1Q_wavedet_all_BIG_'
                    'dyHat_all_BIG_mean_Lead_I_1'
                    'dyHat_all_BIG_mean_Lead_I_2'
                    'dyHat_all_BIG_mean_Lead_I_3'
                    'dyHat_all_BIG_mean_Lead_I_4'
                    'dyHat_all_BIG_mean_Lead_I_5'
                    'dyHat_all_BIG_mean_Lead_I_6'
                    'dyHat_all_BIG_mean_Lead_I_7'
                    'dyHat_all_BIG_mean_Lead_I_8'
                    'dyHat_all_BIG_mean_Lead_I_9'
                    'dyHat_all_BIG_mean_Lead_I_10'
                    'dyHat_all_BIG_mean_Lead_I_11'
                    'dyHat_all_BIG_mean_Lead_I_12'
                    'dyHat_all_BIG_mean_Lead_I_13'
                    'dyHat_all_BIG_mean_Lead_I_14'
                    'dyHat_all_BIG_mean_Lead_I_15'
                    'dyHat_all_BIG_mean_Lead_I_16'
                    'dyHat_all_BIG_mean_Lead_I_17'
                    'dyHat_all_BIG_mean_Lead_I_18'
                    'dyHat_all_BIG_mean_Lead_I_19'
                    'dyHat_all_BIG_mean_Lead_I_20'
};

%save('D:\cpcardio\physionet_2020\data\features\official_phase\feature_names_gn.mat', 'feature_names_gn_all');

feature_names_gn = {
                    'QRS_all_BIG_mean_'
                    'HRV_for_AF'
                    'Pwaves_wavedet_all_BIG_'
%                     'invT_wavedet_Lead_1'
%                     'invT_wavedet_Lead_2'
%                     'invT_wavedet_Lead_3'
%                     'invT_wavedet_Lead_4'
%                     'invT_wavedet_Lead_5'
%                     'invT_wavedet_Lead_6'
%                     'invT_wavedet_Lead_7'
%                     'invT_wavedet_Lead_8'
%                     'invT_wavedet_Lead_9'
%                     'invT_wavedet_Lead_10'
%                     'invT_wavedet_Lead_11'
%                     'invT_wavedet_Lead_12'
                    'QS_wavedet_all_BIG_'
                    'P1Q_wavedet_all_BIG_'
                    'dyHat_all_BIG_mean_Lead_I_1'
                    'dyHat_all_BIG_mean_Lead_I_2'
                    'dyHat_all_BIG_mean_Lead_I_3'
                    'dyHat_all_BIG_mean_Lead_I_4'
                    'dyHat_all_BIG_mean_Lead_I_5'
                    'dyHat_all_BIG_mean_Lead_I_6'
                    'dyHat_all_BIG_mean_Lead_I_7'
                    'dyHat_all_BIG_mean_Lead_I_8'
                    'dyHat_all_BIG_mean_Lead_I_9'
                    'dyHat_all_BIG_mean_Lead_I_10'
                    'dyHat_all_BIG_mean_Lead_I_11'
                    'dyHat_all_BIG_mean_Lead_I_12'
                    'dyHat_all_BIG_mean_Lead_I_13'
                    'dyHat_all_BIG_mean_Lead_I_14'
                    'dyHat_all_BIG_mean_Lead_I_15'
                    'dyHat_all_BIG_mean_Lead_I_16'
                    'dyHat_all_BIG_mean_Lead_I_17'
                    'dyHat_all_BIG_mean_Lead_I_18'
                    'dyHat_all_BIG_mean_Lead_I_19'
                    'dyHat_all_BIG_mean_Lead_I_20'
};



feature_names_gn_invT = {
                    'invT_wavedet_Lead_1'
                    'invT_wavedet_Lead_2'
                    'invT_wavedet_Lead_3'
                    'invT_wavedet_Lead_4'
                    'invT_wavedet_Lead_5'
                    'invT_wavedet_Lead_6'
                    'invT_wavedet_Lead_7'
                    'invT_wavedet_Lead_8'
                    'invT_wavedet_Lead_9'
                    'invT_wavedet_Lead_10'
                    'invT_wavedet_Lead_11'
                    'invT_wavedet_Lead_12'
};

feature_names_gn_rmse_linfit_Twave = {
                    'rmse_linfit_Twave_Lead_1'
                    'rmse_linfit_Twave_Lead_2'
                    'rmse_linfit_Twave_Lead_3'
                    'rmse_linfit_Twave_Lead_4'
                    'rmse_linfit_Twave_Lead_5'
                    'rmse_linfit_Twave_Lead_6'
                    'rmse_linfit_Twave_Lead_7'
                    'rmse_linfit_Twave_Lead_8'
                    'rmse_linfit_Twave_Lead_9'
                    'rmse_linfit_Twave_Lead_10'
                    'rmse_linfit_Twave_Lead_11'
                    'rmse_linfit_Twave_Lead_12'
};


feature_names_sd = {'AFEv'
                    'OriginCount'
                    'IrrEv'
                    'PACEv'
                    'DensityEv'
                    'AniEv'
                    'CVrr'
                    'CVdrr'
                    'stepping'
                    'dispersion'
                    'numclust'
                    'mean_RR'
                    'median_RR'
                    'min_RR'
                    'max_RR'
                    'sk_RR'
                    'kurt_RR'
                    'range_RR'
                    'var_RR'
                    'E'
                    'MOBILITY'
                    'COMPLEXITY_CP'
                    'kurt_f'
                    'skew_f'
                    'num_pks'
                    'maxdist'
                    'mindist'
                    'kurt_f1'
                    'skew_f1'
                    'kurt_f3'
                    'skew_f3'
                    'num_pks3'
                    'var_amp'
                    'var_en'
                    'rs1'
                    'rs2'
                    'rs3'
                    'med_st'
                    'var_st'
                    'num_neg_st'
                    'deep_s'
                    'inflec_dist_s'
                    'tr_amp'
                    'P_to_R_ratio'
                    'Q1'
                    'Q2'
                    'Q3'
                    'Q4'
                    'rq1'
                    'rq2'
                    'rq3'
                    'SR1'
                    'SR2'
                    'med_qr'
                    'var_qr'
                    'med_rs'
                    'var_rs'
                    'med_sx'
                    'var_sx'
                    'QT1'
                    'QT2'
                    'QT3'
                    'QT4'
                    'QT5'
                    'QT6'
                    'pNN20'
                    'pNN50'
                    'SDSD'
                    'Shannon'
                    'Tsallis'
                    'Renyi'
                    'centroid'
                    'rolloff'
                    'flux'
                    'kur_mean'
                    'log_var_detcoef'
                    'linear_predictor_coeff_2'
                    'linear_predictor_coeff_4'
                    'linear_predictor_coeff_7'
                    'linear_predictor_coeff_9'
                    'linear_predictor_coeff_10'
                    'linear_predictor_coeff_11'
                    'frequency_centroid'
                    'std(drloc)'
                    'std(dploc)'
                    'length(dploc)/length(drloc)'
                    %'min([ std(drloc(c1))/median(c1)  std(drloc(c2))/median(c2)  std(drloc(c3))/median(c3)] '
                    'min_std(drloc(a))_over_median_a([c1 c2 c3]'
                    'std(major)'
                    'std(dploc_new)'
                    'std(drloc_new)'
                    'std(median(drloc(a)))(c1 c2 c3)'
                    ' abs(median(dploc) - median(drloc))'
                    'median(dploc)'
                    'length(dploc)'
                    'length(drloc)'
                    'median(drloc(1:t))/median(drloc(t:end))'
                    'Abs(fft(drloc))'
                    'Abs(fft(dploc))'
                    'brady less than 50 bpm on drloc'
                    'max(drloc) - min(drloc)'
                    'brady less than 50 bpm on dploc'
                    'median(drloc)'
                    'median(major)'
                    'max(dploc) - min(dploc)'
                    'RMS of successive differences of RR'
                    'Mean/median absolute deviation of RR'
                    'HRV: Power spectral density bin 1'
                    'HRV: Power spectral density bin 2'
                    'HRV: Power spectral density bin 3'
                    'HRV: Power spectral density bin 1/2'
                    'HRV: Power spectral density bin 1/3'
                    'HRV: Power spectral density bin 2/3'
                    'Trimmed mean of FFT coefficients on ECG'
                    'Skewness of FFT coefficients on ECG'
                    '80% energy containing band of FFT coefficients on ECG'
                    'Kurtosis of frequency coeff of FFT coeff on ECG'
                    'Kurtosis of time series data'
                    'COMPLEXITY'
                    'SNR'
                    'Total Harmonic Distortion (THD)'
                    'Zero Crossing Rate (ZCR)'
                    'Short time energy'
                    'Spectral Centriod'
                    'Spectral roll off'
                    'Spectral flux'
                    'Small difference between peak and through'
                    'High difference between peak and through'
                    'Highest FFT coefficient'
                    'Diff between highest second highest FFT coeff'
                    'Zero crossings in empirical mode decomposition'
                    'Standard deviation of empirical mode decomposition'
                    'median(delta_hr_s)^2'
                    'Histogram bin containing most delta_hr_s'
                    'sum of squares of delta_hr_s higher than median'
                    'Highest FFT coeff on ecg compl ordered by delta_hr_s'
                    'Areas of frequency band 0-2 relative to total area'
                    'Areas of frequency band 2-4 relative to total area'
                    'Areas of frequency band 4-10 relative to total area'
                    'Areas of frequency band 10-150 relative to total area'
                    'entropy_feat_1 of RR'
                    'entropy_feat_2  of RR'
                    'entropy_feat_3  of RR'
                    'entropy_feat_4  of RR'
                    'entropy_feat_5 of RR'
                    'num_inf (in entropy of RR)'
                    'max_entropy (in entropy of RR)'
                    'min_entropy (in entropy of RR)'
                    'max_ind (in entropy of RR)'
                    'min_ind (in entropy of RR)'
                    'log-log plt slope of intgrtd y vs window sz (on RR) 1'
                    'log-log plt slope of intgrtd y vs window sz (on RR) 2'
                    'Poincare feature: successive differences (on RR) 1'
                    'Poincare feature: successive differences (on RR) 2'
                    'Approximate Entropy of RR Intervals 1'
                    'Approximate Entropy of RR Intervals 2'
                    'Approximate Entropy of RR Intervals 3'
                    'Approximate Entropy of RR Intervals 4'
                    'Approximate Entropy of RR Intervals 5'
                    'Num of points in filtered ECG which are far from mean'
                    'Std of points in filtered ECG which are far from mean'
                    'Max Power Spectral Density averaged over ECG blocks'
                    'Num peaks in PSD avgd over ECG blocks'
                    'Frequency of peaks on ECG block normlized using xcorr'
                    'Ratio of freq of peaks and max power spectral density'
                    'Std of peak-to-peak dist on ECG block xcorr-normlized'
                    'Std of peak amplitudes on ECG block xcorr-normalized'
                    'Area of periodogram for specific range of freqs'
                    %'Area of periodogram for a specific range of freqs as a fraction of total area of periodogram'
                    'Area of periodogram for specific range of freqs reltv'
                    'Area of periodogram reltv around max below spec freq'
                    'Number of throughs on ECG normalized using xcorr'
                    'BPM from R peaks (lower bound)'
                    'BPM from R peaks (upper bound)'
                    'Mean Spectral purity of ECG'
                    'Max Spectral purity of ECG'
                    'Max RR interval size'
                    'SNR on ECG filtered with wavelet'
                    'fraction of 5 largest PCA comps on signal around R'
                    'PSD Integral: ratio of pwr in QRS complex (~5-15 Hz)'
                    'PSD Integral: ratio of pwr in baseline (~0-1 Hz)'
                    'kurtosis of ECG'
                    'skewness of ECG'
                    'Num complexes differing sufficiently from avgQRS tpl'
                    'low_hr_beats: num consecutive beats with BPM below 40'
                    'low_hr_5: minimum heart rate of 5 consecutive beats'
                    'high_hr_beats: num of consecutive beats BPM above 140'
                    'high_hr_17: maximum HR of 17 consecutive beats'
                    'hr_max: maximum heart rate'
                    'max_rr: maximum RR interval'
};

%save('D:\cpcardio\physionet_2020\data\features\official_phase\feature_names_sd.mat', 'feature_names_sd');

feature_names_ste = {
                    'st_min_tp'
                    'st_length'
};

%save('D:\cpcardio\physionet_2020\data\features\official_phase\feature_names_ste.mat', 'feature_names_ste');

%X = [all_features_bm feature_matrix_gn all_features_sd all_features_ste];

%feature_names_gn_af_av_ste_std = load('D:\cpcardio\physionet_2020\data\features\features_gn_af_av_ste_std_matrix.mat');%.feature_names;
%feature_names_gn_af_av_ste_std = feature_names_gn_af_av_ste_std.feature_names;
%feature_names_gn_af_av_ste_std = feature_names_gn_af_av_ste_std(1:end-1);

 list_features = {'P1R_wavedet1' 'P1R_wavedet2' 'P2R_wavedet1' 'P2R_wavedet2' ... 
        'P1Q_wavedet1' 'P1Q_wavedet2' 'P3R_wavedet1' 'P3R_wavedet2' 'T3P1_wavedet1' 'T3P1_wavedet2' ...
        'QS_wavedet1' 'QS_wavedet2' 'HR_gqrs1' 'HR_gqrs2' 'HR_std_gqrs1' 'HR_std_gqrs2'  ...
        'dy_QR_RS_wavedet' ...
        'dy_PQ_wavedet1' 'dy_PQ_wavedet2' 'QTc_wavedet1' 'QTc_wavedet2' ...
        }';

% feature_names_all = [feature_names_mb ; ...
%                      repmat(feature_names_gn, 12, 1) ; ...
%                      feature_names_gn_invT ;
%                      repmat(feature_names_sd, 3, 1) ; ...
%                      repmat(feature_names_ste, 12, 1) ; ...
%                      feature_names_gn_af_av_ste_std'];

%features_vec.GN.set4.X = [tmp.X tmp.invT_leads tmp.rmse_linfit_Twave_leads tmp.dy_QR_wavedet tmp.dy_QRS_span_wavedet];
                 
 %features_vec.X = [features_vec.HE             % 2     v
 %                  features_vec.MB             % 22    v
 %                  features_vec.GN.set1        % 150   v 6 leads * 25    
 %                  features_vec.SD             % 564   v 3 leads * 188
 %                  features_vec.STE            % 10    v 5 leads * 2
 %                  features_vec.GN.set4.X      % 75 
 %                  features_vec.GN.set5.X      % 72
 %];                                            % 895
  
 %n_invT_leads = 1; %2
 n_invT_leads = 2;
 %T_relevant_leads = Ts_relevant_leads{2};
 %T_relevant_leads = Ts_relevant_leads{3};
 %T_relevant_leads = Ts_relevant_leads{4};
 %T_relevant_leads = Ts_relevant_leads{6};
 %T_relevant_leads = Ts_relevant_leads{12};
 
 feature_names_gn_invT = feature_names_gn_invT(T_relevant_leads.MB == 1);
 feature_names_gn_rmse_linfit_Twave = feature_names_gn_rmse_linfit_Twave(T_relevant_leads.MB == 1);
 
 num_leads = sum(T_relevant_leads.MB);
 
 %I, II, III, avF
 switch num_leads
     case {12, 6}
        dy_QR_wavedet_features = {'dy_QR_wavedet_I', 'dy_QR_wavedet_II', 'dy_QR_wavedet_III', 'dy_QR_wavedet_avF'}';
     case 4
        dy_QR_wavedet_features = {'dy_QR_wavedet_I', 'dy_QR_wavedet_II', 'dy_QR_wavedet_III'}';
     case {3, 2}
        dy_QR_wavedet_features = {'dy_QR_wavedet_I', 'dy_QR_wavedet_II'}';
 end
 
 dy_QRS_span_wavedet_features = {'dy_QRS_span_wavedet_limb', 'dy_QRS_span_wavedet_precordial'}';
 
 feature_names_gn_set4 = [list_features                   ; ...                           %            21          GN.X (set 4)
     repmat(feature_names_gn_invT, n_invT_leads, 1) ; ...                       %            24
     repmat(feature_names_gn_rmse_linfit_Twave, n_invT_leads, 1) ; ...          %            24
     dy_QR_wavedet_features              ; ...
     dy_QRS_span_wavedet_features        ...
     ];
 
 feature_names_all = [feature_names_mb                      ; ...    %            24        V 24
     repmat(feature_names_gn,  sum(T_relevant_leads.GN), 1) ; ...    % 25  * 6 = 150        V 100
     repmat(feature_names_sd,  sum(T_relevant_leads.SD), 1) ; ...    % 188 * 3 = 564        V 564
     repmat(feature_names_ste, sum(T_relevant_leads.ST), 1) ; ...    % 2   * 5 =  10        V 8 
     feature_names_gn_set4               ; ...                                              V 42
     repmat(feature_names_gn_invT, sum(T_relevant_leads.GN), 1)                             %V 16
      ];       
  
 feature_set_names_all = [cellstr(repmat('mb', length(feature_names_mb), 1) ); ...
                          cellstr(repmat('gn', sum(T_relevant_leads.GN) * length(feature_names_gn), 1) ); ...
                          cellstr(repmat('sd', sum(T_relevant_leads.SD) * length(feature_names_sd), 1) ); ...
                          cellstr(repmat('ste', sum(T_relevant_leads.ST) * length(feature_names_ste), 1) ); ...
                          cellstr(repmat('gn4', length(feature_names_gn_set4), 1) ); ...
                          cellstr(repmat('gn_invT', length(feature_names_gn_invT) * sum(T_relevant_leads.GN), 1) ); ...
                          ];
                 
%cellstr(repmat('gn_af_av_std', length(feature_names_gn_af_av_ste_std), 1) ); ...                      

feature_leads_all = [zeros(length(feature_names_mb),1)                                                  ; ...
                     reshape(repmat(find(T_relevant_leads.GN)', length(feature_names_gn), 1), [], 1)    ;  ...
                     reshape(repmat(find(T_relevant_leads.SD)', length(feature_names_sd), 1), [], 1)    ;  ...
                     reshape(repmat(find(T_relevant_leads.ST)', length(feature_names_ste), 1), [], 1)    ;  ...
                     zeros(length(feature_names_gn_set4),1) ; ...
                    reshape(repmat(find(T_relevant_leads.GN)', length(feature_names_gn_invT), 1), [], 1)];
                 

% feature_leads_all = [zeros(length(feature_names_mb),1) ; ...
%                      1 * ones(length(feature_names_gn),1) ; ...
%                      2 * ones(length(feature_names_gn),1) ; ...
%                      3 * ones(length(feature_names_gn),1) ; ...
%                      4 * ones(length(feature_names_gn),1) ; ...
%                      5 * ones(length(feature_names_gn),1) ; ...
%                      6 * ones(length(feature_names_gn),1) ; ...
%                      7 * ones(length(feature_names_gn),1) ; ...
%                      8 * ones(length(feature_names_gn),1) ; ...
%                      9 * ones(length(feature_names_gn),1) ; ...
%                      10 * ones(length(feature_names_gn),1) ; ...
%                      11 * ones(length(feature_names_gn),1) ; ...
%                      12 * ones(length(feature_names_gn),1) ; ...
%                      zeros(length(feature_names_gn_invT),1) ; ...
%                      1 * ones(length(feature_names_sd),1) ; ...
%                      2 * ones(length(feature_names_sd),1) ; ...
%                      7 * ones(length(feature_names_sd),1) ; ...
%                      1 * ones(length(feature_names_ste),1) ; ...
%                      2 * ones(length(feature_names_ste),1) ; ...
%                      3 * ones(length(feature_names_ste),1) ; ...
%                      4 * ones(length(feature_names_ste),1) ; ...
%                      5 * ones(length(feature_names_ste),1) ; ...
%                      6 * ones(length(feature_names_ste),1) ; ...
%                      7 * ones(length(feature_names_ste),1) ; ...
%                      8 * ones(length(feature_names_ste),1) ; ...
%                      9 * ones(length(feature_names_ste),1) ; ...
%                      10 * ones(length(feature_names_ste),1) ; ...
%                      11 * ones(length(feature_names_ste),1) ; ...
%                      12 * ones(length(feature_names_ste),1) ; ...
%                      zeros(length(feature_names_gn_af_av_ste_std),1)];
%                  
feature_names_all(:,2) = cellstr(num2str(feature_leads_all));
feature_names_all(:,3) = feature_set_names_all;
                 
Tfeature_names_all = cell2table(feature_names_all,'VariableNames',{'feature_name', 'lead', 'set'});
%writetable(Tfeature_names_all,'d:\feature_names_12_lead.csv');
%writetable(Tfeature_names_all,'d:\feature_names_6_lead.csv');
%writetable(Tfeature_names_all,'d:\feature_names_4_lead.csv');
%writetable(Tfeature_names_all,'d:\feature_names_3_lead.csv');
%writetable(Tfeature_names_all,'d:\feature_names_2_lead.csv');

% imp = predictorImportance(Custom_classifier);
% 
% ind = imp ~= 0;
% feature_names_imp = feature_names_all(ind);
% imp = imp(ind);
% 
% figure;
% bar(imp);
% title('Predictor Importance Estimates');
% ylabel('Estimates');
% xlabel('Predictors');
% h = gca;
% h.XTickLabel = feature_names_imp;
% %h.XTickLabelRotation = 45;
% h.TickLabelInterpreter = 'none';
% 
% Custom_classifier.Trained{2, 1}.CompactRegressionLearner.PredictorNames = feature_names_all;
% 
% 
% %Custom_classifier.Trained{2, 1}.CompactRegressionLearner.PredictorNames{1} = 'abc'
% 
% for treeIdx = 1:50
%     dtree = Custom_classifier.Trained{treeIdx, 1}.CompactRegressionLearner;
% 
%     pred = dtree.CutPredictorIndex(dtree.CutPredictorIndex > 0);
% 
%     features = feature_names_all(pred);
% 
%     disp('  ');
%     for i = 1:size(pred)
%         disp([num2str(pred(i)) ':   ' features{i}]); 
%     end
% 
%     view(dtree ,'mode','graph')
% 
% 
%     pause();
% 
% end


