input_directory = 'D:\CPCardio-\data\PhysioNetChallenge2020_Training_CPSC\';
code_directory = 'D:\cpcardio\physionet_2020\shreyasi-datta-209\';
feature_directory = 'D:\cpcardio\physionet_2020\data\features\features_shreyasi_datta\';

cd('D:\DSC\evaluation-2020');

input_files = {};
for f = dir(input_directory)'
    if exist(fullfile(input_directory, f.name), 'file') == 2 && f.name(1) ~= '.' && all(f.name(end - 2 : end) == 'mat')
        input_files{end + 1} = f.name;
    end
end

input_files = sort(input_files);

k0 = 746;
k = 1;
for k =k0:length(input_files)  
    input_file_name_and_ext = strsplit(input_files{k}, '.');
    input_file_name = input_file_name_and_ext{1};
    
    prev_dir = pwd;

    cd(code_directory)

    try
        f1 = challenge(input_file_name);
        save([feature_directory input_file_name '.mat'], 'f1');
    catch ME
        disp('error: skipping record');
    end
    cd(prev_dir);    
    
    disp([input_file_name num2str(mean(f1))]);
    
end



%f1 = challenge('A00001');
%[f1, classifyResult] = challenge('A00001')