function [PredictedAnnotation] = PhysionetCascadedClassifier(FeatureVctor, tb_allS1, tb_allS2, tb_allS3)
% 
% Copyright (C) 2017 
% Shreyasi Datta
% Chetanya Puri
% Ayan Mukherjee
% Rohan Banerjee
% Anirban Dutta Choudhury
% Arijit Ukil
% Soma Bandyopadhyay
% Rituraj Singh
% Arpan Pal
% Sundeep Khandelwal
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.s

L1 = 1:80;
L2 = 1:72;
L3 = 1:46;

PredictedAnnotation         = 3;                %% intial prediction
predicted_label2 = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Class prediction%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
    predicted_label1          = str2num(cell2mat(predict(tb_allS1, FeatureVctor(:, L1))));
    if(predicted_label1 == 1)
        PredictedAnnotation = 0;
    end
    
    if(predicted_label1 == 0)
        predicted_label2      = str2num(cell2mat(predict(tb_allS2, FeatureVctor(:, L2))));
    if(predicted_label2 == 1)
        PredictedAnnotation = 2;
    end
    end
    
    if(predicted_label2 == 0)
        predicted_label3      = str2num(cell2mat(predict(tb_allS3, FeatureVctor(:, L3))));
        if(predicted_label3 == 1)
            PredictedAnnotation = 1;
        end
    end

end

