import os
from csem.training import supertrain_transformer, get_input_params

if __name__ == "__main__":
    print("Starting main!!")
    if not os.name == 'posix':
        data_folder = "//nasne01.csem.local/Workgroups/WGP-BIOMED-DIV-E/" \
                      "2021Cinc/data"
        checkpoint_folder = "C:/Users/plg/Documents/ECG challenge/" \
                            "cinc2021/logs/transformer"
        config_folder = "C:/Users/plg/Documents/ECG challenge/cinc2021/config"
    else:
        data_folder = "/export/home/scratch/cinc2021/data"
        checkpoint_folder = "/local/user/plg/Documents/ecg_challenge/" \
                            "cinc2021/logs/transformer"
        config_folder = "/local/user/plg/Documents/ecg_challenge/" \
                        "cinc2021/config"

    config_name = "configuration.json"
    input_params = get_input_params(
        config_folder, config_name, checkpoint_folder
    )

    supertrain_transformer(data_folder=data_folder, **input_params)
