import os
from csem.pretrain_transformer import pretrain_transformer, get_input_params

if __name__ == "__main__":
    if not os.name == 'posix':
        data_folder = "//nasne01.csem.local/Workgroups/WGP-BIOMED-DIV-E" \
                      "/2021Cinc/data/pretrain"
        checkpoint_folder = "C:/Users/plg/Documents/ECG challenge" \
                            "/cinc2021/logs/transformer"
        config_folder = "C:/Users/plg/Documents/ECG challenge/cinc2021/config"
    else:
        data_folder = "/export/home/scratch/cinc2021/data/pretrain"
        checkpoint_folder = "/local/user/plg/Documents/ecg_challenge/" \
                            "cinc2021/logs/transformer"
        config_folder = "/local/user/plg/Documents/ecg_challenge/" \
                        "cinc2021/config"

    config_name = "pretrain.json"
    input_params = get_input_params(
        config_folder, config_name, checkpoint_folder
    )

    pretrain_transformer(data_folder=data_folder, **input_params)
