import pathlib
import os
from .data import load_data, split_zeropad_save, FOLDER_NAME

###############################################################################
#
# Definable constants
#
###############################################################################
fs = 500.0
datasets = [
    # "2000mitdb",
    # "2000ltafdb",
    # "2000nstdb",
    # "2000cudb",
    # "1977AHADB",
    "2009edb",
    # "StPetersburg",
    # "CPSC_1",
    # "CPSC_2",
    # "Chapman",
    # "Ningbo"
]


def separate_into_beats(data_directory):
    # Find header and recording files.
    print('Finding header and recording files...')
    dataset = load_data(data_directory, "..", fs)
    data_folder = pathlib.Path(data_directory).parent
    beats_folder = data_folder / FOLDER_NAME
    if not os.path.isdir(beats_folder):
        os.mkdir(beats_folder)
    split_zeropad_save(
        dataset.iterate_records(fold_index=True), beats_folder, fs=fs,
        datasets=datasets, return_beats=False
    )
