import json

def read_json(file):
    """Read a JSON file.

    Read a JSON file and return its content as a dictionary.

    Args:
        file: Path to a JSON file.

    Returns:
        The data in the JSON file.
    """
    with open(file, mode='r') as f:
        return json.load(f)


def write_json(file, data):
    """Write a JSON file.

    Write a dictionary to a JSON file.

    Args:
        file: Path where to write the JSON file.
        data: Data to store in the JSON file as a dictionary.
    """
    with open(file, mode='w') as f:
        json.dump(data, f, indent=2)
