import numpy as np

def windowing2(array, win_size, win_shift, samp_freq):
    j=0
    winsamp = win_size*samp_freq #how many samples in win_size window
    winsamp_shift = int(win_shift*samp_freq) #how much to shift by
    
    win = array[j:j+winsamp].T #takes window samples, then transposes to (1, n_samples)
    winsig = [win]
    count = 1
    if win_shift:  
        j+=winsamp_shift
        while (j+winsamp<array.shape[0]):
            win = array[j:j+winsamp].T
            count = count + 1
            winsig.append(win)
            j+= winsamp_shift
        winsig = np.stack(winsig)
        return winsig, count 
    else: # in the case that window is zero
        j+=winsamp
        while (j+winsamp<array.shape[0]):
            win = array[j:j+winsamp].T
            count = count + 1
            winsig = np.concatenate((winsig,win),axis=0)# concatenate the windows by the rows
            j+= winsamp
        return winsig, count  
