import tensorflow as tf
from tensorflow.keras.models import Sequential, Model
from tensorflow.keras.layers import Conv1D, MaxPooling1D, BatchNormalization, Dropout, Dense, Flatten, Input, Add, ReLU
from tensorflow.keras.optimizers import Adam
def create_model_Sequential(leads, signal_len):
    # creates the model

    n_timesteps, n_features, n_outputs = signal_len, len(leads), 30

    model = Sequential()
    model.add(BatchNormalization())
    model.add(Conv1D(filters=64, kernel_size=3, activation='relu', input_shape=(n_timesteps,n_features)))
    model.add(Conv1D(filters=64, kernel_size=3, activation='relu'))
    model.add(Dropout(0.3))
    model.add(MaxPooling1D(pool_size=2))
    
    model.add(BatchNormalization())
    model.add(Conv1D(filters=128, kernel_size=3, activation='relu'))
    model.add(Conv1D(filters=128, kernel_size=3, activation='relu'))
    model.add(Dropout(0.3))
    model.add(MaxPooling1D(pool_size=2))
    
    model.add(BatchNormalization())
    model.add(Conv1D(filters=256, kernel_size=3, activation='relu'))
    model.add(Conv1D(filters=256, kernel_size=3, activation='relu'))
    model.add(Dropout(0.3))
    model.add(MaxPooling1D(pool_size=2))

    model.add(Flatten())
    model.add(Dense(100, activation='relu'))
    model.add(Dense(n_outputs, activation='sigmoid'))
    model.compile(loss='binary_crossentropy', optimizer='adam', metrics=['accuracy'])
    return model


def create_model_wide_deep(signals, leads):
    n_timesteps, n_leads, n_outputs = signals.shape[1], len(leads), 30
    n_features = 10 # number of fetures extracted and reduced
    
    signal_input = Input(shape=(n_timesteps, n_leads), name = 'signal_input')

    # DEEP (1DCNN) Network
    CNN_1 = Conv1D(filters=64, kernel_size=7, activation='relu')(signal_input)
    CNN_2 = Conv1D(filters=64, kernel_size=7, activation='relu')(CNN_1)
    drop_1 = Dropout(0.3)(CNN_2)
    pool_1 = MaxPooling1D(pool_size=2)(drop_1)
    bn = BatchNormalization()(pool_1)
    CNN_3 = Conv1D(filters=128, kernel_size=7, activation='relu')(bn)
    CNN_4 = Conv1D(filters=128, kernel_size=7, activation='relu')(CNN_3)
    drop_2 = Dropout(0.3)(CNN_4)
    pool_2 = MaxPooling1D(pool_size=2)(drop_2)
    bn = BatchNormalization()(pool_2)
    CNN_5 = Conv1D(filters=256, kernel_size=7, activation='relu')(bn)
    CNN_6 = Conv1D(filters=256, kernel_size=7, activation='relu')(CNN_5)
    drop_3 = Dropout(0.3)(CNN_6)
    pool_3 = MaxPooling1D(pool_size=2)(drop_3)
    bn = BatchNormalization()(pool_3)
    CNN_5 = Conv1D(filters=256, kernel_size=7, activation='relu')(bn)
    CNN_6 = Conv1D(filters=256, kernel_size=7, activation='relu')(CNN_5)
    drop_3 = Dropout(0.3)(CNN_6)
    pool_3 = MaxPooling1D(pool_size=2)(drop_3)
    bn = BatchNormalization()(pool_3)
    flat = Flatten()(bn)
    dense1 = Dense(500, activation = 'relu')(flat)
    deep_output = Dense(100, activation = 'relu')(dense1)

    deep_model = Model(inputs = signal_input, outputs = deep_output)
    
    # SHALLOW (MLP) Network
    shallow_input = Input(n_features, name = 'feature_input')
    shallow_output = Dense(4, activation = 'relu', kernel_regularizer=tf.keras.regularizers.l2(l=0.1))(shallow_input)
    shallow_model = Model(inputs = shallow_input, outputs = shallow_input)

    # Combine the shallow and deep network outputs
    concat_layer = tf.keras.layers.concatenate([deep_model.outputs[0], shallow_model.outputs[0]])
    dense2 = Dense(40, activation = 'relu')(concat_layer)
    output = Dense(n_outputs, activation = 'sigmoid')(dense2)
    
    # Create and compile the model
    model = Model(inputs = [signal_input, shallow_input], outputs=output)
    opt = Adam(learning_rate = 0.0001)
    model.compile(loss = 'binary_crossentropy', optimizer = opt, metrics = ['accuracy'])
    return model    
