# -*- coding: utf-8 -*-
"""
Created on Wed Mar 17 16:59:08 2021

@author: Maurice
"""


from helper_code import *
import numpy as np, os, sys, joblib
from multiprocessing import Pool,freeze_support
import multiprocessing

from ecg_recording import ECGRecording,create_ecg_recording



#TODO automate ecg processing, use multiprocessing for parallel feature extraction

def process_records(data_dir, extract_labels=True,  multiproc = True, feature_types=["statistical"]):
    
    header_files,recording_files = find_challenge_files(data_dir)
    compute_statis_features = "statistical" in feature_types
    records = []
    if multiproc :
        freeze_support()
        with Pool(processes=4) as pool:
        
            async_results = [pool.apply_async(create_ecg_recording,(header_files[idx], recording_files[idx],extract_labels,
                                                            compute_statis_features)) for idx in range(len(header_files))]
            #records = [res.get(timeout=60) for res in async_results]
            records = list()
            for res in async_results:
                try:
                    records.append(res.get(timeout=120))
                except multiprocessing.TimeoutError:
                    continue
            
            #records = pool.starmap(create_ecg_recording,[(header_files[idx], recording_files[idx],True,
            #                                                True) for idx in range(len(header_files))])
            
           #records = [pool.apply(create_ecg_recording,(header_files[idx], recording_files[idx],True,
           #                                                 True)) for idx in range(len(header_files))]
            
            
    else :
        records = list()
        for idx in range(len(header_files)):
            records.append(create_ecg_recording(header_files[idx], recording_files[idx],extract_labels,compute_statis_features))
            
    return records
            
            
def store_records(records,location):
    #TODO
    return None