#!/usr/bin/env python

import os
import cinc_aux as aux
import random
import numpy as np
from shutil import copyfile
from keras.optimizers import Adam

def restore_header_list(input_directory):    
    header_files = []
    for f in os.listdir(input_directory):
        g = os.path.join(input_directory, f)
        if not f.lower().startswith('.') and f.lower().endswith('hea') and os.path.isfile(g):
            header_files.append(g)
    return header_files

def train_12ECG_classifier(input_directory, output_directory):
    deployed = True
   
    header_files = restore_header_list(input_directory)
            
    x, features, y, classes = aux.prepare_data([header_files[0]])
    
    features = features.reshape(features.shape[0],-1)
    
    print("Building model...")
    if deployed == True:
        model = aux.dnn_cpu(x.shape[1])
    else:
        model = aux.dnn(x.shape[1])
    
    opt = Adam(0.0001, 0.9)
    model.compile(loss='binary_crossentropy', metrics = ['acc'], optimizer = opt)
    
    n_rounds = 5
    
    for k in range(n_rounds):    
        header_files = restore_header_list(input_directory)
            
        mini_batch_size = 1000
        n_batches = len(header_files) // mini_batch_size
        
        for i in range(n_batches+1):
            print(i)
            train_files = []
            if i == n_batches:
                train_files = header_files
            else:
                for j in range(mini_batch_size):
                    sample_ix = np.random.randint(0, len(header_files))    
                    train_files.append(header_files.pop(sample_ix))      
            x, features, y, classes = aux.prepare_data(train_files)
            features = features.reshape(features.shape[0],-1)
            model.fit(x, y, batch_size = 32, epochs = 20)
        
    if deployed == True:
        save_name = 'generic_model_cpu.h5'
    else:
        save_name = 'generic_model.h5'
        
    model.save(output_directory + '/' + save_name)
        


                                                
    

