#!/usr/bin/env python

import cinc_aux as aux
import numpy as np, os
import keras as ks

def run_12ECG_classifier(data, header_data, loaded_model):


    sequence_length = loaded_model.input[0].shape[0].value
    res = int(header_data[1].split(" ")[2].split("/")[0])
    fs = int(header_data[0].split(" ")[2])
    downscale_fs = 1
    
    x = aux.preprocess_ECG(data, sequence_length, fs, res, downscale_fs)


    current_score = loaded_model.predict(x)[0]
    current_label = aux.scores_to_label(current_score)
    
    classes_meta = np.loadtxt('dx_mapping_scored.csv', delimiter = ',', dtype = object)
    classes = list(classes_meta[1:, 1]) 
    
    return current_label, current_score, classes

def load_12ECG_model(input_directory):
    # load the model from disk 
    models = os.listdir(input_directory)
    for model in models:
        if model.endswith('_cpu.h5'):
            with ks.utils.CustomObjectScope({'AttentionWithContext': aux.AttentionWithContext}):
                loaded_model = ks.models.load_model(input_directory + '/' + model)
            
    return loaded_model
