import numpy as np, os, sys
from scipy.io import loadmat

def load_one_datapoint(filename):

    x = loadmat(filename)
    data = np.asarray(x['val'], dtype=np.float64)

    new_file = filename.replace('.mat','.hea')
    input_header_file = os.path.join(new_file)

    with open(input_header_file,'r') as f:
        header_data=f.readlines()

    return data, header_data

def get_all_raw_data(input_directory):
    """Extracts all data from a directory.
    
    Args:
        input_directory: input directory containing .hea and .mat files.
    Returns:
        data_array: a python list containing 12 1-dimensional arrays of the
            heart rate signals
        header_array: a python list containing header data information. 
    """

    # Find files.
    input_files = []
    for f in os.listdir(input_directory):
        if os.path.isfile(os.path.join(input_directory, f)) and not f.lower().startswith('.') and f.lower().endswith('mat'):
            input_files.append(f)

    # classes = get_classes(input_directory, input_files)

    # Iterate over files.
    print('Extracting 12ECG features...')
    num_files = len(input_files)
    
    data_array = []
    header_array = []
    for i, f in enumerate(input_files):
        #print('    {}/{}...'.format(i+1, num_files))
        tmp_input_file = os.path.join(input_directory, f)
        data, header_data = load_one_datapoint(tmp_input_file)
        data_array.append(data)
        header_array.append(header_data)
    
    return data_array, header_array