#!/usr/bin/env python

import numpy as np, os, sys
import scipy.signal
from get_12ECG_features import Inception_model

def run_12ECG_classifier(data,header_data,loaded_model):
    # Use your classifier here to obtain a label and score for each class.
    fs = int(header_data[0].split(' ')[2])

    if fs != 500:

        secs = len(data[0, :]) / fs  # Number of seconds in signal X
        samps = int(secs * 500)  # Number of samples to downsample
        ecg = np.zeros((samps, 12), dtype=np.float32)

        for lead in range(12):
            resample_signal = scipy.signal.resample(data[lead, :], samps)
            ecg[:, lead] = resample_signal

        if ecg.shape[0] > 30000:
            ecg = ecg[0:30000, :]

        else:
            tmp = np.zeros((30000, 12), dtype=np.float32)
            tmp[-ecg.shape[0]:, :] = ecg
            ecg = tmp

    else:
        ecg = data.T

        if ecg.shape[0] > 30000:
            ecg = ecg[0:30000, :]

        else:
            tmp = np.zeros((30000, 12), dtype=np.float32)
            tmp[-ecg.shape[0]:, :] = ecg
            ecg = tmp

    # z-score
    for j in range(12):
        if np.std(ecg[:, j]) == 0:
            continue
        else:
            ecg[:, j] = ((ecg[:, j] - np.mean(ecg[:, j])) / np.std(ecg[:, j]))

    ecg = ecg[np.newaxis, :]
    test_probability = loaded_model.predict(ecg)[0]
    input_directory = sys.argv[1]
    threshold_file = os.path.join(input_directory, 'best_threshold.npy')
    best_threshold = np.load(threshold_file)
    test_label = test_probability.copy()
    test_label[test_label >= best_threshold] = 1
    test_label[test_label < best_threshold] = 0
    if sum(test_label) == 0:
        test_label[np.argmax(test_probability)] = 1

    classes = ['164889003', '164890007', '426627000', '713427006', '270492004', '713426002', '39732003', '445118002',
                '164909002', '164947007', '251146004', '111975006', '698252002', '284470004', '10370003', '427172004',
                '164917005', '47665007', '427393009', '426177001', '426783006', '427084000', '164934002', '59931005']

    return test_label.astype(int), test_probability, classes

def load_12ECG_model(input_directory):
    # load the model from disk 
    f_out = 'Final_model'
    model_name = os.path.join(input_directory, f_out)
    loaded_model = Inception_model(6)
    loaded_model.load_weights(model_name)

    return loaded_model
