% The following function computes the Incomplete Cholesky decomposition of
% the Gram matrix generated by the random VECTOR samples when the kernel is
% normalized.
%
% Input:   "samples" should be COLUMN vectors of length (nxm)
%				'kernelSize' is a scalar for the kernel size.
%               "precision" is a scalar for the precision
%
% Output: 'choleskyMarix' contains nxd Cholesky matrix
%
% Default:  precision = 10^-6.
%
% The code uses incompleteCholeskyMulti.
%
% Author: Sohan Seth (sohan@cnel.ufl.edu)	Date: 01.06.2009

function choleskyMatrix  = incompleteCholeskySigma(samples,kernelSize,precision)

if nargin == 2
    precision = 10^-6;
end

c = 1/(sqrt(2*pi)*kernelSize)^(size(samples,2));
choleskyMatrix  = incompleteCholeskyMulti(samples,kernelSize,precision);
choleskyMatrix = choleskyMatrix * sqrt(c);