#!/usr/bin/env python

import numpy as np, os, sys
import joblib
from get_12ECG_features import get_12ECG_features
import keras
from ResSeNet import SeqWeightedAttention
from data_util import *


def run_12ECG_classifier(data,header_data,loaded_model):
    classes = ['10370003', '111288001', '11157007', '111975006', '13640000', '164861001', '164865005', '164867002',
               '164873001', '164884008', '164889003', '164890007', '164895002', '164896001', '164909002', '164917005',
               '164921003', '164930006', '164931005', '164934002', '164937009', '164947007', '164951009', '17338001',
               '195042002', '195060002', '195080001', '195101003', '195126007', '204384007', '233917008', '251120003',
               '251139008', '251146004', '251164006', '251168009', '251170000', '251173003', '251180001', '251182009',
               '251200008', '251259000', '251266004', '251268003', '253339007', '253352002', '266249003', '266257000',
               '270492004', '27885002', '282825002', '284470004', '29320008', '314208002', '368009', '370365005',
               '39732003', '413444003', '413844008', '425419005', '425623009', '425856008', '426177001', '426434006',
               '426627000', '426648003', '426664006', '426749004', '426761007', '426783006', '426995002', '427084000',
               '427172004', '427393009', '428417006', '428750005', '429622005', '445118002', '445211001', '446358003',
               '446813000', '47665007', '49260003', '49578007', '53741008', '54016002', '54329005', '55930002',
               '57054005',
               '59118001', '59931005', '60423000', '63593006', '6374002', '65778007', '67198005', '67741000119109',
               '698247007',
               '698252002', '704997005', '713422000', '713426002', '713427006', '74390002', '74615001', '75532003',
               '77867006',
               '81898007', '82226007', '84114007', '89792004']

    num_classes = 111
    current_label = np.zeros(num_classes, dtype=int)
    current_score = np.zeros(num_classes)
    model = loaded_model

    # Use your classifier here to obtain a label and score for each class.
    if data.shape[0] > 30000:
        data = data[:30000, :]
    scale_data = meanstd_scale(data)
    process = Preprocess_data(scale_data)
    process_data = process.process_ecg([scale_data.T])
    print(process_data.shape)
    score = model.predict(process_data)[0]

    label = np.argwhere(score > 0.06).squeeze()
    if np.size(label) == 0:
        label = np.argmax(score)
    current_label[label] = 1

    for i in range(num_classes):
        current_score[i] = np.array(score[i])

    # Use your classifier here to obtain a label and score for each class.
    # model = loaded_model['model']
    # imputer = loaded_model['imputer']
    # classes = loaded_model['classes']
    #
    # features=np.asarray(get_12ECG_features(data,header_data))
    # feats_reshape = features.reshape(1, -1)
    # feats_reshape = imputer.transform(feats_reshape)
    # current_label = model.predict(feats_reshape)[0]
    # current_label=current_label.astype(int)
    # current_score = model.predict_proba(feats_reshape)
    # current_score=np.asarray(current_score)
    # current_score=current_score[:,0,1]

    return current_label, current_score,classes

def load_12ECG_model(input_directory):
    # load the model from disk 
    #f_out='finalized_model.sav'
    f_out = 'model.hdf5'
    filename = os.path.join(input_directory,f_out)

    #loaded_model = joblib.load(filename)
    loaded_model = keras.models.load_model(filename, custom_objects={'SeqWeightedAttention': SeqWeightedAttention})

    return loaded_model
