% run_12ECG_classifier.m for initial submission 

function [score, label, classes] = run_12ECG_classifier(data,header_data,modelclasses)

model = modelclasses.model; 
% classes = modelclasses.classes; 
% list the SNOMED classes in the right order 
classes = ["270492004","164889003","164890007","426627000","713427006",...
    "713426002","445118002","39732003","164909002","251146004","698252002",...
    "10370003","284470004","427172004","164947007","111975006","164917005",...
    "47665007","59118001","427393009","426177001","426783006","427084000",...
    "63593006","164934002","59931005","17338001"];

% make sure it is oriented the right way for processing
if(size(data,1)>12)
    data = data';
end

% Use classifiers to obtain a label and score for each class.
features = get_12ECG_features(data,header_data);
label = []; score = []; 
for i = 1:length(model) % because I trained one model for every valid class 
[labels{i},scores{i}] = predict(model{i},features); 
label = [label labels{i}(1)]; 
score = [score scores{i}(2)]; 
end
% [labels_1,scores_1,~] = predict(model.B1, features);
% [labels_2,scores_2,~] = predict(model.B2, features);
% [labels_3,scores_3,~] = predict(model.B3, features);
% [labels_4,scores_4,~] = predict(model.B4, features);
% [labels_5,scores_5,~] = predict(model.B5, features);
% [labels_6,scores_6,~] = predict(model.B6, features);
% [labels_7,scores_7,~] = predict(model.B7, features);
% [labels_8,scores_8,~] = predict(model.B8, features);
% [labels_9,scores_9,~] = predict(model.B9, features);
% [labels_10,scores_10,~] = predict(model.B10, features);
% [labels_11,scores_11,~] = predict(model.B11, features);
% [labels_12,scores_12,~] = predict(model.B12, features);
% [labels_13,scores_13,~] = predict(model.B13, features);
% [labels_14,scores_14,~] = predict(model.B14, features);
% [labels_15,scores_15,~] = predict(model.B15, features);
% [labels_16,scores_16,~] = predict(model.B16, features);
% [labels_17,scores_17,~] = predict(model.B17, features);
% [labels_18,scores_18,~] = predict(model.B18, features);
% [labels_19,scores_19,~] = predict(model.B19, features);
% [labels_20,scores_20,~] = predict(model.B20, features);
% [labels_21,scores_21,~] = predict(model.B21, features);
% [labels_22,scores_22,~] = predict(model.B22, features);
% [labels_23,scores_23,~] = predict(model.B23, features);
% [labels_24,scores_24,~] = predict(model.B24, features);
% [labels_25,scores_25,~] = predict(model.B25, features);
% [labels_26,scores_26,~] = predict(model.B26, features);
% [labels_27,scores_27,~] = predict(model.B27, features);


% IAVB_label = labels_1(1);
% AF_label = labels_2(1);
% AFL_label = labels_3(1);
% Brady_label = labels_4(1);
% CRBBB_label = labels_5(1);
% IRBBB_label = labels_6(1);
% LAnFB_label = labels_7(1);
% LAD_label = labels_8(1);
% LBBB_label = labels_9(1);
% LQRSV_label = labels_10(1);
% NSIVCB_label = labels_11(1);
% PR_label = labels_12(1);
% PAC_label = labels_13(1);
% PVC_label = labels_14(1);
% LPR_label = labels_15(1);
% LQT_label = labels_16(1);
% QAb_label = labels_17(1);
% RAD_label = labels_18(1);
% RBBB_label = labels_19(1);
% SA_label = labels_20(1);
% SB_label = labels_21(1);
% SNR_label = labels_22(1);
% STach_label = labels_23(1);
% SVPB_label = labels_24(1);
% TAb_label = labels_25(1);
% TInv_label = labels_26(1);
% VPB_label = labels_27(1);
% 
% IAVB_score = scores_1(2);
% AF_score = scores_2(2);
% AFL_score = scores_3(2);
% Brady_score = scores_4(2);
% CRBBB_score = scores_5(2);
% IRBBB_score = scores_6(2);
% LAnFB_score = scores_7(2);
% LAD_score = scores_8(2);
% LBBB_score = scores_9(2);
% LQRSV_score = scores_10(2);
% NSIVCB_score = scores_11(2);
% PR_score = scores_12(2);
% PAC_score = scores_13(2);
% PVC_score = scores_14(2);
% LPR_score = scores_15(2);
% LQT_score = scores_16(2);
% QAb_score = scores_17(2);
% RAD_score = scores_18(2);
% RBBB_score = scores_19(2);
% SA_score = scores_20(2);
% SB_score = scores_21(2);
% SNR_score = scores_22(2);
% STach_score = scores_23(2);
% SVPB_score = scores_24(2);
% TAb_score = scores_25(2);
% TInv_score = scores_26(2);
% VPB_score = scores_27(2);

% label = [IAVB_label AF_label AFL_label Brady_label CRBBB_label IRBBB_label...
%     LAnFB_label LAD_label LBBB_label LQRSV_label NSIVCB_label PR_label PAC_label...
%     PVC_label LPR_label LQT_label QAb_label RAD_label RBBB_label SA_label...
%     SB_label SNR_label STach_label SVPB_label TAb_label TInv_label VPB_label]
% 
% score = [IAVB_score AF_score AFL_score Brady_score CRBBB_score IRBBB_score...
%     LAnFB_score LAD_score LBBB_score LQRSV_score NSIVCB_score PR_score PAC_score...
%     PVC_score LPR_score LQT_score QAb_score RAD_score RBBB_score SA_score SB_score...
%     SNR_score STach_score SVPB_score TAb_score TInv_score VPB_score]


end