function FFT_features = process_fft(leads,Fs)

npeaks = 20; 
fpp = 3; % number of features per peak [height, location, width] 
FFT_features = zeros(1,12*(npeaks*fpp)); % 76 if you get the other stuff working 
% include mean, med, std, sem, max, min, quantiles, iqr, skewness, kurtosis
% and skew/kurt adjusted for bias for spectral skewness, spectral kurtosis,
% and spectral rolloff point. [63 features] 

% also include power spectral density, max frequency, med frequency,
% quantiles of frequency [13 features] [fund freq not working...] 

for i = 1:12

x = leads(i,:); 
y = fft(x); 
n = length(x); % number of samples
f = (0:n-1)*(Fs/n); % frequency range
power = abs(y).^2/n; % power of the DFT
find_fiddy = floor(Fs/50); 
fiddyHz = round(n/find_fiddy); % 50 Hz location
[PKS,LOCS,W] = findpeaks(power(1:fiddyHz),'WidthReference','halfprom'); % play around with width reference parameters 

% find top 20 peaks for now [60 features]
[peaks,ind] = maxk(PKS,npeaks); 
Hz = f(LOCS(ind));% make sure to translate LOCS to Hz, not sample number 
girth = W(ind)/n; % scale W by number of samples 

% FFT_features(1,(i-1)*npeaks*fpp+1:i*npeaks*fpp) = [peaks Hz girth zeros(1,fpp*(npeaks-length(peaks)))]; % if there are less than 20 peaks this should leave zeros
% switching from peaks to power for better repeatability [won't change due
% to extra noise or length of recording] 
peakpower = power(LOCS(ind)); 
% also switching order of features to make columns consistent 
% ordering columns: [peak1power p1Hz p1girth p2power p2Hz p2girth p3...] 

% psd = periodogram(x); % power spectral density
% maxf = max(f); 
% medf = median(f); 
% qf = quantile(f,10); 
% f0 = pitch(x,Fs,'WindowLength',round(Fs/10)); % estimate of fundamental frequency with 10 msec windowlength  

% skew = spectralSkewness(x',Fs); % spectral kurtosis over time 
% meanskew = mean(skew); 
% medskew = median(skew); 
% maxskew = max(skew); 
% minskew = min(skew); 
% stdskew = std(skew); 
% semskew = stdskew/sqrt(length(skew)); 
% qskew = quantile(skew,10); 
% iqrskew = iqr(skew); 
% skewskew = skewness(skew); 
% skewbskew = skewness(skew,0); 
% kurtskew = kurtosis(skew); 
% kurtbskew = kurtosis(skew,0); 

% kurt = spectralKurtosis(x,Fs); 
% meankurt = mean(kurt); 
% medkurt = median(kurt); 
% maxkurt = max(kurt); 
% minkurt = min(kurt); 
% stdkurt = std(kurt); 
% semkurt = stdkurt/sqrt(length(kurt)); 
% qkurt = quantile(kurt,10); 
% iqrkurt = iqr(kurt); 
% skewkurt = skewness(kurt); 
% skewbkurt = skewness(kurt,0); 
% kurtkurt = kurtosis(kurt); 
% kurtbkurt = kurtosis(kurt,0);

% roll = spectralRolloffPoint(x,Fs); 
% meanroll = mean(roll); 
% medroll = median(roll); 
% maxroll = max(roll); 
% minroll = min(roll); 
% stdroll = std(roll); 
% semroll = stdroll/sqrt(length(roll)); 
% qroll = quantile(roll,10); 
% iqrroll = iqr(roll); 
% skewroll = skewness(roll); 
% skewbroll = skewness(roll,0); 
% kurtroll = kurtosis(roll); 
% kurtbroll = kurtosis(roll,0);

% feat1feat2feat3 = [psd maxf medf qf f0 meanskew medskew maxskew minskew stdskew semskew qskew...
%     iqrskew skewskew skewbskew kurtskew kurtbskew meankurt medkurt maxkurt minkurt stdkurt semkurt...
%     qkurt iqrkurt skewkurt skewbkurt kurtkurt kurtbkurt meanroll medroll maxroll minroll stdroll...
%     semroll qroll iqrroll skewroll skewbroll kurtroll kurtbroll]; 

feat1feat2feat3 = []; 
if(length(peaks)>0)
    for j = 1:min(length(peaks),npeaks)
        feat1feat2feat3 = [feat1feat2feat3 peakpower(j) Hz(j) girth(j)]; 
    end
end

% zero pad if there weren't enough peaks 
FFT_features(1,(i-1)*npeaks*fpp+1:i*npeaks*fpp) = [feat1feat2feat3 zeros(1,fpp*(npeaks-length(peaks)))]; 
end

% IDEAS FOR MORE FFT FEATURES
    % split FFT into specific frequency bins, sum power in each bin (in
    % place of or alongside finding prominent peaks) 



% if(plotsOn)
%     figure(); 
%     plot(f,power)
%     xlabel('Frequency')
%     ylabel('Power')
%     title(TITLE)
% end
end


function plot_fft(signal,Fs,TITLE)

x = signal; 
y = fft(x); 
n = length(x); % number of samples
f = (0:n-1)*(Fs/n); % frequency range
power = abs(y).^2/n; % power of the DFT

figure(); 
plot(f,power)
xlabel('Frequency')
ylabel('Power')
title(TITLE)
end