% get_12ECG_features.m for initial submission

function features = get_12ECG_features(data, header_data)

[~,~,~,Fs,~,age,sex]=extract_header_data_2(header_data);

Filter = createBPF(5,40, Fs,'fpass1',10,'fpass2', 25, 'kaiser', 'order', 20); 
filtered_leads = data; % placeholder of same size 

for i = 1:12
filtered_leads(i,:) = filtfilt(Filter.Numerator, 1, data(i,:));
end

lead_features = process_leads(filtered_leads,Fs); 

features = [age,sex,lead_features];

end

function lead_features = process_leads(leads,Fs)

pqrst_features = find_pqrst(leads,Fs);

FFT_features = process_fft(leads,Fs);

lead_features = [pqrst_features FFT_features]; 

end

