function pqrst_features = find_pqrst(leads,Fs)

movnum = round(Fs*0.08); % same amount of time regardless of Fs 
tfs = round(Fs*0.02); % same 

pplot = 0; 
% use Pan-Tompkins algorithm to find R peaks. R peaks should be most
% pronounced in V1, which is the 7th lead 
%   record mean, median, max, min, std, sem, skewness, kurtosis, skew/kurt adj for bias, 4 quantiles, IQR of: [15 stats per feature] 
num_R_feats_per_lead = 30;%  R peak amplitude, RR intervals, 
num_S_feats_per_lead = 45; %  S peak amplitude, SS intervals, S_pS amplitude ratio
num_RS_feats_per_lead = 30; %   R/S amplitude ratio, S-R width  
num_QRS_feats_per_lead = 15; %  QRS width 
num_P_feats_per_lead = 60; %  P amplitude, PR length, elevation (reg and -baseline)
num_T_feats_per_lead = 60; %  T amplitude, ST length, elevation (reg and -baseline)
Rfeats = zeros(1,12*num_R_feats_per_lead); 
Sfeats = zeros(1,12*num_S_feats_per_lead); 
RSfeats = zeros(1,12*num_RS_feats_per_lead); 
QRSfeats = zeros(1,12*num_QRS_feats_per_lead); 
Pfeats = zeros(1,12*num_P_feats_per_lead);
Tfeats = zeros(1,12*num_T_feats_per_lead);

for i = 1:12   % this still isn't perfect at finding every R peak, but it's pretty good. 
    if(sum(leads(i,:)==zeros(size(leads(i,:))))==size(leads(i,:),2)) % flat line
        Rpeaks{i} = randi([10 1000],1,5); % random garbage that hopefully won't break stuff 
    else
        Rpeaks{i} = find_R_peaks(leads(i,:),Fs,pplot); 
    end
%     figure(); plot(leads(i,:)); hold on; plot(Rpeaks{i},leads(i,Rpeaks{i}),'or'); plot(qrs_i_raw,leads(i,qrs_i_raw),'ob'); title(i)
%     Rpeakamps{i} = leads(i,Rpeaks{i}); 
%     % get features from R peaks 
%     numpeaks = length(Rpeaks{i}); % number of heartbeats found 
%     meanRR = mean(diff(Rpeaks{i})); % mean of RR intervals
%     semRR = std(diff(Rpeaks{i}))/sqrt(numpeaks); % standard error of RR intervals
%     meanRamp = mean(leads(i,Rpeaks{i})); % mean of R amplitudes
%     semRamp = std(leads(i,Rpeaks{i}))/sqrt(numpeaks); % standard error of R amplitudes 

end

% run function that takes estimates from all Rpeaks and uses a majority
% vote to find the true R peak 
adj_Rpeaks = voteR(leads, Rpeaks); 
[Speaks,upd_Rpeaks,Qpeaks,postS] = findS(leads, adj_Rpeaks); 



for i = 1:12
    
%     figure(); plot(leads(i,:)); hold on; plot(upd_Rpeaks(i,:),leads(i,upd_Rpeaks(i,:)),'<r'); plot(Speaks(i,:),leads(i,Speaks(i,:)),'>b'); plot(Qpeaks(i,:),leads(i,Qpeaks(i,:)),'om'); plot(postS(i,:),leads(i,postS(i,:)),'oc'); 
    
    % I need to find a quick test to see if it's a flat line. if it is, I can
    % skip that lead and fill the features with 0's or something else all at
    % once to save time. 
    numpeaks = length(upd_Rpeaks(i,:)); % number of heartbeats found 
    if(Speaks(i,:) == ones(1,numpeaks)); % THIS LEAD IS FLAT. skip all processing 
        
        % these should be "way out there" to be separate from normal values
        ABnan = 100; % timing intervals [way too long] 
        semnan = 1000; % for std, sem [way too high] 
        skewnan = 1000; % for skewness, kurtosis [way too high] 
        ampnan = 10000; % for amplitude [way too high] 
        ratnan = 1000; % for ratios [way too high] 
        Qnan = 1000*ones(1,4); % MAKE SURE THIS MATCHES THE NUMBER OF QUANTILES
        IQRnan = 0; 
        
        meanRR = ABnan;         medRR = ABnan;      maxRR = ABnan;      minRR = ABnan;      stdRR = semnan;         semRR = semnan;         skewRR = skewnan;       kurtRR = skewnan;       skewbRR = skewnan;       kurtbRR = skewnan;     qRR = Qnan; iqrRR = IQRnan; 
        meanRamp = ampnan;      medRamp = ampnan;   maxRamp = ampnan;   minRamp = ampnan;   stdRamp = semnan;       semRamp = semnan;       skewRamp = skewnan;     kurtRamp = skewnan;     skewbRamp = skewnan;     kurtbRamp = skewnan;   qRamp = Qnan; iqrRamp = IQRnan;
        meanSS = ABnan;         medSS = ABnan;      maxSS = ABnan;      minSS = ABnan;      stdSS = semnan;         semSS = semnan;         skewSS = skewnan;       kurtSS = skewnan;       skewbSS = skewnan;       kurtbSS = skewnan;     qSS = Qnan; iqrSS = IQRnan;
        meanSamp = ampnan;      medSamp = ampnan;   maxSamp = ampnan;   minSamp = ampnan;   stdSamp = semnan;       semSamp = semnan;       skewSamp = skewnan;     kurtSamp = skewnan;     skewbSamp = skewnan;     kurtbSamp = skewnan;   qSamp = Qnan; iqrSamp = IQRnan;
        meanSpSrat = ratnan;    medSpSrat = ratnan; maxSpSrat = ratnan; minSpSrat = ratnan; stdSpSrat = semnan;     semSpSrat = semnan;     skewSpSrat = skewnan;   kurtSpSrat = skewnan;   skewbSpSrat = skewnan;   kurtbSpSrat = skewnan; qSpSrat = Qnan; iqrSpSrat = IQRnan;
        meanRSrat = ratnan;     medRSrat = ratnan;  maxRSrat = ratnan;  minRSrat = ratnan;  stdRSrat = semnan;      semRSrat = semnan;      skewRSrat = skewnan;    kurtRSrat = skewnan;    skewbRSrat = skewnan;    kurtbRSrat = skewnan;  qRSrat = Qnan; iqrRSrat = IQRnan;
        meanRSwidth = ABnan;    medRSwidth = ABnan; maxRSwidth = ABnan; minRSwidth = ABnan; stdRSwidth = semnan;    semRSwidth = semnan;    skewRSwidth = skewnan;  kurtRSwidth = skewnan;  skewbRSwidth = skewnan;  kurtbRSwidth = skewnan;qRSwidth = Qnan; iqrRSwidth = IQRnan;
        meanQRS = ABnan;        medQRS = ABnan;     maxQRS = ABnan;     minQRS = ABnan;     stdQRS = semnan;        semQRS = semnan;        skewQRS = skewnan;      kurtQRS = skewnan;      skewbQRS = skewnan;      kurtbQRS = skewnan;    qQRS = Qnan; iqrQRS = IQRnan;
        meanPamp = ampnan;      medPamp = ampnan;   maxPamp = ampnan;   minPamp = ampnan;   stdPamp = semnan;       semPamp = semnan;       skewPamp = skewnan;     kurtPamp = skewnan;     skewbPamp = skewnan;     kurtbPamp = skewnan;   qPamp = Qnan; iqrPamp = IQRnan;
        meanPRlen = ABnan;      medPRlen = ABnan;   maxPRlen = ABnan;   minPRlen = ABnan;   stdPRlen = semnan;      semPRlen = semnan;      skewPRlen = skewnan;    kurtPRlen = skewnan;    skewbPRlen = skewnan;    kurtbPRlen = skewnan;  qPRlen = Qnan; iqrPRlen = IQRnan;
        meanPRamp = ampnan;     medPRamp = ampnan;  maxPRamp = ampnan;  minPRamp = ampnan;  stdPRamp = semnan;      semPRamp = semnan;      skewPRamp = skewnan;    kurtPRamp = skewnan;    skewbPRamp = skewnan;    kurtbPRamp = skewnan;  qPRamp = Qnan; iqrPRamp = IQRnan;
        meanPRampB = ampnan;    medPRampB = ampnan; maxPRampB = ampnan; minPRampB = ampnan; stdPRampB = semnan;     semPRampB = semnan;     skewPRampB = skewnan;   kurtPRampB = skewnan;   skewbPRampB = skewnan;   kurtbPRampB = skewnan; qPRampB = Qnan; iqrPRampB = IQRnan;
        meanTamp = ampnan;      medTamp = ampnan;   maxTamp = ampnan;   minTamp = ampnan;   stdTamp = semnan;       semTamp = semnan;       skewTamp = skewnan;     kurtTamp = skewnan;     skewbTamp = skewnan;     kurtbTamp = skewnan;   qTamp = Qnan; iqrTamp = IQRnan;
        meanSTlen = ABnan;      medSTlen = ABnan;   maxSTlen = ABnan;   minSTlen = ABnan;   stdSTlen = semnan;      semSTlen = semnan;      skewSTlen = skewnan;    kurtSTlen = skewnan;    skewbSTlen = skewnan;    kurtbSTlen = skewnan;  qSTlen = Qnan; iqrSTlen = IQRnan;
        meanSTamp = ampnan;     medSTamp = ampnan;  maxSTamp = ampnan;  minSTamp = ampnan;  stdSTamp = semnan;      semSTamp = semnan;      skewSTamp = skewnan;    kurtSTamp = skewnan;    skewbSTamp = skewnan;    kurtbSTamp = skewnan;  qSTamp = Qnan; iqrSTamp = IQRnan;
        meanSTampB = ampnan;    medSTampB = ampnan; maxSTampB = ampnan; minSTampB = ampnan; stdSTampB = semnan;     semSTampB = semnan;     skewSTampB = skewnan;   kurtSTampB = skewnan;   skewbSTampB = skewnan;   kurtbSTampB = skewnan; qSTampB = Qnan; iqrSTampB = IQRnan;
    else % calculate all the features 
%     figure(); plot(leads(i,:)); hold on; plot(upd_Rpeaks(i,:),leads(i,upd_Rpeaks(i,:)),'or'); plot(Speaks(i,:),leads(i,Speaks(i,:)),'ob'); plot(Qpeaks(i,:),leads(i,Qpeaks(i,:)),'oc'); plot(postS(i,:),leads(i,postS(i,:)),'om'); title(i)
%     % get features from R peaks 
%     numpeaks = length(adj_Rpeaks(i,:)); % number of heartbeats found 
%     meanRR = mean(diff(adj_Rpeaks(i,:))); % mean of RR intervals
%     semRR = std(diff(adj_Rpeaks(i,:)))/sqrt(numpeaks); % standard error of RR intervals
%     meanRamp = mean(leads(i,adj_Rpeaks(i,:))); % mean of R amplitudes
%     semRamp = std(leads(i,adj_Rpeaks(i,:)))/sqrt(numpeaks); % standard error of R amplitudes 
    
    % get features from R peaks 
    RR = diff(upd_Rpeaks(i,:))./Fs; % have to control for sampling frequency 
    meanRR = mean(RR); % mean of RR intervals
    medRR = median(RR); 
    maxRR = max(RR); 
    minRR = min(RR); 
    stdRR = std(RR); 
    semRR = stdRR/sqrt(numpeaks); % standard error of RR intervals
    skewRR = skewness(RR); 
    kurtRR = kurtosis(RR); 
    skewbRR = skewness(RR,0); 
    kurtbRR = kurtosis(RR,0);
    qRR = quantile(RR,4); 
    iqrRR = iqr(RR); 
    
    Ramp = leads(i,upd_Rpeaks(i,:)); 
    meanRamp = mean(Ramp); % mean of R amplitudes
    medRamp = median(Ramp); 
    maxRamp = max(Ramp); 
    minRamp = min(Ramp); 
    stdRamp = std(Ramp); 
    semRamp = stdRamp/sqrt(numpeaks); % standard error of RR intervals
    skewRamp = skewness(Ramp); 
    kurtRamp = kurtosis(Ramp); 
    skewbRamp = skewness(Ramp,0); 
    kurtbRamp = kurtosis(Ramp,0);
    qRamp = quantile(Ramp,4); 
    iqrRamp = iqr(Ramp); 
    
    % include number of outlier amplitudes or intervals or something? (I'm
    % wondering if the anomalies are getting washed out by the number of
    % normal peaks?) 
    
    % get features from S peaks 
    SS = diff(Speaks(i,:))./Fs; 
    meanSS = mean(SS); % mean of SS intervals
    medSS = median(SS); 
    maxSS = max(SS); 
    minSS = min(SS); 
    stdSS = std(SS); 
    semSS = stdSS/sqrt(numpeaks); % standard error of SS intervals
    skewSS = skewness(SS); 
    kurtSS = kurtosis(SS); 
    skewbSS = skewness(SS,0); 
    kurtbSS = kurtosis(SS,0);
    qSS = quantile(SS,4); 
    iqrSS = iqr(SS); 
    
    Samp = leads(i,Speaks(i,:)); 
    meanSamp = mean(Samp); % mean of S amplitudes
    medSamp = median(Samp); 
    maxSamp = max(Samp); 
    minSamp = min(Samp); 
    stdSamp = std(Samp); 
    semSamp = stdSamp/sqrt(numpeaks); % standard error of S amplitudes 
    skewSamp = skewness(Samp); 
    kurtSamp = kurtosis(Samp); 
    skewbSamp = skewness(Samp,0); 
    kurtbSamp = kurtosis(Samp,0); 
    qSamp = quantile(Samp,4); 
    iqrSamp = iqr(Samp); 
    
    % find T and P waves 
    movlead = movmean(leads(i,:),movnum); 
    if((i==4)||(i==7)) % T and P waves should be inverted
        movlead = -movlead; 
    end
%     figure(); plot(leads(i,:)); hold on; plot(movlead)
    % I'm only guaranteed numpeaks-1 T and P waves 
    Tpeaks = zeros(1,numpeaks-1); 
    Ppeaks = zeros(1,numpeaks-1); 
    baseTP = zeros(1,numpeaks-1); 
    PRamp = zeros(1,numpeaks-1); 
    STamp = zeros(1,numpeaks-1); 

    % get R/S amplitude ratio 
    base0 = zeros(1,numpeaks+1); % start by getting the baseline (for now, defined as mean between postS and Q)
    % get +1 to surround all peaks, take average of every pair to have one
    % value for comparison to each QRS complex 
    base0(1) = mean(leads(i,1:Qpeaks(i,1))); % weird first value 
    base0(numpeaks+1) = mean(leads(i,postS(i,numpeaks):end)); % weird last value 
    for j = 2:numpeaks % calc remaining baseline and T,P locations, PR ST elevations 
        base0(j) = mean(leads(i,postS(i,j-1):Qpeaks(i,j))); % middle 
        pSQint = postS(i,j-1):Qpeaks(i,j);
        if(~isempty(pSQint)) % happens when a lead goes dead
            halfint = int32(length(pSQint)/2);
            [~,Tind] = max(movlead(pSQint(1:halfint))); % define T as max of first half 
            Tpeaks(j-1) = Tind + pSQint(1) -1; 
            
            [~,Pind] = max(movlead(pSQint(halfint:end))); % define P as max of second half 
            Ppeaks(j-1) = Pind + pSQint(halfint) -1;
        
            [~,Bind] = min(movlead(Tpeaks(j-1):Ppeaks(j-1))); 
            Bind = Bind+Tpeaks(j-1)-1; 
            if(Bind>tfs)
                baseTP(j-1) = mean(leads(i,Bind-tfs:Bind+tfs)); 
            else
                baseTP(j-1) = mean(leads(i,1:Bind+tfs));
            end
        
            PRamp(j-1) = mean(leads(i,Ppeaks(j-1):Qpeaks(i,j))); 
            STamp(j-1) = mean(leads(i,postS(i,j-1):Tpeaks(j-1))); 
        else
            baseTP(j-1) = NaN; 
            PRamp(j-1) = NaN; 
            STamp(j-1) = NaN; 
            Tpeaks(j-1) = postS(i,j-1)+2; % arbitrary nonzero distance 
            Ppeaks(j-1) = Qpeaks(i,j)-2; 
        end
    end
    baseline = (base0(1:numpeaks)+base0(2:numpeaks+1))/2; % average 
      
    if(~isempty(baseTP(~isnan(baseTP)))) % if any value is not a NaN
         % switch "NaNs" for numerical NaNs [mean of remaining data]
        baseTP(isnan(baseTP)) = mean(baseTP(~isnan(baseTP))); 
        PRamp(isnan(PRamp)) = mean(PRamp(~isnan(PRamp))); 
        STamp(isnan(STamp)) = mean(STamp(~isnan(STamp))); 
    else % reset 
        baseTP = zeros(1,numpeaks-1);
        STamp = zeros(1,numpeaks-1);
        PRamp = zeros(1,numpeaks-1);
    end

    
    % adjust Ramp and Samp for baseline amplitude 
%     Ramp = (Ramp-baseline)./baseline; 
%     Samp = (Samp-baseline)./baseline; 

    RSrat = abs(Ramp-baseline)./abs(Samp-baseline); 
    meanRSrat = mean(RSrat); 
%     figure(); plot(leads(i,:)); title(meanRSratio)
    medRSrat = median(RSrat); 
    maxRSrat = max(RSrat); 
    minRSrat = min(RSrat); 
    stdRSrat = std(RSrat); 
    semRSrat = stdRSrat/sqrt(numpeaks); % standard error of RSrat
    skewRSrat = skewness(RSrat); 
    kurtRSrat = kurtosis(RSrat); 
    skewbRSrat = skewness(RSrat,0); 
    kurtbRSrat = kurtosis(RSrat,0);
    qRSrat = quantile(RSrat,4); 
    iqrRSrat = iqr(RSrat); 
    
    RSwidth = (Speaks(i,:)-upd_Rpeaks(i,:))./Fs; 
    meanRSwidth = mean(RSwidth); 
    medRSwidth = median(RSwidth); 
    maxRSwidth = max(RSwidth); 
    minRSwidth = min(RSwidth); 
    stdRSwidth = std(RSwidth); 
    semRSwidth = stdRSwidth/sqrt(numpeaks); % standard error of RSwidth 
    skewRSwidth = skewness(RSwidth); 
    kurtRSwidth = kurtosis(RSwidth); 
    skewbRSwidth = skewness(RSwidth,0); 
    kurtbRSwidth = kurtosis(RSwidth,0);
    qRSwidth = quantile(RSwidth,4); 
    iqrRSwidth = iqr(RSwidth); 
    
    % get S/postS amplitude ratio 
    pSamp = leads(i,postS(i,:));
    SpSrat = abs(pSamp-baseline)./abs(Samp-baseline); 
    meanSpSrat = mean(SpSrat); 
    medSpSrat = median(SpSrat); 
    maxSpSrat = max(SpSrat); 
    minSpSrat = min(SpSrat); 
    stdSpSrat = std(SpSrat); 
    semSpSrat = stdSpSrat/sqrt(numpeaks); % standard error of SpSrat
    skewSpSrat = skewness(SpSrat); 
    kurtSpSrat = kurtosis(SpSrat); 
    skewbSpSrat = skewness(SpSrat,0); 
    kurtbSpSrat = kurtosis(SpSrat,0);
    qSpSrat = quantile(SpSrat,4); 
    iqrSpSrat = iqr(SpSrat); 
    
    % get QRS width 
    QRS = (postS(i,:)-Qpeaks(i,:))./Fs; 
    meanQRS = mean(QRS);  
    medQRS = median(QRS); 
    maxQRS = max(QRS); 
    minQRS = min(QRS); 
    stdQRS = std(QRS); 
    semQRS = stdQRS/sqrt(numpeaks); % standard error of QRS
    skewQRS = skewness(QRS); 
    kurtQRS = kurtosis(QRS); 
    skewbQRS = skewness(QRS,0); 
    kurtbQRS = kurtosis(QRS,0);
    qQRS = quantile(QRS,4); 
    iqrQRS = iqr(QRS); 
    
    % calculate P features 
    Pamp = leads(i,Ppeaks); 
    meanPamp = mean(Pamp); % mean of P amplitudes 
    medPamp = median(Pamp); 
    maxPamp = max(Pamp); 
    minPamp = min(Pamp); 
    stdPamp = std(Pamp); 
    semPamp = stdPamp/sqrt(numpeaks); % standard error of Pamp
    skewPamp = skewness(Pamp); 
    kurtPamp = kurtosis(Pamp); 
    skewbPamp = skewness(Pamp,0); 
    kurtbPamp = kurtosis(Pamp,0); 
    qPamp = quantile(Pamp,4); 
    iqrPamp = iqr(Pamp); 
    
    PRlen = (upd_Rpeaks(i,2:end)-Ppeaks)./Fs; 
    meanPRlen = mean(PRlen); 
    medPRlen = median(PRlen); 
    maxPRlen = max(PRlen); 
    minPRlen = min(PRlen); 
    stdPRlen = std(PRlen); 
    semPRlen = stdPRlen/sqrt(numpeaks); % standard error of PRlen
    skewPRlen = skewness(PRlen); 
    kurtPRlen = kurtosis(PRlen); 
    skewbPRlen = skewness(PRlen,0); 
    kurtbPRlen = kurtosis(PRlen,0);
    qPRlen = quantile(PRlen,4); 
    iqrPRlen = iqr(PRlen); 
    
    meanPRamp = mean(PRamp); 
    medPRamp = median(PRamp); 
    maxPRamp = max(PRamp); 
    minPRamp = min(PRamp); 
    stdPRamp = std(PRamp); 
    semPRamp = stdPRamp/sqrt(numpeaks); % standard error of PRamp
    skewPRamp = skewness(PRamp); 
    kurtPRamp = kurtosis(PRamp);
    skewbPRamp = skewness(PRamp,0); 
    kurtbPRamp = kurtosis(PRamp,0);
    qPRamp = quantile(PRamp,4); 
    iqrPRamp = iqr(PRamp); 
    
    PRampB = PRamp-baseTP; 
    meanPRampB = mean(PRampB); 
    medPRampB = median(PRampB); 
    maxPRampB = max(PRampB); 
    minPRampB = min(PRampB); 
    stdPRampB = std(PRampB); 
    semPRampB = stdPRampB/sqrt(numpeaks); % standard error of PRampB
    skewPRampB = skewness(PRampB); 
    kurtPRampB = kurtosis(PRampB);
    skewbPRampB = skewness(PRampB,0); 
    kurtbPRampB = kurtosis(PRampB,0);
    qPRampB = quantile(PRampB,4); 
    iqrPRampB = iqr(PRampB); 
    
    % calculate T features 
    Tamp = leads(i,Tpeaks); 
    meanTamp = mean(Tamp); % mean of T amplitudes
    medTamp = median(Tamp); 
    maxTamp = max(Tamp); 
    minTamp = min(Tamp); 
    stdTamp = std(Tamp); 
    semTamp = stdTamp/sqrt(numpeaks); % standard error of Tamp
    skewTamp = skewness(Tamp); 
    kurtTamp = kurtosis(Tamp);
    skewbTamp = skewness(Tamp,0); 
    kurtbTamp = kurtosis(Tamp,0);
    qTamp = quantile(Tamp,4); 
    iqrTamp = iqr(Tamp); 
    
    STlen = (Tpeaks-Speaks(i,1:end-1))./Fs; 
    meanSTlen = mean(STlen); 
    medSTlen = median(STlen); 
    maxSTlen = max(STlen); 
    minSTlen = min(STlen); 
    stdSTlen = std(STlen); 
    semSTlen = stdSTlen/sqrt(numpeaks); % standard error of STlen
    skewSTlen = skewness(STlen); 
    kurtSTlen = kurtosis(STlen);
    skewbSTlen = skewness(STlen,0); 
    kurtbSTlen = kurtosis(STlen,0);
    qSTlen = quantile(STlen,4); 
    iqrSTlen = iqr(STlen); 
    
    meanSTamp = mean(STamp); 
    medSTamp = median(STamp); 
    maxSTamp = max(STamp); 
    minSTamp = min(STamp); 
    stdSTamp = std(STamp); 
    semSTamp = stdSTamp/sqrt(numpeaks); % standard error of STamp
    skewSTamp = skewness(STamp); 
    kurtSTamp = kurtosis(STamp);
    skewbSTamp = skewness(STamp,0); 
    kurtbSTamp = kurtosis(STamp,0);
    qSTamp = quantile(STamp,4); 
    iqrSTamp = iqr(STamp); 
    
    STampB = STamp-baseTP; 
    meanSTampB = mean(STampB); 
    medSTampB = median(STampB); 
    maxSTampB = max(STampB); 
    minSTampB = min(STampB); 
    stdSTampB = std(STampB); 
    semSTampB = stdSTampB/sqrt(numpeaks); % standard error of STampB
    skewSTampB = skewness(STampB); 
    kurtSTampB = kurtosis(STampB);
    skewbSTampB = skewness(STampB,0); 
    kurtbSTampB = kurtosis(STampB,0);
    qSTampB = quantile(STampB,4); 
    iqrSTampB = iqr(STampB); 
    
    
    end
    
    % stack features 
    Rfeats((i-1)*num_R_feats_per_lead+1:i*num_R_feats_per_lead) = [meanRR medRR maxRR minRR stdRR semRR skewRR kurtRR skewbRR kurtbRR qRR iqrRR meanRamp...
        medRamp maxRamp minRamp stdRamp semRamp skewRamp kurtRamp skewbRamp kurtbRamp qRamp iqrRamp];
    
    Sfeats((i-1)*num_S_feats_per_lead+1:i*num_S_feats_per_lead) = [meanSS medSS maxSS minSS stdSS semSS skewSS kurtSS skewbSS kurtbSS qSS iqrSS meanSamp...
        medSamp maxSamp minSamp stdSamp semSamp skewSamp kurtSamp skewbSamp kurtbSamp qSamp iqrSamp meanSpSrat medSpSrat maxSpSrat minSpSrat stdSpSrat semSpSrat skewSpSrat kurtSpSrat skewbSpSrat kurtbSpSrat qSpSrat iqrSpSrat];
    
    RSfeats((i-1)*num_RS_feats_per_lead+1:i*num_RS_feats_per_lead) = [meanRSrat medRSrat maxRSrat minRSrat stdRSrat semRSrat...
        skewRSrat kurtRSrat skewbRSrat kurtbRSrat qRSrat iqrRSrat meanRSwidth medRSwidth maxRSwidth minRSwidth stdRSwidth semRSwidth skewRSwidth kurtRSwidth skewbRSwidth kurtbRSwidth qRSwidth iqrRSwidth];  
    
    QRSfeats((i-1)*num_QRS_feats_per_lead+1:i*num_QRS_feats_per_lead) = [meanQRS medQRS maxQRS minQRS stdQRS semQRS skewQRS kurtQRS skewbQRS kurtbQRS qQRS iqrQRS];
    
    Pfeats((i-1)*num_P_feats_per_lead+1:i*num_P_feats_per_lead) = [meanPamp medPamp maxPamp minPamp stdPamp semPamp skewPamp kurtPamp skewbPamp kurtbPamp qPamp iqrPamp... 
        meanPRlen medPRlen maxPRlen minPRlen stdPRlen semPRlen skewPRlen kurtPRlen skewbPRlen kurtbPRlen qPRlen iqrPRlen...
        meanPRamp medPRamp maxPRamp minPRamp stdPRamp semPRamp skewPRamp kurtPRamp skewbPRamp kurtbPRamp qPRamp iqrPRamp...
        meanPRampB medPRampB maxPRampB minPRampB stdPRampB semPRampB skewPRampB kurtPRampB skewbPRampB kurtbPRampB qPRampB iqrPRampB]; 
    
    Tfeats((i-1)*num_T_feats_per_lead+1:i*num_T_feats_per_lead) = [meanTamp medTamp maxTamp minTamp stdTamp semTamp skewTamp kurtTamp skewbTamp kurtbTamp qTamp iqrTamp...
        meanSTlen medSTlen maxSTlen minSTlen stdSTlen semSTlen skewSTlen kurtSTlen skewbSTlen kurtbSTlen qSTlen iqrSTlen...
        meanSTamp medSTamp maxSTamp minSTamp stdSTamp semSTamp skewSTamp kurtSTamp skewbSTamp kurtbSTamp qSTamp iqrSTamp...
        meanSTampB medSTampB maxSTampB minSTampB stdSTampB semSTampB skewSTampB kurtSTampB skewbSTampB kurtbSTampB qSTampB iqrSTampB]; 
    
        
        
         
         
        
        
end
   


% use R peaks to find Q and S locations
    %   record mean, std of QRS width, R/S amplitude ratio (V1:V6)
    %   record QRS direction of all leads (I II V1 aVF possibly the most important) 
% locate P wave 
    %   record mean, std of amplitude
    %   record orientation (pos, neg, biphas) [assuming it exists] 
% locate T wave [max between R-R?] 
    %   record mean, std of amplitude
    %   record orientation and shape (diff(front)/diff(back) ratio) 
% measure TP baseline    
    %   record mean, std of PR length and elevation (compared to TP baseline) 
    %   record mean, std of ST elevation compared to TP baseline 
pqrst_features = [Rfeats Sfeats RSfeats QRSfeats Pfeats Tfeats]; 
end

function Rpeaks = find_R_peaks(lead,Fs,pplot)

    % start with the pan_tompkin algorithm, because that works pretty well
    % most of the time 
    [~,qrs_i_raw,~]=pan_tompkin(lead,Fs,pplot);

    % If this returns less than 2 R peaks, that's a problem. (3?) 
    % one case when this occurs is when there's a large spike that
    % dominates - either noise or an excessively large R peak. In the
    % case of it being an R peak, we don't want to eliminate it
    % completely. Can we bring it down to the average level of the
    % other R peaks? 
    
    % START WITH < 2, and if you see issues elsewhere consider expanding 
    % ie throw a flag if < outliers/10 or something. [you could have a
    % really high # of outliers or a low number of R peaks...] 
    ptplot = false; % true; % for troubleshooting pan tompkins issues 
    trouble = false; % true; % prints troubleshooting messages to the command line 
    no_outliers = false; 
    leadout = double(isoutlier(lead)); % this should create a square wave around fiducial points in the lead 
    diffout = diff(leadout); 
    [~,riseout] = findpeaks(diffout); % find rising edges
    riseout = riseout+1; 
    [~,fallout] = findpeaks(-diffout); % find falling edges 
    % cover cases where they don't have the same number of peaks 

    if(isempty(fallout)||isempty(riseout))
        if(trouble); fprintf('no outliers\n'); end % I've seen this happen for crazy baseline wander, not sure when else 
        no_outliers = true; 
    else
    if(fallout(1)<riseout(1)) % falls before it rises
        riseout = [1 riseout]; 
    end
    if(riseout(end)>fallout(end)) 
        fallout = [fallout length(leadout)];
    end
    midout = round((riseout+fallout)./2); 
    if(ptplot); figure(); plot(leadout); hold on; plot(riseout,leadout(riseout),'<r'); plot(fallout,leadout(fallout),'>b'); plot(midout,leadout(midout),'^m'); end; 
    numout = length(midout);
    if(length(qrs_i_raw)<numout/10)
        if(trouble); fprintf('low # R peaks or high # outliers\n'); end
        if(ptplot); figure(); plot(lead); hold on; plot((max(lead)/2)*leadout); end; 
    end
    end
    
    if((length(qrs_i_raw)<2)&& ~no_outliers)
        if(trouble); fprintf('pan tompkin issue\n'); end 
        % adjust the lead to smooth the noise 
        [yupper,ylower] = envelope(lead,Fs*60/200,'peak');
        [yupper2,~] = envelope(yupper,Fs*60/200,'peak');
        [~,ylower2] = envelope(ylower,Fs*60/200,'peak');
%         figure(); plot(lead); hold on; plot(yupper); plot(ylower); plot(yupper2); plot(ylower2); 
        
        % assumption: the low number of qrs complexes found is due to
        % elevated peaks overwhelming the algorithm. Solution: temper the
        % peaks 
        new_lead = lead; 
        
        % do the whole lead at the same time
        m1 = abs(mean(yupper2)); 
        m2 = abs(mean(ylower2)); 
        thresh = max(m1,m2); % thresh needs to go both ways for R>S and S>R
        overthresh = new_lead>thresh; % logical if over threshold. [peaks] 
        underthresh = new_lead<-thresh; % logical if under threshold in the opposite direction [troughs] 
        new_lead(overthresh) = thresh+(new_lead(overthresh)-thresh)*0.05; 
        new_lead(underthresh) = -thresh-(new_lead(underthresh)+thresh)*0.05; 
        
        % or try to do the peaks separately 
%         for p = 1:length(qrs_i_raw)
%             [~,minidx] = min(abs(midout-qrs_i_raw(p))); % find closest outier "peak" to current qrs_i_raw
%             bound = riseout(minidx):fallout(minidx); % find rising and falling edges of outlier square wave
%             % for all points in that wave above the threshold defined by the envelope, shrink down to average of envelope 
%             thresh = mean(yupper2); 
%             overthresh = new_lead>thresh; % logical if over threshold. [peaks] 
%             underthresh = new_lead<-thresh; % logical if under threshold in the opposite direction [troughs] 
%             bound_over = overthresh(bound); % logical all points in boundary over threshold 
%             bound_under = underthresh(bound); 
%             for b = 1:length(bound)
%                 if(bound_over(b))
%                     new_lead(bound(b)) = thresh+(new_lead(bound(b))-thresh)*0.05; 
%                 elseif(bound_under(b))
%                     new_lead(bound(b)) = -thresh-(new_lead(bound(b))+thresh)*0.05; 
%                 end
%             end
%         end
    
        
        % THIS IS ALL WORKING but now I have another issue: what to do if
        % it's picking up T or U waves as R peaks? Do I just need to switch
        % out my pan tomkins algorithm? Is there something more robust that
        % I can just switch in there? 
        
        % example: with this current patient, some of the leads are picking
        % up only true R, some are picking up only T, and some are picking
        % up both T and R. This can't be the first time. 
        
        
        [~,new_qrs_i_raw,~]=pan_tompkin(new_lead,Fs,pplot); % re-run pan tompkin algorithm
        if(ptplot); figure(); plot(lead,'r'); hold on; plot(new_lead,'k'); plot(qrs_i_raw,lead(qrs_i_raw),'xr'); plot(new_qrs_i_raw,lead(new_qrs_i_raw),'ob'); end; 
        Rpeaks = find_true_R(lead,new_qrs_i_raw);
    else
        Rpeaks = find_true_R(lead,qrs_i_raw);
    end
    
    
    
end


function Rpeaks = find_true_R(ECG,close_peaks)
% adapted from cleanECG 

Rpeaks = zeros(size(close_peaks));
for i = 1:length(close_peaks) % for every heartbeat
    peak = close_peaks(i);
    midval = 40; % large enough that there should be at least one peak 
    try
    if(peak>midval) % most cases 
        if(peak+midval>length(ECG))
            [~,Rpeakslocs] = findpeaks(ECG(peak-midval:length(ECG)));
            [~,mind] = min(abs(Rpeakslocs-midval));
            Rpeaks(i) = peak-midval+Rpeakslocs(mind)-1; 
        else
            [~,Rpeakslocs] = findpeaks(ECG(peak-midval:peak+midval));
            [~,mind] = min(abs(Rpeakslocs-midval));
            Rpeaks(i) = peak-midval+Rpeakslocs(mind)-1;
        end
    else % peak <= midval
        [~,Rpeakslocs] = findpeaks(ECG(1:peak+midval));
        [~,mind] = min(abs(Rpeakslocs-peak));
        Rpeaks(i) = Rpeakslocs(mind); 
    end
    catch
        Rpeaks(i) = peak; % I think the only thing left that would break this is extreme noise and a flat line
    end
  
end

% new_HR = 2000*60./diff(new_beats); 
% old_HR = 2000*60./diff(close_peaks); 

% figure();
% plot(ECG)
% hold on;
% plot(int32(close_peaks),ECG(int32(close_peaks)),'x')
% plot(int32(new_beats),ECG(int32(new_beats)),'o')
% title('difference in beat location'); xlabel('sample');
% legend('ECG','derivative peaks','R peaks')

% figure(); 
% plot(old_HR,'k')
% hold on; 
% plot(new_HR,'r')
% ylabel('HR'); xlabel('beat');
% legend('old HR','new HR')
% 
% figure();
% plot(diff(old_HR),'r')
% hold on;
% plot(diff(new_HR),'k')
% ylabel('diff(HR)'); xlabel('beat');
% legend('old HR','new HR')

end

function adj_Rpeaks = voteR(leads, Rpeaks) 
% takes R peaks, runs a majority vote on the number of peaks and then location
% for each peak, makes any necessary corrections to renegade leads, sends back 
% adjusted Rpeaks 

% start by finding the most common number of peaks. This is probably the
% most correct. 

num_peaks = []; 
leads12 = []; 
for i = 1:12
    if(sum(leads(i,:)==zeros(size(leads(i,:))))<size(leads(i,:),2)) % not a flat line
        num_peaks = [num_peaks length(Rpeaks{i})]; 
        leads12 = [leads12 i]; 
% num_peaks = [length(Rpeaks{1}) length(Rpeaks{2}) length(Rpeaks{3})...
%     length(Rpeaks{4}) length(Rpeaks{5}) length(Rpeaks{6}) length(Rpeaks{7})...
%     length(Rpeaks{8}) length(Rpeaks{9}) length(Rpeaks{10}) length(Rpeaks{11}) length(Rpeaks{12})];
    end
end

if(~isempty(num_peaks))
    maj_num_peaks = mode(num_peaks); 
else % all leads are flat lines 
    maj_num_peaks = 1; % placeholder. zero makes everything empty and NaN 
end

% leads12 = 1:12; 

majority = leads12(num_peaks == maj_num_peaks); 
above_maj = leads12(num_peaks > maj_num_peaks); 
below_maj = leads12(num_peaks < maj_num_peaks); 

% compare leads that have the same number of peaks
% find the largest cluster that is hopefully the right location
% figure(); hold on; 
maj_mat = zeros(length(majority),maj_num_peaks); 
for i = 1:length(majority)
%     plot(Rpeaks{majority(i)},'o')
    maj_mat(i,:) = Rpeaks{majority(i)}; 
end
TF = isoutlier(maj_mat); 
mean_peak_locs = zeros(1,maj_num_peaks); 
for i = 1:maj_num_peaks 
mean_peak_locs(i) = int32(mean(maj_mat(~TF(:,i),i)));
end

% compare leads that have non-majority length of peaks 
% what if I just cut at this point and find all peaks in off-leads closest
% to mean peak locations? might save a few steps...
adj_Rpeaks = ones(12,maj_num_peaks); % can't be zeros in case there's a flat line 
for i = 1:12
    [~,peaklocs] = findpeaks(leads(i,:)); 
    if(~isempty(peaklocs))
        [~,minidx] = min(abs(mean_peak_locs-peaklocs'));
        adj_Rpeaks(i,:) = peaklocs(minidx); 
    end
end


 
end


function [Speaks,R_fix,Qpeaks,postS] = findS(leads, adj_Rpeaks)
% choose min after Rpeak, should be S most of the time.
num_peaks = size(adj_Rpeaks,2);
s_peaks = zeros(12,num_peaks);

R_fix = adj_Rpeaks; % start with what we have
R_temp = adj_Rpeaks;

for i = 1:12
    [~,peaklocs] = findpeaks(-leads(i,:)); % find all potential S peaks [troughs]
    qopts{i} = peaklocs; % save this for later to find Qpeaks
    [~,ropts] = findpeaks(leads(i,:)); % find all potential R peaks if needed [peaks]
    post_s{i} = ropts; % save this for later to find postS points
    
    if(~isempty(peaklocs))
        allpeaks = union(ropts,peaklocs); % hoping to save time with this
        if(peaklocs(1)>ropts(1)) % there is a peak before the first trough
            r_odd = true; % ropts = posns 1 3 5 7...
        else
            r_odd = false;% ropts = posns 2 4 6 8...
        end
        
        % find all peaks after the R peaks
        peakmat1 = peaklocs'-adj_Rpeaks(i,:);
        peakmat1(peakmat1<0) = 1000; % replace all peaks before Rpeak with a large number
        [~,minidx] = min(peakmat1); % take min to find closest
        S2 = peaklocs(minidx);
        
        % find all peaks before the R peaks
        peakmat2 = peaklocs'-adj_Rpeaks(i,:);
        peakmat2(peakmat2>0) = -1000; % replace all peaks after Rpeak with a small number
        [~,maxidx] = max(peakmat2); % take max to find closest
        S1 = peaklocs(maxidx);
        
        Ramp = leads(i,adj_Rpeaks(i,:));
        S1amp = leads(i,S1);
        S2amp = leads(i,S2);
        
        R_S1 = abs(Ramp-S1amp);
        R_S2 = abs(Ramp-S2amp);
        ratio = R_S1./R_S2;
        
        magic_number = 1.25; % if ||R_S1||>>||R_S2||, choose S1 for S
        peakrange = 1:num_peaks;
        choose_1 = peakrange(ratio>magic_number);
        choose_2 = peakrange(ratio<=magic_number);
        
        s_peaks(i,choose_1) = S1(choose_1);
        s_peaks(i,choose_2) = S2(choose_2);
        
        % if you chose 1, fix R
        if(~isempty(choose_1))
            [~,S1map] = min(abs(allpeaks-S1(choose_1)')');
            S1map(S1map == 1) = 2; % can't have any 1's
            R_temp(i,choose_1) = allpeaks(int32(S1map-1)); % candidate R peak location if majority votes for S peak on left side
            
            %         if(r_odd)
            %             R_fix(i,choose_1) = 2*S1(choose_1)-1; % map to allpeaks?
            %         else
            %             R_fix(i,choose_1) = 2*S1(choose_1);
            %         end
        end
    end
end
% majority rules - kick outliers

TF = isoutlier(s_peaks);
mean_peak_locs = zeros(1,num_peaks);
for i = 1:num_peaks
    mean_peak_locs(i) = int32(mean(s_peaks(~TF(:,i),i)));
end

% use vote to inform chosen peaks
Speaks = ones(12,num_peaks); % can't be 0 in case there's a flat line
Qpeaks = ones(12,num_peaks); % can't be 0 in case there's a flat line
postS  = ones(12,num_peaks); % can't be 0 in case there's a flat line
for i = 1:12
    [~,peaklocs] = findpeaks(-leads(i,:));
    if(~isempty(peaklocs))
        [~,minidx] = min(abs(mean_peak_locs-peaklocs'));
        % sometimes it chooses the min after the S peak and the true S peak is
        % lower
        for j = 1:num_peaks
            if(adj_Rpeaks(i,j)<peaklocs(minidx(j))) % if S is after R
                [~,idx] = min(leads(i,adj_Rpeaks(i,j):peaklocs(minidx(j))));
                Speaks(i,j) = idx+adj_Rpeaks(i,j)-1;
            else % S is before R
                Speaks(i,j) = peaklocs(minidx(j));
                % choose the new R-peak location
                R_fix(i,j) = R_temp(i,j); % only choose new location if majority picks left side
            end
        end
        qpeakmat = qopts{i}'-R_fix(i,:);
        qpeakmat(qpeakmat>0) = -1000; % replace all peaks after Rpeak with a small number
        [~,maxidx] = max(qpeakmat); % take max to find closest
        Qpeaks(i,:) = qopts{i}(maxidx);
        
        pspeakmat = post_s{i}'-Speaks(i,:);
        pspeakmat(pspeakmat<0) = 1000; % replace all peaks before Rpeak with a large number
        [~,minidx] = min(pspeakmat); % take min to find closest
        if(~isempty(post_s{i}))
            postS(i,:) = post_s{i}(minidx);
        else
            postS(i,:) = ones(1,num_peaks); % can't be 0 in case there's a flat line
        end
    end
end

end