import glob
import numpy as np
from sklearn.metrics import average_precision_score
files = glob.glob("./test_outputs/*.csv")
files = sorted(files)


tmp = np.load("./model/results_004.npz")
tmp_targets = tmp["targets"]
tmp_outputs = tmp["outputs"]

q4 = np.sum(tmp_outputs>0.5,axis=0)
auprc0 = average_precision_score(y_true=tmp_targets,y_score=tmp_outputs)

from dataset import *

classes = []
outputs = []
labels = []

# files_gs = glob.glob("./data/_test/*.hea")
# files_gs = sorted(files_gs)
# test = dataset(files_gs)
#
# GS = []
# for _,t in test:
#     GS.append(t)
# GS = np.array(GS)

for filename in files:
    with open(filename,'r') as f:
        lines = f.readlines()
    classes = lines[1][:-1].split(',')
    tmp = lines[2][:-1].split(',')
    tmp = [int(k) for k in tmp]
    labels.append(tmp)
    tmp = lines[3][:-1].split(',')
    tmp = [float(k) for k in tmp]
    outputs.append(tmp)

classes = np.array(classes)
labels = np.array(labels)
outputs = np.array(outputs)
q0 = np.sum(labels,axis=0)

auprc1 = average_precision_score(y_true=tmp_targets,y_score=outputs)

data = np.load('output.npz')
_targets = data["labels"]
_classes = data["classes"]
_probs = data["scalars"]
_labels = data["outputs"]

q1 = np.sum(_labels,axis=0)

q2 = np.sum(_probs,axis=0)
q3 = np.sum(outputs,axis=0)


stop = 1