from keras.layers import Conv1D, BatchNormalization, MaxPooling1D, Dense, Permute, Reshape, Bidirectional, LSTM
from keras.models import Sequential
from keras.regularizers import l2

class CRNN:

	def __init__(self, num_classes=1):
		self.num_classes = num_classes
		self.model = Sequential()

	# TODO: tune model hyper-parameters
	def build_model(self, input_shape, weight_decay=0.001, convolution_activation='relu', padding='same',
					pool_size=2, strides=2, 
					output_layer_activation='sigmoid'):
		
		kernel_regularizer = l2(weight_decay)

		# Layer 1
		self.model.add(Conv1D(16, kernel_size=7, padding=padding, activation=convolution_activation,
							  kernel_regularizer=kernel_regularizer, input_shape=input_shape[1:]))
		self.model.add(MaxPooling1D(pool_size=pool_size, strides=strides))

		# Layer 2
		self.model.add(Conv1D(32, kernel_size=5, padding=padding, activation=convolution_activation,
							  kernel_regularizer=kernel_regularizer))
		#self.model.add(BatchNormalization())
		self.model.add(MaxPooling1D(pool_size=pool_size, strides=strides))

		# Layer 3
		self.model.add(Conv1D(64, kernel_size=3, padding=padding, activation=convolution_activation,
							  kernel_regularizer=kernel_regularizer))
		self.model.add(MaxPooling1D(pool_size=pool_size, strides=strides))

		self.model.add(BatchNormalization())



		self.model.add(Bidirectional(LSTM(100, return_sequences=False), merge_mode="concat"))
		self.model.add(BatchNormalization())

		self.model.add(Dense(self.num_classes, activation=output_layer_activation))

		print(self.model.summary())
		return self.model
