#!/usr/bin/env python

import numpy as np, os, sys
from keras.models import Sequential, load_model, model_from_json
import pandas as pd

def run_12ECG_classifier(data,header_data,loaded_model):

    df = pd.read_csv('dx_mapping_scored.csv')
    new_classes = df['SNOMED CT Code'].values
    classes = []
    for i in range(new_classes.shape[0]):
        classes.append(str(new_classes[i]))

    min_batch = []
    for j in range(0,data.shape[1],2500):
        segment_data = data[:,j:j+2500]
        if segment_data.shape[1] < 2500:
            break
        min_batch.append(segment_data[:,:].T)

    min_batch = np.array(min_batch)
    labels = loaded_model.predict(min_batch, verbose=0)
    # print (labels)
    scores = np.average(labels,axis=0)
    new_l = np.zeros(labels[0].shape[0])
    new_l[np.argmax(scores)] = 1
    return np.array(new_l, dtype=np.int), scores, classes

def load_12ECG_model(input_directory):
    json_file = open(str(input_directory)+'/model.json', 'r')
    loaded_model_json = json_file.read()
    json_file.close()
    loaded_model = model_from_json(loaded_model_json)
    loaded_model.load_weights(str(input_directory)+"/model.h5")
    loaded_model.compile(optimizer='adam', loss='categorical_crossentropy', metrics=['accuracy'])
    return loaded_model

# def run_12ECG_classifier_2(data,header_data,classes,model):
#     # print (model.summary())
#     max_length = 72000
#     if data.shape[1] > max_length:
#         data = data[:,:max_length]
#     data = np.transpose(np.hstack((data,np.zeros((12,max_length-data.shape[1])))))
#     data = data.reshape((1,data.shape[0],data.shape[1]))
#     labels = model.predict(data)
#     scores = []
#     for j in labels[0]:
#         if j == 0:
#             scores.append(0.03)
#         else:
#             scores.append(0.76)
#     return np.array(labels[0]), scores


# def generator(input_files, final_labels, batch_size):
#     min_batch = []
#     labels = []
#     while True:
#         for i, f in enumerate(input_files):

#             tmp_input_file = os.path.join(input_directory, f)
#             data = loadmat(tmp_input_file)['val']
#             for j in range(0,data.shape[1],3000):
#                 segment_data = data[:,j:j+3000]
#                 if segment_data.shape[1] < 3000:
#                     segment_data = data[:,-3000:]
#                 min_batch.append(segment_data[:,:].T)
#                 labels.append(final_labels[i])

#             if ((i+1)%batch_size == 0):
#                 X = np.array(min_batch)
#                 y = np.array(labels)
#                 min_batch = []
#                 labels = []
#                 yield X,y
#             elif (i+1)==len(input_files):
#                 X = np.array(min_batch)
#                 y = np.array(labels)
#                 min_batch = []
#                 labels = []
#                 yield X,y

# def ResNet_model(WINDOW_SIZE,INPUT_FEAT,OUTPUT_CLASS):
#     # Add CNN layers left branch (higher frequencies)
#     # Parameters from paper
#     k = 1    # increment every 4th residual block
#     p = True # pool toggle every other residual block (end with 2^8)
#     convfilt = 64
#     convstr = 1
#     ksize = 16
#     poolsize = 2
#     poolstr  = 2
#     drop = 0.5
    
#     # Modelling with Functional API
#     #input1 = Input(shape=(None,1), name='input')
#     input1 = Input(shape=(WINDOW_SIZE,INPUT_FEAT), name='input')
    
#     ## First convolutional block (conv,BN, relu)
#     x = Conv1D(filters=convfilt,
#                kernel_size=ksize,
#                padding='same',
#                strides=convstr,
#                kernel_initializer='he_normal')(input1)                
#     x = BatchNormalization()(x)        
#     x = Activation('relu')(x)  
    
#     ## Second convolutional block (conv, BN, relu, dropout, conv) with residual net
#     # Left branch (convolutions)
#     x1 =  Conv1D(filters=convfilt,
#                kernel_size=ksize,
#                padding='same',
#                strides=convstr,
#                kernel_initializer='he_normal')(x)      
#     x1 = BatchNormalization()(x1)    
#     x1 = Activation('relu')(x1)
#     x1 = Dropout(drop)(x1)
#     x1 =  Conv1D(filters=convfilt,
#                kernel_size=ksize,
#                padding='same',
#                strides=convstr,
#                kernel_initializer='he_normal')(x1)
#     x1 = MaxPooling1D(pool_size=poolsize,
#                       strides=poolstr)(x1)
#     # Right branch, shortcut branch pooling
#     x2 = MaxPooling1D(pool_size=poolsize,
#                       strides=poolstr)(x)
#     # Merge both branches
#     x = keras.layers.add([x1, x2])
#     del x1,x2
    
#     ## Main loop
#     p = not p 
#     for l in range(15):
        
#         if (l%4 == 0) and (l>0): # increment k on every fourth residual block
#             k += 1
#              # increase depth by 1x1 Convolution case dimension shall change
#             xshort = Conv1D(filters=convfilt*k,kernel_size=1)(x)
#         else:
#             xshort = x        
#         # Left branch (convolutions)
#         # notice the ordering of the operations has changed        
#         x1 = BatchNormalization()(x)
#         x1 = Activation('relu')(x1)
#         x1 = Dropout(drop)(x1)
#         x1 =  Conv1D(filters=convfilt*k,
#                kernel_size=ksize,
#                padding='same',
#                strides=convstr,
#                kernel_initializer='he_normal')(x1)        
#         x1 = BatchNormalization()(x1)
#         x1 = Activation('relu')(x1)
#         x1 = Dropout(drop)(x1)
#         x1 =  Conv1D(filters=convfilt*k,
#                kernel_size=ksize,
#                padding='same',
#                strides=convstr,
#                kernel_initializer='he_normal')(x1)        
#         if p:
#             x1 = MaxPooling1D(pool_size=poolsize,strides=poolstr)(x1)                

#         # Right branch: shortcut connection
#         if p:
#             x2 = MaxPooling1D(pool_size=poolsize,strides=poolstr)(xshort)
#         else:
#             x2 = xshort  # pool or identity            
#         # Merging branches
#         x = keras.layers.add([x1, x2])
#         # change parameters
#         p = not p # toggle pooling

    
#     # Final bit    
#     x = BatchNormalization()(x)
#     x = Activation('relu')(x) 
#     x = Flatten()(x)
#     #x = Dense(1000)(x)
#     #x = Dense(1000)(x)
#     out = Dense(OUTPUT_CLASS, activation='softmax')(x)
#     model = Model(inputs=input1, outputs=out)
#     model.compile(optimizer='adam',
#                   loss='categorical_crossentropy',
#                   metrics=['accuracy'])
#     #model.summary()
#     return model


# def train_model(input_files, final_labels):

#     # model = ResNet_model(WINDOW_SIZE,INPUT_FEAT,OUTPUT_CLASS)
#     model = ResNet_model(3000,12,9)
#     batch_size = 64
#     train_X = len(input_files)
#     train_generator = generator(input_files, final_labels, batch_size)
#     train_samples=np.ceil(train_X / batch_size)
#     model.fit_generator(train_generator, steps_per_epoch=train_samples, epochs=100, verbose=1)

#     save = 'resnet_15'

#     # Save Model
#     model_json = model.to_json()
#     with open("model_"+str(save)+".json", "w") as json_file:
#         json_file.write(model_json)
#     # serialize weights to HDF5
#     model.save_weights("model_"+str(save)+".h5")
#     print("Saved")
#     return model


# def run_12ECG_classifier_1(data,header_data,classes,model):

#     num_classes = len(classes)
#     current_label = np.zeros(num_classes, dtype=int)
#     current_score = np.zeros(num_classes)

#     # Use your classifier here to obtain a label and score for each class. 
#     features=np.asarray(get_12ECG_features(data,header_data))
#     feats_reshape = features.reshape(1,-1)
#     label = model.predict(feats_reshape)
#     score = model.predict_proba(feats_reshape)

#     current_label[label] = 1

#     for i in range(num_classes):
#         current_score[i] = np.array(score[0][i])

#     return current_label, current_score

# def load_12ECG_model_1():
#     # load the model from disk 
#     filename='finalized_model.sav'
#     loaded_model = joblib.load(filename)
#     return loaded_model


# def to_cat(final_labels,classes):
#     s = 0
#     final_labels_1 = np.zeros((len(final_labels),len(classes)))
#     for index,i in enumerate(final_labels):
#         s = max(s,len(i))
#         if len(i) > 1:
#             for index_1,j in enumerate(i):
#                 final_labels_1[index][i[index_1]]=1
#         else:
#             final_labels_1[index][i[0]]=1
#     return final_labels_1,s


# def generator(input_files, final_labels, batch_size):
#     max_length = 72000
#     final_data = []
#     while True:
#         counter = 0
#         for i, f in enumerate(input_files):
#             counter = counter + 1

#             tmp_input_file = os.path.join(input_directory, f)
#             data, header_data = load_challenge_data(tmp_input_file)
#             if data.shape[1] > max_length:
#                 data = data[:,:72000]
#             data = np.transpose(np.hstack((data,np.zeros((12,max_length-data.shape[1])))))
# #             for lines in header_data:
# #                 if lines.startswith('#Dx'):
# #                     tmp = lines.split(': ')[1].split(',')[0]

# #             location = classes.index(tmp.strip())

# #             final_labels.append(location)
#             final_data.append(data)

#             if(counter%batch_size == 0):
#                 X = np.array(final_data)
# #                 y = keras.utils.to_categorical(np.array(final_labels))
#                 final_data = []
# #                 final_labels = []
#                 yield X,final_labels[counter-batch_size:counter,:]
#             elif counter==len(input_files):
#                 X = np.array(final_data)
#                 final_data = []
#                 yield X,final_labels[counter-counter%batch_size:counter,:]
