function [ features ] = soa_features(ecg, fs, qrs)

% 
% Copyright (C) 2017 
% Shreyasi Datta
% Chetanya Puri
% Ayan Mukherjee
% Rohan Banerjee
% Anirban Dutta Choudhury
% Arijit Ukil
% Soma Bandyopadhyay
% Rituraj Singh
% Arpan Pal
% Sundeep Khandelwal
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
%SOA_FEATURES Summary of this function goes here
%   Detailed explanation goes here

features = [];
wavelet_feat = [];

RR = diff(qrs')/fs;
ploc = [];

if length(qrs) < 6
    features = zeros(1,8);
    return
end

mean_RR = mean(RR); % feature 4
% median_RR = median(RR); % feature 5
% min_RR = min(RR);
% max_RR = max(RR);
diffNN = diff(RR);
RMSSD = sqrt(mean(diffNN.^2));% root mean square of successive differences
nRMSSD = RMSSD/mean_RR; % feature 1

% Wavelet Entropy
% Esh = wentropy(RR,'shannon'); % feature 2

% MAD of RR
mad_RR = mad(RR); % feature 3

% SD_R = std(RR); % feature 6

%hrv features
hrv = hrv_features(qrs, 2, length(ecg), fs);
features = [nRMSSD mad_RR hrv];

end
