function newpeaks = shift_peaks(peaks,signal,interval_search)
% shift the ECG peaks (all of them) to the left or to the right, untill the peaks are found (there is an offset for some of the algos - find it!)
% find new peaks within signal by shifting all current peaks (locked, simultaneously) in an interval_search
% eg:
% ecgpeaks = shift_peaks(ecgpeaks,handles.ECG.leads{1},81);

b = zeros(interval_search,1); % zeros(101,1)
for pp = -(interval_search-1)/2 : (interval_search-1)/2 % -50:50
    a = (peaks - pp); a = a(a>0 & a<length(signal));
    b(pp+(interval_search-1)/2+1) = mean(signal(a));
end
[~,b] = max(b); % find(b==max(b))
b = (interval_search-1)/2 - b + 1;
peaks = peaks + b;
newpeaks = peaks(peaks>0 & peaks<length(signal)); % just in case...
end