function anns_test = run_ecgpuwave(ecg, Fs, gain)

cwd = pwd;

mydir = pwd; mydir = [mydir filesep];

fmt = 16;

%wrsamp((0:length(-ecg)-1)',0.25*250*(ecg/std(ecg)),'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
%wrsamp((0:length(-ecg)-1)',0.25*250*(ecg/std(ecg)),'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically
wrsamp((0:length(-ecg)-1)',ecg,'PatID_wrsamp',Fs,gain,num2str(fmt)); % NOTE: lead description/name is NOT provided, so " col 1" name is generated automatically

%wfdb_argument = [{'-r'}, {'PatID_wrsamp'}, {'-f'}, {'s0'}];
wfdb_argument = [{'-r'}, {'PatID_wrsamp'}, {'-a'}, {'puw'}];
javaWfdbExec=getWfdbClass('ecgpuwave');
err=javaWfdbExec.execToStringList(wfdb_argument);
if(~isempty(strfind(err.toString,['annopen: can''t'])))
    error(err)
end

file_name_orig = [mydir 'PatID_wrsamp.puw'];
try
    % anns_test = readannot(file_name_orig); % in which folder is this file ??
    heasig.freq = 250; heasig.nsamp = length(ecg); t = [1 length(ecg)]; anns_test = run_readannot(file_name_orig,heasig,t);
catch
    disp('Error in readannot')
    anns_test.time = [];
    anns_test.anntyp = [];
end
delete(file_name_orig);
cd(cwd);

end