function leads = resample_ecg(data, Fs, doround)

    Fs_new = 500;

    signal = data';

    n = size(signal,1);
    freq = Fs;
    leads = zeros(round(size(signal,1)*Fs_new/freq),size(signal,2));

    if freq ~= Fs_new
        for i=1:size(signal,2)
            
            x = (1:n)*(1000/freq);
            v = signal(1:n,i);
            xq = (1:round(n*(Fs_new/freq)))*(1000/Fs_new);
            
            leads(:,i) = interp1(x,v,xq,'linear','extrap')';
            
            if doround
               leads(:,i) = round( leads(:,i) );
            end
        end
    else
        leads = signal;
    end

    leads = leads';