function [ F ] = other_features_new( ecg, fs )
% 
% Copyright (C) 2017 
% Shreyasi Datta
% Chetanya Puri
% Ayan Mukherjee
% Rohan Banerjee
% Anirban Dutta Choudhury
% Arijit Ukil
% Soma Bandyopadhyay
% Rituraj Singh
% Arpan Pal
% Sundeep Khandelwal
% 
% This program is free software; you can redistribute it and/or
% modify it under the terms of the GNU General Public License
% as published by the Free Software Foundation; either version 2
% of the License, or (at your option) any later version.
% 
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

%OTHER_FEATURES Summary of this function goes here
%   Detailed explanation goes here


N = length(ecg);
% xdft = fft(ecg);
% xdft = xdft(1:N/2+1);
% psdx = (1/(2*pi*N)) * abs(xdft).^2;
% psdx(2:end-1) = 2*psdx(2:end-1);
% 
% f = fs*(0:(N/2))/N;
% frequency_centroid = (sum(f'.*(psdx.^2)))/(sum(psdx.^2));   %26
%-------------------------------------------------------------
nbins = 50;
[counts,centers] = hist(ecg,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(ecg)
    p1 = find(ecg(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end

% find locations where p = 0; the p needs to be removed in those
% cases. This is done to bypass NaN situations
loc_0 = find(p==0);
p(loc_0) = [];

p = p / length(ecg);
q = 2;
Shannon = -1*sum(p.*log(p));                                %29
Tsallis = (1/(q-1))*sum(1 - p.^q);                          %31
%-------------------------------------------------------------
clear p counts centers thr
[counts,centers] = hist(ecg,nbins);
thr = mean((diff(centers))/2);
centers(2,:) = centers + thr;
for i=1:length(ecg)
    p1 = find(ecg(i)<=centers(2,:));
    if ~isempty(p1)
        p(i) = counts(p1(1));
    else
        p(i) = counts(end);
    end
end
p = p / length(ecg);
q = 2;
Renyi = (1/(q-1))*log(sum(p.^q));                        %36

F = [Shannon Tsallis Renyi];


end

